/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.gui.JLabeledTextArea;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.gui.ObjectTableModel;

public class RowDetailDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 6578889215615435475L;
    private static final String NEXT = "next";
    private static final String PREVIOUS = "previous";
    private static final String CLOSE = "close";
    private static final String UPDATE = "update";
    private JLabeledTextField nameTF;
    private JLabeledTextArea valueTA;
    private JButton updateButton;
    private JButton nextButton;
    private JButton previousButton;
    private JButton closeButton;
    private ObjectTableModel tableModel;
    private int selectedRow;
    private transient ActionListener enterActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            RowDetailDialog.this.doUpdate(actionEvent);
            RowDetailDialog.this.setVisible(false);
        }
    };
    private transient ActionListener escapeActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            RowDetailDialog.this.setVisible(false);
        }
    };

    public RowDetailDialog() {
    }

    public RowDetailDialog(ObjectTableModel tableModel, int selectedRow) {
        super((Frame)null, JMeterUtils.getResString("detail"), true);
        this.tableModel = tableModel;
        this.selectedRow = selectedRow;
        this.init();
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.nameTF = new JLabeledTextField(JMeterUtils.getResString("name"), 20);
        this.valueTA = new JLabeledTextArea(JMeterUtils.getResString("value"));
        this.valueTA.setPreferredSize(new Dimension(450, 300));
        this.setValues(this.selectedRow);
        JPanel detailPanel = new JPanel();
        detailPanel.setLayout(new BorderLayout());
        detailPanel.add((Component)this.nameTF, "North");
        detailPanel.add((Component)this.valueTA, "Center");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(7, 3, 3, 3));
        mainPanel.add((Component)detailPanel, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        this.updateButton = new JButton(JMeterUtils.getResString(UPDATE));
        this.updateButton.setActionCommand(UPDATE);
        this.updateButton.addActionListener(this);
        this.closeButton = new JButton(JMeterUtils.getResString(CLOSE));
        this.closeButton.setActionCommand(CLOSE);
        this.closeButton.addActionListener(this);
        this.nextButton = new JButton(JMeterUtils.getResString(NEXT));
        this.nextButton.setActionCommand(NEXT);
        this.nextButton.addActionListener(this);
        this.nextButton.setEnabled(this.selectedRow < this.tableModel.getRowCount() - 1);
        this.previousButton = new JButton(JMeterUtils.getResString(PREVIOUS));
        this.previousButton.setActionCommand(PREVIOUS);
        this.previousButton.addActionListener(this);
        this.previousButton.setEnabled(this.selectedRow > 0);
        buttonsPanel.add(this.updateButton);
        buttonsPanel.add(this.previousButton);
        buttonsPanel.add(this.nextButton);
        buttonsPanel.add(this.closeButton);
        mainPanel.add((Component)buttonsPanel, "South");
        this.getContentPane().add(mainPanel);
        mainPanel.registerKeyboardAction(this.enterActionListener, KeyStrokes.ENTER, 2);
        mainPanel.registerKeyboardAction(this.escapeActionListener, KeyStrokes.ESC, 2);
        this.nameTF.requestFocusInWindow();
        this.pack();
        ComponentUtil.centerComponentInWindow((Component)this);
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(CLOSE)) {
            this.setVisible(false);
        } else if (action.equals(NEXT)) {
            ++this.selectedRow;
            this.previousButton.setEnabled(true);
            this.nextButton.setEnabled(this.selectedRow < this.tableModel.getRowCount() - 1);
            this.setValues(this.selectedRow);
        } else if (action.equals(PREVIOUS)) {
            --this.selectedRow;
            this.nextButton.setEnabled(true);
            this.previousButton.setEnabled(this.selectedRow > 0);
            this.setValues(this.selectedRow);
        } else if (action.equals(UPDATE)) {
            this.doUpdate(e);
        }
    }

    private void setValues(int selectedRow) {
        this.nameTF.setText((String)this.tableModel.getValueAt(selectedRow, 0));
        this.valueTA.setText((String)this.tableModel.getValueAt(selectedRow, 1));
    }

    protected void doUpdate(ActionEvent actionEvent) {
        this.tableModel.setValueAt((Object)this.nameTF.getText(), this.selectedRow, 0);
        this.tableModel.setValueAt((Object)this.valueTA.getText(), this.selectedRow, 1);
    }
}

