/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.Data;

public class SimpleConfigGui
extends AbstractConfigGui
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private JTable table;
    private PowerTableModel tableModel;
    private JButton add;
    private JButton delete;
    private static final String ADD = "add";
    private static final String DELETE = "delete";
    private final boolean displayName;
    private static final String COLUMN_NAMES_0 = "name";
    private static final String COLUMN_NAMES_1 = "value";

    public SimpleConfigGui() {
        this(true);
    }

    public SimpleConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public String getLabelResource() {
        return "simple_config_element";
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.tableModel.clearData();
        PropertyIterator iter = el.propertyIterator();
        while (iter.hasNext()) {
            JMeterProperty prop = iter.next();
            this.tableModel.addRow(new Object[]{prop.getName(), prop.getStringValue()});
        }
        this.checkDeleteStatus();
    }

    public TestElement createTestElement() {
        ConfigTestElement el = new ConfigTestElement();
        this.modifyTestElement(el);
        return el;
    }

    public void modifyTestElement(TestElement el) {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        Data model = this.tableModel.getData();
        model.reset();
        while (model.next()) {
            el.setProperty(new StringProperty((String)model.getColumnValue(COLUMN_NAMES_0), (String)model.getColumnValue(COLUMN_NAMES_1)));
        }
        super.configureTestElement(el);
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 10));
        if (this.displayName) {
            this.setBorder(this.makeBorder());
            this.add((Component)this.makeTitlePanel(), "North");
        }
        this.add(this.createTablePanel(), "Center");
        this.add(Box.createVerticalStrut(70), "West");
        this.add((Component)this.createButtonPanel(), "South");
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(DELETE)) {
            this.deleteArgument();
        } else if (action.equals(ADD)) {
            this.addArgument();
        }
    }

    private Component createTablePanel() {
        this.tableModel = new PowerTableModel(new String[]{COLUMN_NAMES_0, COLUMN_NAMES_1}, new Class[]{String.class, String.class});
        this.table = new JTable(this.tableModel);
        this.table.getTableHeader().setDefaultRenderer(new HeaderAsPropertyRenderer());
        this.table.setSelectionMode(0);
        return this.makeScrollPane(this.table);
    }

    private JPanel createButtonPanel() {
        this.add = new JButton(JMeterUtils.getResString(ADD));
        this.add.setActionCommand(ADD);
        this.add.addActionListener(this);
        this.add.setEnabled(true);
        this.delete = new JButton(JMeterUtils.getResString(DELETE));
        this.delete.setActionCommand(DELETE);
        this.delete.addActionListener(this);
        this.checkDeleteStatus();
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.add);
        buttonPanel.add(this.delete);
        return buttonPanel;
    }

    protected void checkDeleteStatus() {
        if (this.tableModel.getRowCount() == 0) {
            this.delete.setEnabled(false);
        } else {
            this.delete.setEnabled(true);
        }
    }

    protected void addArgument() {
        this.stopTableEditing();
        this.tableModel.addNewRow();
        this.tableModel.fireTableDataChanged();
        this.delete.setEnabled(true);
        int rowToSelect = this.tableModel.getRowCount() - 1;
        this.table.setRowSelectionInterval(rowToSelect, rowToSelect);
    }

    protected void stopTableEditing() {
        if (this.table.isEditing()) {
            TableCellEditor cellEditor = this.table.getCellEditor(this.table.getEditingRow(), this.table.getEditingColumn());
            cellEditor.stopCellEditing();
        }
    }

    protected void deleteArgument() {
        int rowSelected;
        if (this.table.isEditing()) {
            TableCellEditor cellEditor = this.table.getCellEditor(this.table.getEditingRow(), this.table.getEditingColumn());
            cellEditor.cancelCellEditing();
        }
        if ((rowSelected = this.table.getSelectedRow()) >= 0) {
            this.tableModel.removeRow(rowSelected);
            this.tableModel.fireTableDataChanged();
            if (this.tableModel.getRowCount() == 0) {
                this.delete.setEnabled(false);
            } else {
                int rowToSelect = rowSelected;
                if (rowSelected >= this.tableModel.getRowCount()) {
                    rowToSelect = rowSelected - 1;
                }
                this.table.setRowSelectionInterval(rowToSelect, rowToSelect);
            }
        }
    }
}

