/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.engine.util.FunctionParser;
import org.apache.jmeter.engine.util.SimpleVariable;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundVariable
implements Function {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private String rawParameters;
    private static final FunctionParser functionParser = new FunctionParser();
    private static final Map<String, Class<? extends Function>> functions = new HashMap<String, Class<? extends Function>>();
    private boolean hasFunction = false;
    private boolean isDynamic = true;
    private String permanentResults = "";
    private LinkedList<Object> compiledComponents = new LinkedList();

    public CompoundVariable() {
    }

    public CompoundVariable(String parameters) {
        this();
        try {
            this.setParameters(parameters);
        }
        catch (InvalidVariableException invalidVariableException) {
            // empty catch block
        }
    }

    public String execute() {
        if (this.isDynamic) {
            JMeterContext context = JMeterContextService.getContext();
            SampleResult previousResult = context.getPreviousResult();
            Sampler currentSampler = context.getCurrentSampler();
            return this.execute(previousResult, currentSampler);
        }
        return this.permanentResults;
    }

    public String getRawParameters() {
        return this.rawParameters;
    }

    @Override
    public String execute(SampleResult previousResult, Sampler currentSampler) {
        if (this.compiledComponents == null || this.compiledComponents.size() == 0) {
            return "";
        }
        boolean testDynamic = false;
        StringBuilder results = new StringBuilder();
        for (Object e : this.compiledComponents) {
            if (e instanceof Function) {
                testDynamic = true;
                try {
                    results.append(((Function)e).execute(previousResult, currentSampler));
                }
                catch (InvalidVariableException e2) {}
                continue;
            }
            if (e instanceof SimpleVariable) {
                testDynamic = true;
                results.append(((SimpleVariable)e).toString());
                continue;
            }
            results.append(e);
        }
        if (!testDynamic) {
            this.isDynamic = false;
            this.permanentResults = results.toString();
        }
        return results.toString();
    }

    public CompoundVariable getFunction() {
        CompoundVariable func = new CompoundVariable();
        func.compiledComponents = (LinkedList)this.compiledComponents.clone();
        func.rawParameters = this.rawParameters;
        return func;
    }

    @Override
    public List<String> getArgumentDesc() {
        return new LinkedList<String>();
    }

    public void clear() {
        this.hasFunction = false;
        this.compiledComponents.clear();
    }

    public void setParameters(String parameters) throws InvalidVariableException {
        this.rawParameters = parameters;
        if (parameters == null || parameters.length() == 0) {
            return;
        }
        this.compiledComponents = functionParser.compileString(parameters);
        if (this.compiledComponents.size() > 1 || !(this.compiledComponents.get(0) instanceof String)) {
            this.hasFunction = true;
        }
    }

    static Object getNamedFunction(String functionName) throws InvalidVariableException {
        if (functions.containsKey(functionName)) {
            try {
                return functions.get(functionName).newInstance();
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw new InvalidVariableException();
            }
        }
        return new SimpleVariable(functionName);
    }

    public static Class<? extends Function> getFunctionClass(String className) {
        return functions.get(className);
    }

    public static String[] getFunctionNames() {
        return functions.keySet().toArray(new String[functions.size()]);
    }

    public boolean hasFunction() {
        return this.hasFunction;
    }

    @Override
    public String getReferenceKey() {
        return "";
    }

    @Override
    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
    }

    static {
        try {
            String contain = JMeterUtils.getProperty("classfinder.functions.contain");
            String notContain = JMeterUtils.getProperty("classfinder.functions.notContain");
            if (contain != null) {
                log.info("Note: Function class names must contain the string: '" + contain + "'");
            }
            if (notContain != null) {
                log.info("Note: Function class names must not contain the string: '" + notContain + "'");
            }
            List classes = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{Function.class}, (boolean)true, (String)contain, (String)notContain);
            Iterator iter = classes.iterator();
            while (iter.hasNext()) {
                Function tempFunc = (Function)Class.forName((String)iter.next()).newInstance();
                String referenceKey = tempFunc.getReferenceKey();
                if (referenceKey.length() <= 0) continue;
                functions.put(referenceKey, tempFunc.getClass());
                if (!referenceKey.equals("__StringFromFile")) continue;
                functions.put("_StringFromFile", tempFunc.getClass());
            }
            int functionCount = functions.size();
            if (functionCount == 0) {
                log.warn("Did not find any functions");
            } else {
                log.debug("Function count: " + functionCount);
            }
        }
        catch (Exception err) {
            log.error("", (Throwable)err);
        }
    }
}

