/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.util.JMeterUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteSampleListenerImpl
extends UnicastRemoteObject
implements RemoteSampleListener,
SampleListener,
TestListener {
    private static final long serialVersionUID = 240L;
    private final TestListener testListener;
    private final SampleListener sampleListener;
    private static final int DEFAULT_LOCAL_PORT = JMeterUtils.getPropDefault("client.rmi.localport", 0);

    public RemoteSampleListenerImpl(Object listener) throws RemoteException {
        super(DEFAULT_LOCAL_PORT);
        this.testListener = listener instanceof TestListener ? (TestListener)listener : null;
        this.sampleListener = listener instanceof SampleListener ? (SampleListener)listener : null;
    }

    @Override
    public void testStarted() {
        if (this.testListener != null) {
            this.testListener.testStarted();
        }
    }

    @Override
    public void testStarted(String host) {
        if (this.testListener != null) {
            this.testListener.testStarted(host);
        }
    }

    @Override
    public void testEnded() {
        if (this.testListener != null) {
            this.testListener.testEnded();
        }
    }

    @Override
    public void testEnded(String host) {
        if (this.testListener != null) {
            this.testListener.testEnded(host);
        }
    }

    @Override
    public void testIterationStart(LoopIterationEvent event) {
        if (this.testListener != null) {
            this.testListener.testIterationStart(event);
        }
    }

    @Override
    public void processBatch(List<SampleEvent> samples) {
        if (samples != null && this.sampleListener != null) {
            for (SampleEvent e : samples) {
                this.sampleListener.sampleOccurred(e);
            }
        }
    }

    @Override
    public void sampleOccurred(SampleEvent e) {
        if (this.sampleListener != null) {
            this.sampleListener.sampleOccurred(e);
        }
    }

    @Override
    public void sampleStarted(SampleEvent e) {
        if (this.sampleListener != null) {
            this.sampleListener.sampleStarted(e);
        }
    }

    @Override
    public void sampleStopped(SampleEvent e) {
        if (this.sampleListener != null) {
            this.sampleListener.sampleStopped(e);
        }
    }
}

