/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.services;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.collections.ArrayStack;
import org.apache.jmeter.gui.JMeterFileFilter;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class FileServer {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String DEFAULT_BASE = System.getProperty("user.dir");
    private static final String BASE_PREFIX_DEFAULT = "~/";
    private static final String BASE_PREFIX = JMeterUtils.getPropDefault("jmeter.save.saveservice.base_prefix", "~/");
    private File base;
    private final Map<String, FileEntry> files = new HashMap<String, FileEntry>();
    private static final FileServer server = new FileServer();
    private final Random random = new Random();
    private String scriptName;

    private FileServer() {
        this.base = new File(DEFAULT_BASE);
        log.info("Default base='" + DEFAULT_BASE + "'");
    }

    public static FileServer getFileServer() {
        return server;
    }

    public synchronized void resetBase() {
        this.base = new File(DEFAULT_BASE);
        log.info("Reset base to'" + this.base + "'");
    }

    public synchronized void setBasedir(String basedir) {
        this.checkForOpenFiles();
        if (basedir != null) {
            this.base = new File(basedir);
            if (!this.base.isDirectory()) {
                this.base = this.base.getParentFile();
            }
            log.info("Set new base='" + this.base + "'");
        }
    }

    public synchronized void setBaseForScript(File scriptPath) {
        if (scriptPath == null) {
            throw new IllegalArgumentException("scriptPath must not be null");
        }
        this.setScriptName(scriptPath.getName());
        this.setBase(scriptPath.getAbsoluteFile().getParentFile());
    }

    public synchronized void setBase(File jmxBase) {
        if (jmxBase == null) {
            throw new IllegalArgumentException("jmxBase must not be null");
        }
        this.checkForOpenFiles();
        this.base = jmxBase;
        log.info("Set new base='" + this.base + "'");
    }

    private void checkForOpenFiles() throws IllegalStateException {
        if (this.filesOpen()) {
            throw new IllegalStateException("Files are still open, cannot change base directory");
        }
        this.files.clear();
    }

    public synchronized String getBaseDir() {
        return this.base.getAbsolutePath();
    }

    public static String getDefaultBase() {
        return DEFAULT_BASE;
    }

    public synchronized File getBaseDirRelative() {
        File parent = new File(DEFAULT_BASE).getAbsoluteFile();
        ArrayStack l = new ArrayStack();
        for (File f = this.base.getAbsoluteFile(); f != null; f = f.getParentFile()) {
            if (f.equals(parent)) {
                if (l.isEmpty()) break;
                File rel = new File((String)l.pop());
                while (!l.isEmpty()) {
                    rel = new File(rel, (String)l.pop());
                }
                return rel;
            }
            l.push((Object)f.getName());
        }
        return new File(".");
    }

    public synchronized void reserveFile(String filename) {
        this.reserveFile(filename, null);
    }

    public synchronized void reserveFile(String filename, String charsetName) {
        this.reserveFile(filename, charsetName, filename, false);
    }

    public synchronized void reserveFile(String filename, String charsetName, String alias) {
        this.reserveFile(filename, charsetName, alias, false);
    }

    public synchronized String reserveFile(String filename, String charsetName, String alias, boolean hasHeader) {
        if (filename == null) {
            throw new IllegalArgumentException("Filename must not be null");
        }
        if (alias == null) {
            throw new IllegalArgumentException("Alias must not be null");
        }
        FileEntry fileEntry = this.files.get(alias);
        if (fileEntry == null) {
            File f = new File(filename);
            fileEntry = new FileEntry(f.isAbsolute() ? f : new File(this.base, filename), null, charsetName);
            if (filename.equals(alias)) {
                log.info("Stored: " + filename);
            } else {
                log.info("Stored: " + filename + " Alias: " + alias);
            }
            this.files.put(alias, fileEntry);
            if (hasHeader) {
                try {
                    fileEntry.headerLine = this.readLine(alias, false);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not read file header line", e);
                }
            }
        }
        return fileEntry.headerLine;
    }

    public String readLine(String filename) throws IOException {
        return this.readLine(filename, true);
    }

    public String readLine(String filename, boolean recycle) throws IOException {
        return this.readLine(filename, recycle, false);
    }

    public synchronized String readLine(String filename, boolean recycle, boolean firstLineIsNames) throws IOException {
        FileEntry fileEntry = this.files.get(filename);
        if (fileEntry != null) {
            if (fileEntry.inputOutputObject == null) {
                fileEntry.inputOutputObject = this.createBufferedReader(fileEntry, filename);
            } else if (!(fileEntry.inputOutputObject instanceof Reader)) {
                throw new IOException("File " + filename + " already in use");
            }
            BufferedReader reader = (BufferedReader)fileEntry.inputOutputObject;
            String line = reader.readLine();
            if (line == null && recycle) {
                reader.close();
                reader = this.createBufferedReader(fileEntry, filename);
                fileEntry.inputOutputObject = reader;
                if (firstLineIsNames) {
                    reader.readLine();
                }
                line = reader.readLine();
            }
            if (log.isDebugEnabled()) {
                log.debug("Read:" + line);
            }
            return line;
        }
        throw new IOException("File never reserved: " + filename);
    }

    private BufferedReader createBufferedReader(FileEntry fileEntry, String filename) throws IOException {
        FileInputStream fis = new FileInputStream(fileEntry.file);
        InputStreamReader isr = null;
        String charsetName = fileEntry.charSetEncoding;
        isr = charsetName != null && charsetName.trim().length() > 0 ? new InputStreamReader((InputStream)fis, charsetName) : new InputStreamReader(fis);
        return new BufferedReader(isr);
    }

    public synchronized void write(String filename, String value) throws IOException {
        BufferedWriter writer;
        FileEntry fileEntry = this.files.get(filename);
        if (fileEntry != null) {
            if (fileEntry.inputOutputObject == null) {
                fileEntry.inputOutputObject = this.createBufferedWriter(fileEntry, filename);
            } else if (!(fileEntry.inputOutputObject instanceof Writer)) {
                throw new IOException("File " + filename + " already in use");
            }
            writer = (BufferedWriter)fileEntry.inputOutputObject;
            if (log.isDebugEnabled()) {
                log.debug("Write:" + value);
            }
        } else {
            throw new IOException("File never reserved: " + filename);
        }
        writer.write(value);
    }

    private BufferedWriter createBufferedWriter(FileEntry fileEntry, String filename) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileEntry.file);
        OutputStreamWriter osw = null;
        String charsetName = fileEntry.charSetEncoding;
        osw = charsetName != null && charsetName.trim().length() > 0 ? new OutputStreamWriter((OutputStream)fos, charsetName) : new OutputStreamWriter(fos);
        return new BufferedWriter(osw);
    }

    public synchronized void closeFiles() throws IOException {
        for (Map.Entry<String, FileEntry> me : this.files.entrySet()) {
            this.closeFile(me.getKey(), me.getValue());
        }
        this.files.clear();
    }

    public synchronized void closeFile(String name) throws IOException {
        FileEntry fileEntry = this.files.get(name);
        this.closeFile(name, fileEntry);
    }

    private void closeFile(String name, FileEntry fileEntry) throws IOException {
        if (fileEntry != null && fileEntry.inputOutputObject != null) {
            log.info("Close: " + name);
            fileEntry.inputOutputObject.close();
            fileEntry.inputOutputObject = null;
        }
    }

    boolean filesOpen() {
        for (FileEntry fileEntry : this.files.values()) {
            if (fileEntry.inputOutputObject == null) continue;
            return true;
        }
        return false;
    }

    public File getRandomFile(String basedir, String[] extensions) {
        File src;
        File input = null;
        if (basedir != null && (src = new File(basedir)).isDirectory() && src.list() != null) {
            File[] lfiles = src.listFiles(new JMeterFileFilter(extensions));
            int count = lfiles.length;
            input = lfiles[this.random.nextInt(count)];
        }
        return input;
    }

    public static String resolveBaseRelativeName(String relativeName) {
        if (relativeName.startsWith(BASE_PREFIX)) {
            String newName = relativeName.substring(BASE_PREFIX.length());
            return new File(FileServer.getFileServer().getBaseDir(), newName).getAbsolutePath();
        }
        return relativeName;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    private static class FileEntry {
        private String headerLine;
        private final File file;
        private Closeable inputOutputObject;
        private final String charSetEncoding;

        FileEntry(File f, Closeable o, String e) {
            this.file = f;
            this.inputOutputObject = o;
            this.charSetEncoding = e;
        }
    }
}

