/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MultiProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.Converter;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestBeanHelper {
    protected static final Logger log = LoggingManager.getLoggerForClass();

    @Deprecated
    public static void prepare(TestElement el) {
        if (!(el instanceof TestBean)) {
            return;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(el.getClass());
            PropertyDescriptor[] desc = beanInfo.getPropertyDescriptors();
            Object[] param = new Object[1];
            if (log.isDebugEnabled()) {
                log.debug("Preparing " + el.getClass());
            }
            for (int x = 0; x < desc.length; ++x) {
                JMeterProperty jprop = el.getProperty(desc[x].getName());
                Class<?> type = desc[x].getPropertyType();
                Object value = TestBeanHelper.unwrapProperty(desc[x], jprop, type);
                if (log.isDebugEnabled()) {
                    log.debug("Setting " + jprop.getName() + "=" + value);
                }
                if (value == null && type.isPrimitive()) continue;
                param[0] = value;
                Method writeMethod = desc[x].getWriteMethod();
                if (writeMethod == null) continue;
                TestBeanHelper.invokeOrBailOut(el, writeMethod, param);
            }
        }
        catch (IntrospectionException e) {
            log.error("Couldn't set properties for " + el.getClass().getName(), (Throwable)e);
        }
    }

    private static Object unwrapProperty(PropertyDescriptor desc, JMeterProperty jprop, Class<?> type) {
        Object value;
        if (jprop instanceof TestElementProperty) {
            TestElement te = ((TestElementProperty)jprop).getElement();
            if (te instanceof TestBean) {
                TestBeanHelper.prepare(te);
            }
            value = te;
        } else {
            value = jprop instanceof MultiProperty ? TestBeanHelper.unwrapCollection((MultiProperty)jprop, (String)desc.getValue("tableObject.classname")) : (jprop instanceof NullProperty && !Boolean.TRUE.equals(desc.getValue("notUndefined")) ? null : Converter.convert((Object)jprop.getStringValue(), type));
        }
        return value;
    }

    private static Object unwrapCollection(MultiProperty prop, String type) {
        if (prop instanceof CollectionProperty) {
            LinkedList<Object> values = new LinkedList<Object>();
            PropertyIterator iter = prop.iterator();
            while (iter.hasNext()) {
                try {
                    values.add(TestBeanHelper.unwrapProperty(null, iter.next(), Class.forName(type)));
                }
                catch (Exception e) {
                    log.error("Couldn't convert object: " + prop.getObjectValue() + " to " + type, (Throwable)e);
                }
            }
            return values;
        }
        return null;
    }

    private static Object invokeOrBailOut(Object invokee, Method method, Object[] params) {
        try {
            return method.invoke(invokee, params);
        }
        catch (IllegalArgumentException e) {
            throw new Error(TestBeanHelper.createMessage(invokee, method, params), e);
        }
        catch (IllegalAccessException e) {
            throw new Error(TestBeanHelper.createMessage(invokee, method, params), e);
        }
        catch (InvocationTargetException e) {
            throw new Error(TestBeanHelper.createMessage(invokee, method, params), e);
        }
    }

    private static String createMessage(Object invokee, Method method, Object[] params) {
        StringBuilder sb = new StringBuilder();
        sb.append("This should never happen. Tried to invoke:\n");
        sb.append(invokee.getClass().getName());
        sb.append("#");
        sb.append(method.getName());
        sb.append("(");
        for (Object o : params) {
            sb.append(o.getClass().getSimpleName());
            sb.append(' ');
            sb.append(o);
            sb.append(' ');
        }
        sb.append(")");
        return sb.toString();
    }
}

