/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.gui.JLabeledTextArea;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.gui.ObjectTableModel;

public class RowDetailDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 6578889215615435475L;
    private static final String NEXT = "next";
    private static final String PREVIOUS = "previous";
    private static final String CLOSE = "close";
    private static final String UPDATE = "update";
    private JLabeledTextField nameTF;
    private JLabeledTextArea valueTA;
    private JButton nextButton;
    private JButton previousButton;
    private ObjectTableModel tableModel;
    private int selectedRow;

    public RowDetailDialog() {
    }

    public RowDetailDialog(ObjectTableModel tableModel, int selectedRow) {
        super((Frame)null, JMeterUtils.getResString("detail"), true);
        this.tableModel = tableModel;
        this.selectedRow = selectedRow;
        this.init();
    }

    protected JRootPane createRootPane() {
        JRootPane rootPane = new JRootPane();
        AbstractAction escapeAction = new AbstractAction("ESCAPE"){
            private static final long serialVersionUID = -8699034338969407625L;

            public void actionPerformed(ActionEvent actionEvent) {
                RowDetailDialog.this.setVisible(false);
            }
        };
        AbstractAction enterAction = new AbstractAction("ENTER"){
            private static final long serialVersionUID = -1529005452976176873L;

            public void actionPerformed(ActionEvent actionEvent) {
                RowDetailDialog.this.doUpdate(actionEvent);
                RowDetailDialog.this.setVisible(false);
            }
        };
        ActionMap actionMap = rootPane.getActionMap();
        actionMap.put(escapeAction.getValue("Name"), escapeAction);
        actionMap.put(enterAction.getValue("Name"), enterAction);
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(KeyStrokes.ESC, escapeAction.getValue("Name"));
        inputMap.put(KeyStrokes.ENTER, enterAction.getValue("Name"));
        return rootPane;
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.nameTF = new JLabeledTextField(JMeterUtils.getResString("name"), 20);
        this.valueTA = new JLabeledTextArea(JMeterUtils.getResString("value"));
        this.valueTA.setPreferredSize(new Dimension(450, 300));
        this.setValues(this.selectedRow);
        JPanel detailPanel = new JPanel();
        detailPanel.setLayout(new BorderLayout());
        detailPanel.add((Component)this.nameTF, "North");
        detailPanel.add((Component)this.valueTA, "Center");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(7, 3, 3, 3));
        mainPanel.add((Component)detailPanel, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        JButton updateButton = new JButton(JMeterUtils.getResString(UPDATE));
        updateButton.setActionCommand(UPDATE);
        updateButton.addActionListener(this);
        JButton closeButton = new JButton(JMeterUtils.getResString(CLOSE));
        closeButton.setActionCommand(CLOSE);
        closeButton.addActionListener(this);
        this.nextButton = new JButton(JMeterUtils.getResString(NEXT));
        this.nextButton.setActionCommand(NEXT);
        this.nextButton.addActionListener(this);
        this.nextButton.setEnabled(this.selectedRow < this.tableModel.getRowCount() - 1);
        this.previousButton = new JButton(JMeterUtils.getResString(PREVIOUS));
        this.previousButton.setActionCommand(PREVIOUS);
        this.previousButton.addActionListener(this);
        this.previousButton.setEnabled(this.selectedRow > 0);
        buttonsPanel.add(updateButton);
        buttonsPanel.add(this.previousButton);
        buttonsPanel.add(this.nextButton);
        buttonsPanel.add(closeButton);
        mainPanel.add((Component)buttonsPanel, "South");
        this.getContentPane().add(mainPanel);
        this.nameTF.requestFocusInWindow();
        this.pack();
        ComponentUtil.centerComponentInWindow((Component)this);
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(CLOSE)) {
            this.setVisible(false);
        } else if (action.equals(NEXT)) {
            ++this.selectedRow;
            this.previousButton.setEnabled(true);
            this.nextButton.setEnabled(this.selectedRow < this.tableModel.getRowCount() - 1);
            this.setValues(this.selectedRow);
        } else if (action.equals(PREVIOUS)) {
            --this.selectedRow;
            this.nextButton.setEnabled(true);
            this.previousButton.setEnabled(this.selectedRow > 0);
            this.setValues(this.selectedRow);
        } else if (action.equals(UPDATE)) {
            this.doUpdate(e);
        }
    }

    private void setValues(int selectedRow) {
        this.nameTF.setText((String)this.tableModel.getValueAt(selectedRow, 0));
        this.valueTA.setText((String)this.tableModel.getValueAt(selectedRow, 1));
    }

    protected void doUpdate(ActionEvent actionEvent) {
        this.tableModel.setValueAt((Object)this.nameTF.getText(), this.selectedRow, 0);
        this.tableModel.setValueAt((Object)this.valueTA.getText(), this.selectedRow, 1);
    }
}

