/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.util.JMeterMenuBar;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookAndFeelCommand
implements Command {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String JMETER_LAF = "jmeter.laf";
    private static final Set<String> commands = new HashSet<String>();
    private static final Preferences PREFS = Preferences.userNodeForPackage(LookAndFeelCommand.class);
    private static final String USER_PREFS_KEY = "laf";

    private static String getJMeterLaf() {
        String laf = PREFS.get(USER_PREFS_KEY, null);
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        laf = JMeterUtils.getProperty("jmeter.laf." + osName.replace(' ', '_'));
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        String[] osFamily = osName.split("\\s");
        laf = JMeterUtils.getProperty("jmeter.laf." + osFamily[0]);
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        laf = JMeterUtils.getProperty(JMETER_LAF);
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        return UIManager.getCrossPlatformLookAndFeelClassName();
    }

    private static String checkLafName(String laf) {
        if ("System".equalsIgnoreCase(laf)) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        if ("CrossPlatform".equalsIgnoreCase(laf)) {
            return UIManager.getCrossPlatformLookAndFeelClassName();
        }
        return laf;
    }

    @Override
    public void doAction(ActionEvent ev) {
        try {
            String className = ev.getActionCommand().substring("laf:".length()).replace('/', '.');
            UIManager.setLookAndFeel(className);
            SwingUtilities.updateComponentTreeUI(GuiPackage.getInstance().getMainFrame());
            PREFS.put(USER_PREFS_KEY, className);
        }
        catch (UnsupportedLookAndFeelException e) {
            JMeterUtils.reportErrorToUser("Look and Feel unavailable:" + e.toString());
        }
        catch (InstantiationException e) {
            JMeterUtils.reportErrorToUser("Look and Feel unavailable:" + e.toString());
        }
        catch (ClassNotFoundException e) {
            JMeterUtils.reportErrorToUser("Look and Feel unavailable:" + e.toString());
        }
        catch (IllegalAccessException e) {
            JMeterUtils.reportErrorToUser("Look and Feel unavailable:" + e.toString());
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    static {
        UIManager.LookAndFeelInfo[] lfs = JMeterMenuBar.getAllLAFs();
        for (int i = 0; i < lfs.length; ++i) {
            commands.add("laf:" + lfs[i].getClassName());
        }
        try {
            String jMeterLaf = LookAndFeelCommand.getJMeterLaf();
            UIManager.setLookAndFeel(jMeterLaf);
            if (log.isInfoEnabled()) {
                ArrayList<String> names = new ArrayList<String>();
                for (UIManager.LookAndFeelInfo laf : lfs) {
                    if (!laf.getClassName().equals(jMeterLaf)) continue;
                    names.add(laf.getName());
                }
                if (names.size() > 0) {
                    log.info("Using look and feel: " + jMeterLaf + " " + names.toString());
                } else {
                    log.info("Using look and feel: " + jMeterLaf);
                }
            }
        }
        catch (IllegalAccessException e) {
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
    }
}

