/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.util.JMeterUtils;

public class FilePanelEntry
extends HorizontalPanel
implements ActionListener {
    private static final long serialVersionUID = 280L;
    private final Font FONT_SMALL = new Font("SansSerif", 0, 10);
    private final JTextField filename = new JTextField(10);
    private final JLabel label;
    private final JButton browse = new JButton(JMeterUtils.getResString("browse"));
    private static final String ACTION_BROWSE = "browse";
    private final List<ChangeListener> listeners = new LinkedList<ChangeListener>();
    private final String[] filetypes;

    public FilePanelEntry() {
        this(JMeterUtils.getResString("file_visualizer_filename"));
    }

    public FilePanelEntry(String label) {
        this(label, (ChangeListener)null, new String[0]);
    }

    public FilePanelEntry(String label, String ... exts) {
        this(label, (ChangeListener)null, exts);
    }

    public FilePanelEntry(String label, ChangeListener listener, String ... exts) {
        this.label = new JLabel(label);
        if (listener != null) {
            this.listeners.add(listener);
        }
        if (exts != null) {
            this.filetypes = new String[exts.length];
            System.arraycopy(exts, 0, this.filetypes, 0, exts.length);
        } else {
            this.filetypes = null;
        }
        this.init();
    }

    public final void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    private void init() {
        this.add(this.label);
        this.add(this.filename);
        this.filename.addActionListener(this);
        this.browse.setFont(this.FONT_SMALL);
        this.add(this.browse);
        this.browse.setActionCommand(ACTION_BROWSE);
        this.browse.addActionListener(this);
    }

    public void clearGui() {
        this.filename.setText("");
    }

    public void enableFile(boolean enable) {
        this.browse.setEnabled(enable);
        this.filename.setEnabled(enable);
    }

    public String getFilename() {
        return this.filename.getText();
    }

    public void setFilename(String f) {
        this.filename.setText(f);
    }

    private void fireFileChanged() {
        for (ChangeListener cl : this.listeners) {
            cl.stateChanged(new ChangeEvent(this));
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(ACTION_BROWSE)) {
            JFileChooser chooser = this.filetypes == null || this.filetypes.length == 0 ? FileDialoger.promptToOpenFile() : FileDialoger.promptToOpenFile(this.filetypes);
            if (chooser != null && chooser.getSelectedFile() != null) {
                this.filename.setText(chooser.getSelectedFile().getPath());
                this.fireFileChanged();
            }
        } else {
            this.fireFileChanged();
        }
    }
}

