/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.NumberProperty;

public class FloatProperty
extends NumberProperty {
    private static final long serialVersionUID = 240L;
    private float value;
    private float savedValue;

    public FloatProperty(String name, float value) {
        super(name);
        this.value = value;
    }

    public FloatProperty() {
    }

    public void setRunningVersion(boolean runningVersion) {
        this.savedValue = this.value;
        super.setRunningVersion(runningVersion);
    }

    public void recoverRunningVersion(TestElement owner) {
        this.value = this.savedValue;
    }

    public void setValue(float value) {
        this.value = value;
    }

    protected void setNumberValue(Number n) {
        this.value = n.floatValue();
    }

    protected void setNumberValue(String n) throws NumberFormatException {
        this.value = Float.parseFloat(n);
    }

    public String getStringValue() {
        return Float.toString(this.value);
    }

    public Object getObjectValue() {
        return Float.valueOf(this.value);
    }

    public FloatProperty clone() {
        FloatProperty prop = (FloatProperty)super.clone();
        prop.value = this.value;
        return prop;
    }

    public boolean getBooleanValue() {
        return this.value > 0.0f;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public float getFloatValue() {
        return this.value;
    }

    public int getIntValue() {
        return (int)this.value;
    }

    public long getLongValue() {
        return (long)this.value;
    }
}

