/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.action.Searcher;

public class RegexpSearcher
implements Searcher {
    private boolean caseSensitive;
    private Pattern pattern;

    public RegexpSearcher(boolean caseSensitive, String regexp) {
        this.caseSensitive = caseSensitive;
        String newRegexp = ".*" + regexp + ".*";
        this.pattern = caseSensitive ? Pattern.compile(newRegexp) : Pattern.compile(newRegexp, 2);
    }

    @Override
    public boolean search(List<String> textTokens) {
        for (String searchableToken : textTokens) {
            if (StringUtils.isEmpty((CharSequence)searchableToken)) continue;
            Matcher matcher = null;
            matcher = this.caseSensitive ? this.pattern.matcher(searchableToken) : this.pattern.matcher(searchableToken.toLowerCase());
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }
}

