/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.SSLManager;

public class SSLManagerCommand
implements Command {
    private static final Set<String> commandSet;

    @Override
    public void doAction(ActionEvent e) {
        if (e.getActionCommand().equals("sslManager")) {
            this.sslManager();
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commandSet;
    }

    private void sslManager() {
        SSLManager.reset();
        JFileChooser keyStoreChooser = new JFileChooser(System.getProperty("user.dir"));
        keyStoreChooser.addChoosableFileFilter(new AcceptPKCS12FileFilter());
        keyStoreChooser.setFileSelectionMode(0);
        int retVal = keyStoreChooser.showOpenDialog(GuiPackage.getInstance().getMainFrame());
        if (0 == retVal) {
            File selectedFile = keyStoreChooser.getSelectedFile();
            try {
                System.setProperty("javax.net.ssl.keyStore", selectedFile.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        SSLManager.getInstance();
    }

    static {
        HashSet<String> commands = new HashSet<String>();
        commands.add("sslManager");
        commandSet = Collections.unmodifiableSet(commands);
    }

    private static class AcceptPKCS12FileFilter
    extends FileFilter {
        private AcceptPKCS12FileFilter() {
        }

        @Override
        public String getDescription() {
            return JMeterUtils.getResString("pkcs12_desc");
        }

        @Override
        public boolean accept(File testFile) {
            return testFile.isDirectory() || testFile.getName().endsWith(".p12") || testFile.getName().endsWith(".P12");
        }
    }
}

