/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.tree;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JMeterTreeListener
implements TreeSelectionListener,
MouseListener,
KeyListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private TreePath currentPath;
    private ActionListener actionHandler;
    private JMeterTreeModel model;
    private JTree tree;

    public JMeterTreeListener(JMeterTreeModel model) {
        this.model = model;
    }

    public JMeterTreeListener() {
    }

    public void setModel(JMeterTreeModel m) {
        this.model = m;
    }

    public void setActionHandler(ActionListener ah) {
        this.actionHandler = ah;
    }

    public void setJTree(JTree tree) {
        this.tree = tree;
    }

    public void setEndWindow(Container window) {
    }

    public JTree getJTree() {
        return this.tree;
    }

    public JMeterTreeNode getCurrentNode() {
        if (this.currentPath != null) {
            if (this.currentPath.getLastPathComponent() != null) {
                return (JMeterTreeNode)this.currentPath.getLastPathComponent();
            }
            return (JMeterTreeNode)this.currentPath.getParentPath().getLastPathComponent();
        }
        return (JMeterTreeNode)this.model.getRoot();
    }

    public JMeterTreeNode[] getSelectedNodes() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null) {
            return new JMeterTreeNode[]{this.getCurrentNode()};
        }
        JMeterTreeNode[] nodes = new JMeterTreeNode[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            nodes[i] = (JMeterTreeNode)paths[i].getLastPathComponent();
        }
        return nodes;
    }

    public TreePath removedSelectedNode() {
        this.currentPath = this.currentPath.getParentPath();
        return this.currentPath;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        log.debug("value changed, updating currentPath");
        this.currentPath = e.getNewLeadSelectionPath();
        this.tree.requestFocusInWindow();
        this.actionHandler.actionPerformed(new ActionEvent(this, 3333, "edit"));
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        GuiPackage.getInstance().getMainFrame().repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        MainFrame mainFrame = GuiPackage.getInstance().getMainFrame();
        mainFrame.closeMenu();
        int selRow = this.tree.getRowForLocation(e.getX(), e.getY());
        if (this.tree.getPathForLocation(e.getX(), e.getY()) != null) {
            log.debug("mouse pressed, updating currentPath");
            this.currentPath = this.tree.getPathForLocation(e.getX(), e.getY());
        }
        if (selRow != -1 && this.isRightClick(e)) {
            if (this.tree.getSelectionCount() < 2) {
                this.tree.setSelectionPath(this.currentPath);
            }
            log.debug("About to display pop-up");
            this.displayPopUp(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        String actionName = null;
        if (KeyStrokes.matches(e, KeyStrokes.COPY)) {
            actionName = "Copy";
        } else if (KeyStrokes.matches(e, KeyStrokes.PASTE)) {
            actionName = "Paste";
        } else if (KeyStrokes.matches(e, KeyStrokes.CUT)) {
            actionName = "Cut";
        } else if (KeyStrokes.matches(e, KeyStrokes.DUPLICATE)) {
            actionName = "duplicate";
        } else if (KeyStrokes.matches(e, KeyStrokes.ALT_UP_ARROW)) {
            actionName = "move_up";
        } else if (KeyStrokes.matches(e, KeyStrokes.ALT_DOWN_ARROW)) {
            actionName = "move_down";
        } else if (KeyStrokes.matches(e, KeyStrokes.ALT_LEFT_ARROW)) {
            actionName = "move_left";
        } else if (KeyStrokes.matches(e, KeyStrokes.ALT_RIGHT_ARROW)) {
            actionName = "move_right";
        } else if (KeyStrokes.matches(e, KeyStrokes.SHIFT_LEFT_ARROW)) {
            actionName = "collapse";
        } else if (KeyStrokes.matches(e, KeyStrokes.SHIFT_RIGHT_ARROW)) {
            actionName = "expand";
        }
        if (actionName != null) {
            ActionRouter actionRouter = ActionRouter.getInstance();
            actionRouter.doActionNow(new ActionEvent(e.getSource(), e.getID(), actionName));
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private boolean isRightClick(MouseEvent e) {
        return e.isPopupTrigger() || (8 & e.getModifiers()) > 0 || 4 == e.getModifiers();
    }

    private void displayPopUp(MouseEvent e) {
        JPopupMenu pop = this.getCurrentNode().createPopupMenu();
        GuiPackage.getInstance().displayPopUp(e, pop);
    }
}

