/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.core;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.lang3.Validate;
import org.apache.jmeter.report.core.SampleException;
import org.apache.jmeter.report.core.SampleWriter;
import org.apache.jorphan.util.JOrphanUtils;

public abstract class AbstractSampleWriter
extends SampleWriter {
    private static final int BUF_SIZE = 10000;
    private static final String CHARSET = "ISO8859-1";
    protected PrintWriter writer;

    public void setWriter(Writer writer) {
        Validate.notNull((Object)writer, (String)"writer must not be null.", (Object[])new Object[0]);
        if (this.writer != null) {
            JOrphanUtils.closeQuietly((Closeable)this.writer);
        }
        this.writer = new PrintWriter((Writer)new BufferedWriter(writer, 10000), false);
    }

    public void setOutputStream(OutputStream out) {
        Validate.notNull((Object)out, (String)"out must not be null.", (Object[])new Object[0]);
        try {
            this.setWriter(new OutputStreamWriter(out, CHARSET));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setOutputFile(File output) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(output);
        }
        catch (Exception e) {
            throw new SampleException(e.getMessage(), e);
        }
        this.setOutputStream(fos);
    }

    @Override
    public void close() {
        JOrphanUtils.closeQuietly((Closeable)this.writer);
        this.writer = null;
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

