/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.dashboard;

import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.jmeter.report.config.ConfigurationException;
import org.apache.jmeter.report.config.ExporterConfiguration;
import org.apache.jmeter.report.config.GraphConfiguration;
import org.apache.jmeter.report.config.ReportGeneratorConfiguration;
import org.apache.jmeter.report.config.SubConfiguration;
import org.apache.jmeter.report.core.DataContext;
import org.apache.jmeter.report.core.TimeHelper;
import org.apache.jmeter.report.dashboard.AbstractDataExporter;
import org.apache.jmeter.report.dashboard.ExportException;
import org.apache.jmeter.report.dashboard.JsonizerVisitor;
import org.apache.jmeter.report.dashboard.TemplateVisitor;
import org.apache.jmeter.report.processor.ListResultData;
import org.apache.jmeter.report.processor.MapResultData;
import org.apache.jmeter.report.processor.ResultData;
import org.apache.jmeter.report.processor.ResultDataVisitor;
import org.apache.jmeter.report.processor.SampleContext;
import org.apache.jmeter.report.processor.ValueResultData;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class HtmlTemplateExporter
extends AbstractDataExporter {
    private static final String MUST_NOT_BE_NULL = "%s must not be null";
    private static final Logger LOG = LoggingManager.getLoggerForClass();
    public static final String DATA_CTX_REPORT_TITLE = "reportTitle";
    public static final String DATA_CTX_TESTFILE = "testFile";
    public static final String DATA_CTX_BEGINDATE = "beginDate";
    public static final String DATA_CTX_ENDDATE = "endDate";
    public static final String DATA_CTX_TIMEZONE = "timeZone";
    public static final String DATA_CTX_TIMEZONE_OFFSET = "timeZoneOffset";
    public static final String DATA_CTX_OVERALL_FILTER = "overallFilter";
    public static final String DATA_CTX_SHOW_CONTROLLERS_ONLY = "showControllersOnly";
    public static final String DATA_CTX_RESULT = "result";
    public static final String DATA_CTX_EXTRA_OPTIONS = "extraOptions";
    public static final String DATA_CTX_SERIES_FILTER = "seriesFilter";
    public static final String DATA_CTX_FILTERS_ONLY_SAMPLE_SERIES = "filtersOnlySampleSeries";
    public static final String TIMESTAMP_FORMAT_MS = "ms";
    private static final String INVALID_TEMPLATE_DIRECTORY_FMT = "\"%s\" is not a valid template directory";
    private static final String INVALID_PROPERTY_CONFIG_FMT = "Wrong property \"%s\" in \"%s\" export configuration";
    private static final String EMPTY_GRAPH_FMT = "The graph \"%s\" will be empty : %s";
    private static final String TEMPLATE_DIR = "template_dir";
    private static final String TEMPLATE_DIR_NAME_DEFAULT = "report-template";
    private static final String OUTPUT_DIR = "output_dir";
    private static final String OUTPUT_DIR_NAME_DEFAULT = "report-output";

    private void addToContext(String key, Object value, DataContext context) {
        if (value instanceof String) {
            value = '\"' + (String)value + '\"';
        }
        context.put(key, value);
    }

    private <TVisit> void addResultToContext(String resultKey, Map<String, Object> storage, DataContext dataContext, ResultDataVisitor<TVisit> visitor) {
        this.addResultToContext(resultKey, storage, dataContext, visitor, null, null);
    }

    private <TVisit> void addResultToContext(String resultKey, Map<String, Object> storage, DataContext dataContext, ResultDataVisitor<TVisit> visitor, ResultCustomizer customizer, ResultChecker checker) {
        Object data = storage.get(resultKey);
        if (data instanceof ResultData) {
            ResultData result = (ResultData)data;
            if (checker != null) {
                checker.checkResult(result);
            }
            if (customizer != null) {
                result = customizer.customizeResult(result);
            }
            dataContext.put(resultKey, result.accept(visitor));
        }
    }

    private long formatTimestamp(String key, DataContext context) {
        double result = Double.parseDouble((String)context.get(key));
        long timestamp = (long)result;
        context.put(key, '\"' + TimeHelper.formatTimeStamp(timestamp) + '\"');
        return timestamp;
    }

    private <TProperty> TProperty getPropertyFromConfig(SubConfiguration cfg, String property, TProperty defaultValue, Class<TProperty> clazz) throws ExportException {
        try {
            return cfg.getProperty(property, defaultValue, clazz);
        }
        catch (ConfigurationException ex) {
            throw new ExportException(String.format(INVALID_PROPERTY_CONFIG_FMT, property, this.getName()), ex);
        }
    }

    @Override
    public void export(SampleContext context, File file, ReportGeneratorConfiguration configuration) throws ExportException {
        Validate.notNull((Object)context, (String)MUST_NOT_BE_NULL, (Object[])new Object[]{"context"});
        Validate.notNull((Object)file, (String)MUST_NOT_BE_NULL, (Object[])new Object[]{"file"});
        Validate.notNull((Object)configuration, (String)MUST_NOT_BE_NULL, (Object[])new Object[]{"configuration"});
        LOG.debug("Start template processing");
        DataContext dataContext = new DataContext();
        ExporterConfiguration exportCfg = configuration.getExportConfigurations().get(this.getName());
        File templateDirectory = this.getPropertyFromConfig(exportCfg, TEMPLATE_DIR, new File(JMeterUtils.getJMeterBinDir(), TEMPLATE_DIR_NAME_DEFAULT), File.class);
        if (!templateDirectory.isDirectory()) {
            String message = String.format(INVALID_TEMPLATE_DIRECTORY_FMT, templateDirectory.getAbsolutePath());
            LOG.error(message);
            throw new ExportException(message);
        }
        File outputDir = this.getPropertyFromConfig(exportCfg, OUTPUT_DIR, new File(JMeterUtils.getJMeterBinDir(), OUTPUT_DIR_NAME_DEFAULT), File.class);
        String globallyDefinedOutputDir = JMeterUtils.getProperty("jmeter.reportgenerator.outputdir");
        if (!StringUtils.isEmpty((CharSequence)globallyDefinedOutputDir)) {
            outputDir = new File(globallyDefinedOutputDir);
        }
        JOrphanUtils.canSafelyWriteToFolder((File)outputDir);
        LOG.info("Will generate dashboard in folder:" + outputDir.getAbsolutePath());
        boolean filtersOnlySampleSeries = exportCfg.filtersOnlySampleSeries();
        this.addToContext(DATA_CTX_FILTERS_ONLY_SAMPLE_SERIES, filtersOnlySampleSeries, dataContext);
        String seriesFilter = exportCfg.getSeriesFilter();
        Pattern filterPattern = null;
        if (StringUtils.isNotBlank((CharSequence)seriesFilter)) {
            try {
                filterPattern = Pattern.compile(seriesFilter);
            }
            catch (PatternSyntaxException ex) {
                LOG.error(String.format("Invalid series filter: \"%s\", %s", seriesFilter, ex.getDescription()));
            }
        }
        this.addToContext(DATA_CTX_SERIES_FILTER, seriesFilter, dataContext);
        boolean showControllerSeriesOnly = exportCfg.showControllerSeriesOnly();
        this.addToContext(DATA_CTX_SHOW_CONTROLLERS_ONLY, showControllerSeriesOnly, dataContext);
        JsonizerVisitor jsonizer = new JsonizerVisitor();
        Map<String, Object> storedData = context.getData();
        this.addResultToContext(DATA_CTX_BEGINDATE, storedData, dataContext, jsonizer);
        this.addResultToContext(DATA_CTX_ENDDATE, storedData, dataContext, jsonizer);
        this.addResultToContext("apdexSummary", storedData, dataContext, jsonizer);
        this.addResultToContext("errorsSummary", storedData, dataContext, jsonizer);
        this.addResultToContext("requestsSummary", storedData, dataContext, jsonizer);
        this.addResultToContext("statisticsSummary", storedData, dataContext, jsonizer);
        ExtraOptionsResultCustomizer customizer = new ExtraOptionsResultCustomizer();
        EmptyGraphChecker checker = new EmptyGraphChecker(filtersOnlySampleSeries, showControllerSeriesOnly, filterPattern);
        for (Map.Entry<String, GraphConfiguration> graphEntry : configuration.getGraphConfigurations().entrySet()) {
            String graphId = graphEntry.getKey();
            GraphConfiguration graphConfiguration = graphEntry.getValue();
            SubConfiguration extraOptions = exportCfg.getGraphExtraConfigurations().get(graphId);
            customizer.setExtraOptions(extraOptions);
            checker.setExcludesControllers(graphConfiguration.excludesControllers());
            checker.setGraphId(graphId);
            this.addResultToContext(graphId, storedData, dataContext, jsonizer, customizer, checker);
        }
        long oldTimestamp = this.formatTimestamp(DATA_CTX_BEGINDATE, dataContext);
        this.formatTimestamp(DATA_CTX_ENDDATE, dataContext);
        TimeZone timezone = TimeZone.getDefault();
        this.addToContext(DATA_CTX_TIMEZONE_OFFSET, timezone.getOffset(oldTimestamp), dataContext);
        if (!StringUtils.isEmpty((CharSequence)configuration.getReportTitle())) {
            dataContext.put(DATA_CTX_REPORT_TITLE, StringEscapeUtils.escapeHtml4((String)configuration.getReportTitle()));
        }
        this.addToContext(DATA_CTX_TESTFILE, file.getName(), dataContext);
        this.addToContext(DATA_CTX_OVERALL_FILTER, configuration.getSampleFilter(), dataContext);
        Configuration templateCfg = new Configuration(Configuration.getVersion());
        try {
            templateCfg.setDirectoryForTemplateLoading(templateDirectory);
            templateCfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            LOG.info("Report will be generated in:" + outputDir.getAbsolutePath() + ", creating folder structure");
            FileUtils.forceMkdir((File)outputDir);
            TemplateVisitor visitor = new TemplateVisitor(templateDirectory.toPath(), outputDir.toPath(), templateCfg, dataContext);
            Files.walkFileTree(templateDirectory.toPath(), visitor);
        }
        catch (IOException ex) {
            throw new ExportException("Unable to process template files.", ex);
        }
        LOG.debug("End of template processing");
    }

    private class EmptyGraphChecker
    implements ResultChecker {
        private final boolean filtersOnlySampleSeries;
        private final boolean showControllerSeriesOnly;
        private final Pattern filterPattern;
        private boolean excludesControllers;
        private String graphId;

        public final void setExcludesControllers(boolean excludesControllers) {
            this.excludesControllers = excludesControllers;
        }

        public final void setGraphId(String graphId) {
            this.graphId = graphId;
        }

        public EmptyGraphChecker(boolean filtersOnlySampleSeries, boolean showControllerSeriesOnly, Pattern filterPattern) {
            this.filtersOnlySampleSeries = filtersOnlySampleSeries;
            this.showControllerSeriesOnly = showControllerSeriesOnly;
            this.filterPattern = filterPattern;
        }

        @Override
        public void checkResult(ResultData result) {
            ResultData seriesResult;
            Boolean supportsControllerDiscrimination = AbstractDataExporter.findValue(Boolean.class, "supportsControllersDiscrimination", result);
            String message = null;
            if (supportsControllerDiscrimination.booleanValue() && this.showControllerSeriesOnly && this.excludesControllers) {
                message = "show_controllers_only is set while the graph excludes controllers.";
            } else if (this.filterPattern != null && (seriesResult = AbstractDataExporter.findData("series", result)) instanceof ListResultData) {
                ListResultData seriesList = (ListResultData)seriesResult;
                int count = seriesList.getSize();
                boolean matches = false;
                for (int index = 0; index < count && !matches; ++index) {
                    ResultData currentResult = seriesList.get(index);
                    if (!(currentResult instanceof MapResultData)) continue;
                    MapResultData seriesData = (MapResultData)currentResult;
                    String name = AbstractDataExporter.findValue(String.class, "label", seriesData);
                    boolean isController = AbstractDataExporter.findValue(Boolean.class, "isController", seriesData);
                    matches = this.filterPattern.matcher(name).matches();
                    matches = matches ? !this.filtersOnlySampleSeries || supportsControllerDiscrimination == false || isController || !this.showControllerSeriesOnly : this.filtersOnlySampleSeries && supportsControllerDiscrimination == false;
                }
                if (!matches) {
                    message = "None series matches the series_filter";
                }
            }
            if (message != null) {
                LOG.warn(String.format(HtmlTemplateExporter.EMPTY_GRAPH_FMT, this.graphId, message));
            }
        }
    }

    private static interface ResultChecker {
        public void checkResult(ResultData var1);
    }

    private class ExtraOptionsResultCustomizer
    implements ResultCustomizer {
        private SubConfiguration extraOptions;

        private ExtraOptionsResultCustomizer() {
        }

        public final void setExtraOptions(SubConfiguration extraOptions) {
            this.extraOptions = extraOptions;
        }

        @Override
        public ResultData customizeResult(ResultData result) {
            MapResultData customizedResult = new MapResultData();
            customizedResult.setResult(HtmlTemplateExporter.DATA_CTX_RESULT, result);
            if (this.extraOptions != null) {
                MapResultData extraResult = new MapResultData();
                for (Map.Entry<String, String> extraEntry : this.extraOptions.getProperties().entrySet()) {
                    extraResult.setResult(extraEntry.getKey(), new ValueResultData(extraEntry.getValue()));
                }
                customizedResult.setResult(HtmlTemplateExporter.DATA_CTX_EXTRA_OPTIONS, extraResult);
            }
            return customizedResult;
        }
    }

    private static interface ResultCustomizer {
        public ResultData customizeResult(ResultData var1);
    }
}

