/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor.graph.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.TimeRateAggregatorFactory;
import org.apache.jmeter.report.processor.graph.AbstractOverTimeGraphConsumer;
import org.apache.jmeter.report.processor.graph.AbstractSeriesSelector;
import org.apache.jmeter.report.processor.graph.CountValueSelector;
import org.apache.jmeter.report.processor.graph.GroupInfo;
import org.apache.jmeter.report.processor.graph.TimeStampKeysSelector;

public class TransactionsPerSecondGraphConsumer
extends AbstractOverTimeGraphConsumer {
    private static final String STATUS_SERIES_FORMAT = "%s-%s";
    private static final String SUCCESS_SERIES_SUFFIX = "success";
    private static final String FAILURE_SERIES_SUFFIX = "failure";

    @Override
    protected TimeStampKeysSelector createTimeStampKeysSelector() {
        TimeStampKeysSelector keysSelector = new TimeStampKeysSelector();
        keysSelector.setSelectBeginTime(false);
        return keysSelector;
    }

    @Override
    protected Map<String, GroupInfo> createGroupInfos() {
        HashMap<String, GroupInfo> groupInfos = new HashMap<String, GroupInfo>(1);
        groupInfos.put("Generic group", new GroupInfo(new TimeRateAggregatorFactory(), new AbstractSeriesSelector(true){

            @Override
            public Iterable<String> select(Sample sample) {
                String label = String.format(TransactionsPerSecondGraphConsumer.STATUS_SERIES_FORMAT, sample.getName(), sample.getSuccess() ? TransactionsPerSecondGraphConsumer.SUCCESS_SERIES_SUFFIX : TransactionsPerSecondGraphConsumer.FAILURE_SERIES_SUFFIX);
                return Arrays.asList(label);
            }
        }, new CountValueSelector(), false, false));
        return groupInfos;
    }

    @Override
    public void setGranularity(long granularity) {
        super.setGranularity(granularity);
        ((TimeRateAggregatorFactory)this.getGroupInfos().get("Generic group").getAggregatorFactory()).setGranularity(granularity);
    }
}

