/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.lang3.ClassUtils;
import org.apache.jmeter.gui.ClearGui;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testbeans.gui.BooleanPropertyEditor;
import org.apache.jmeter.testbeans.gui.ComboStringEditor;
import org.apache.jmeter.testbeans.gui.EnumEditor;
import org.apache.jmeter.testbeans.gui.FieldStringEditor;
import org.apache.jmeter.testbeans.gui.IntegerPropertyEditor;
import org.apache.jmeter.testbeans.gui.LongPropertyEditor;
import org.apache.jmeter.testbeans.gui.SharedCustomizer;
import org.apache.jmeter.testbeans.gui.TestBeanPropertyEditor;
import org.apache.jmeter.testbeans.gui.TextAreaEditor;
import org.apache.jmeter.testbeans.gui.TypeEditor;
import org.apache.jmeter.testbeans.gui.WrapperEditor;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class GenericTestBeanCustomizer
extends JPanel
implements SharedCustomizer {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String GROUP = "group";
    public static final String ORDER = "order";
    public static final String TAGS = "tags";
    public static final String NOT_UNDEFINED = "notUndefined";
    public static final String NOT_EXPRESSION = "notExpression";
    public static final String NOT_OTHER = "notOther";
    public static final String MULTILINE = "multiline";
    public static final String DEFAULT = "default";
    public static final String DEFAULT_NOT_SAVED = "defaultNoSave";
    public static final String RESOURCE_BUNDLE = "resourceBundle";
    public static final String GUITYPE = "guiType";
    public static final String TEXT_LANGUAGE = "textLanguage";
    public static final String DEFAULT_GROUP = "";
    private int scrollerCount = 0;
    private transient BeanInfo beanInfo;
    private transient PropertyDescriptor[] descriptors;
    private transient PropertyEditor[] editors;
    private MessageFormat propertyFieldLabelMessage;
    private MessageFormat propertyToolTipMessage;
    private Map<String, Object> propertyMap;

    public static String ORDER(String group) {
        return "group." + group + ".order";
    }

    @Deprecated
    public GenericTestBeanCustomizer() {
        log.warn("Constructor only intended for use in testing");
    }

    GenericTestBeanCustomizer(BeanInfo beanInfo) {
        this.beanInfo = beanInfo;
        this.descriptors = beanInfo.getPropertyDescriptors();
        Arrays.sort(this.descriptors, new PropertyComparator(beanInfo));
        this.editors = new PropertyEditor[this.descriptors.length];
        int scriptLanguageIndex = 0;
        int textAreaEditorIndex = 0;
        for (int i = 0; i < this.descriptors.length; ++i) {
            PropertyEditor propertyEditor;
            PropertyDescriptor descriptor = this.descriptors[i];
            String name = descriptor.getName();
            if (TestBeanHelper.isDescriptorIgnored(descriptor)) {
                log.debug("Skipping editor for property " + name);
                this.editors[i] = null;
                continue;
            }
            Object guiType = descriptor.getValue(GUITYPE);
            if (guiType instanceof TypeEditor) {
                propertyEditor = ((TypeEditor)((Object)guiType)).getInstance(descriptor);
            } else if (guiType instanceof Class && Enum.class.isAssignableFrom((Class)guiType)) {
                Class enumClass = (Class)guiType;
                propertyEditor = new EnumEditor(descriptor, enumClass, (ResourceBundle)descriptor.getValue(RESOURCE_BUNDLE));
            } else {
                Class<?> editorClass = descriptor.getPropertyEditorClass();
                if (log.isDebugEnabled()) {
                    log.debug("Property " + name + " has editor class " + editorClass);
                }
                if (editorClass != null) {
                    try {
                        propertyEditor = (PropertyEditor)editorClass.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        log.error("Can't create property editor.", (Throwable)e);
                        throw new Error(e.toString());
                    }
                } else {
                    Class<?> c = descriptor.getPropertyType();
                    propertyEditor = PropertyEditorManager.findEditor(c);
                }
            }
            if (propertyEditor == null) {
                log.warn("No editor for property: " + name + " type: " + descriptor.getPropertyType() + " in bean: " + beanInfo.getBeanDescriptor().getDisplayName());
                this.editors[i] = null;
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("Property " + name + " has property editor " + propertyEditor);
            }
            GenericTestBeanCustomizer.validateAttributes(descriptor, propertyEditor);
            if (!propertyEditor.supportsCustomEditor()) {
                propertyEditor = this.createWrapperEditor(propertyEditor, descriptor);
                if (log.isDebugEnabled()) {
                    log.debug("Editor for property " + name + " is wrapped in " + propertyEditor);
                }
            }
            if (propertyEditor instanceof TestBeanPropertyEditor) {
                ((TestBeanPropertyEditor)propertyEditor).setDescriptor(descriptor);
            }
            if (propertyEditor instanceof TextAreaEditor) {
                textAreaEditorIndex = i;
            }
            if (propertyEditor.getCustomEditor() instanceof JScrollPane) {
                ++this.scrollerCount;
            }
            this.editors[i] = propertyEditor;
            this.setEditorValue(i, descriptor.getValue(DEFAULT));
            if (!name.equals("scriptLanguage")) continue;
            scriptLanguageIndex = i;
        }
        String beanName = this.beanInfo.getBeanDescriptor().getName();
        if (beanName.startsWith("BSF") || beanName.startsWith("JSR223")) {
            WrapperEditor we = (WrapperEditor)this.editors[scriptLanguageIndex];
            TextAreaEditor tae = (TextAreaEditor)this.editors[textAreaEditorIndex];
            we.addChangeListener(tae);
        }
        this.propertyFieldLabelMessage = new MessageFormat(JMeterUtils.getResString("property_as_field_label"));
        this.propertyToolTipMessage = new MessageFormat(JMeterUtils.getResString("property_tool_tip"));
        this.init();
    }

    private static void validateAttributes(PropertyDescriptor pd, PropertyEditor pe) {
        Class<?> propertyType;
        Object deflt = pd.getValue(DEFAULT);
        if (deflt == null) {
            if (GenericTestBeanCustomizer.notNull(pd)) {
                log.warn(GenericTestBeanCustomizer.getDetails(pd) + " requires a value but does not provide a default.");
            }
            if (GenericTestBeanCustomizer.noSaveDefault(pd)) {
                log.warn(GenericTestBeanCustomizer.getDetails(pd) + " specifies DEFAULT_NO_SAVE but does not provide a default.");
            }
        } else {
            Class<?> defltClass = deflt.getClass();
            Class propClass = ClassUtils.primitiveToWrapper(pd.getPropertyType());
            if (!propClass.isAssignableFrom(defltClass)) {
                log.warn(GenericTestBeanCustomizer.getDetails(pd) + " has a DEFAULT of class " + defltClass.getCanonicalName());
            }
        }
        if (GenericTestBeanCustomizer.notOther(pd) && pd.getValue(TAGS) == null && pe.getTags() == null) {
            log.warn(GenericTestBeanCustomizer.getDetails(pd) + " does not have tags but other values are not allowed.");
        }
        if (!GenericTestBeanCustomizer.notNull(pd) && (propertyType = pd.getPropertyType()).isPrimitive()) {
            log.warn(GenericTestBeanCustomizer.getDetails(pd) + " allows null but is a primitive type");
        }
        if (!pd.attributeNames().hasMoreElements()) {
            log.warn(GenericTestBeanCustomizer.getDetails(pd) + " does not appear to have been configured");
        }
    }

    private static String getDetails(PropertyDescriptor pd) {
        StringBuilder sb = new StringBuilder();
        sb.append(pd.getReadMethod().getDeclaringClass().getName());
        sb.append('#');
        sb.append(pd.getName());
        sb.append('(');
        sb.append(pd.getPropertyType().getCanonicalName());
        sb.append(')');
        return sb.toString();
    }

    private WrapperEditor createWrapperEditor(PropertyEditor typeEditor, PropertyDescriptor descriptor) {
        String[] editorTags = typeEditor.getTags();
        String[] additionalTags = (String[])descriptor.getValue(TAGS);
        String[] tags = null;
        if (editorTags == null) {
            tags = additionalTags;
        } else if (additionalTags == null) {
            tags = editorTags;
        } else {
            tags = new String[editorTags.length + additionalTags.length];
            int j = 0;
            for (String editorTag : editorTags) {
                tags[j++] = editorTag;
            }
            for (String additionalTag : additionalTags) {
                tags[j++] = additionalTag;
            }
        }
        boolean notNull = GenericTestBeanCustomizer.notNull(descriptor);
        boolean notExpression = GenericTestBeanCustomizer.notExpression(descriptor);
        boolean notOther = GenericTestBeanCustomizer.notOther(descriptor);
        PropertyEditorSupport guiEditor = notNull && tags == null ? new FieldStringEditor() : new ComboStringEditor(tags, notExpression && notOther, notNull, (ResourceBundle)descriptor.getValue(RESOURCE_BUNDLE));
        WrapperEditor wrapper = new WrapperEditor(typeEditor, guiEditor, !notNull, !notExpression, !notOther, descriptor.getValue(DEFAULT));
        return wrapper;
    }

    static boolean notOther(PropertyDescriptor descriptor) {
        boolean notOther = Boolean.TRUE.equals(descriptor.getValue(NOT_OTHER));
        return notOther;
    }

    static boolean notExpression(PropertyDescriptor descriptor) {
        boolean notExpression = Boolean.TRUE.equals(descriptor.getValue(NOT_EXPRESSION));
        return notExpression;
    }

    static boolean notNull(PropertyDescriptor descriptor) {
        boolean notNull = Boolean.TRUE.equals(descriptor.getValue(NOT_UNDEFINED));
        return notNull;
    }

    static boolean noSaveDefault(PropertyDescriptor descriptor) {
        return Boolean.TRUE.equals(descriptor.getValue(DEFAULT_NOT_SAVED));
    }

    private void setEditorValue(int i, Object value) throws IllegalArgumentException {
        this.editors[i].setValue(value);
    }

    @Override
    public void setObject(Object map) {
        this.propertyMap = (Map)map;
        if (this.propertyMap.size() == 0) {
            for (PropertyDescriptor descriptor : this.descriptors) {
                Object value = descriptor.getValue(DEFAULT);
                String name = descriptor.getName();
                if (value != null) {
                    this.propertyMap.put(name, value);
                    log.debug("Set " + name + "= " + value);
                }
                this.firePropertyChange(name, null, value);
            }
        }
        for (int i = 0; i < this.editors.length; ++i) {
            if (this.editors[i] == null) continue;
            try {
                this.setEditorValue(i, this.propertyMap.get(this.descriptors[i].getName()));
                continue;
            }
            catch (IllegalArgumentException e) {
                this.setEditorValue(i, this.descriptors[i].getValue(DEFAULT));
            }
        }
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints cl = new GridBagConstraints();
        cl.gridx = 0;
        cl.anchor = 13;
        cl.insets = new Insets(0, 1, 0, 1);
        GridBagConstraints ce = new GridBagConstraints();
        ce.fill = 1;
        ce.gridx = 1;
        ce.weightx = 1.0;
        ce.insets = new Insets(0, 1, 0, 1);
        GridBagConstraints cp = new GridBagConstraints();
        cp.fill = 1;
        cp.gridx = 1;
        cp.gridy = -1;
        cp.gridwidth = 2;
        cp.weightx = 1.0;
        JPanel currentPanel = this;
        String currentGroup = DEFAULT_GROUP;
        int y = 0;
        for (int i = 0; i < this.editors.length; ++i) {
            String g;
            if (this.editors[i] == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("Laying property " + this.descriptors[i].getName());
            }
            if (!currentGroup.equals(g = GenericTestBeanCustomizer.group(this.descriptors[i]))) {
                if (currentPanel != this) {
                    this.add((Component)currentPanel, cp);
                }
                currentGroup = g;
                currentPanel = new JPanel(new GridBagLayout());
                currentPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.groupDisplayName(g)));
                cp.weighty = 0.0;
                y = 0;
            }
            Component customEditor = this.editors[i].getCustomEditor();
            boolean multiLineEditor = false;
            if (customEditor.getPreferredSize().height > 50 || customEditor instanceof JScrollPane || this.descriptors[i].getValue(MULTILINE) != null) {
                multiLineEditor = true;
            }
            JLabel label = this.createLabel(this.descriptors[i]);
            label.setLabelFor(customEditor);
            cl.gridy = y;
            cl.gridwidth = multiLineEditor ? 2 : 1;
            cl.anchor = multiLineEditor ? 10 : 13;
            currentPanel.add((Component)label, cl);
            ce.gridx = multiLineEditor ? 0 : 1;
            ce.gridy = multiLineEditor ? ++y : y;
            ce.gridwidth = multiLineEditor ? 2 : 1;
            ce.weighty = multiLineEditor ? 1.0 : 0.0;
            cp.weighty += ce.weighty;
            currentPanel.add(customEditor, ce);
            ++y;
        }
        if (currentPanel != this) {
            this.add((Component)currentPanel, cp);
        }
        cp.weighty = 1.0E-4;
        this.add(Box.createHorizontalStrut(0), cp);
    }

    private JLabel createLabel(PropertyDescriptor desc) {
        String text = desc.getDisplayName();
        if (!DEFAULT_GROUP.equals(text)) {
            text = this.propertyFieldLabelMessage.format(new Object[]{desc.getDisplayName()});
        }
        JLabel label = new JLabel(text);
        label.setHorizontalAlignment(11);
        label.setToolTipText(this.propertyToolTipMessage.format(new Object[]{desc.getShortDescription()}));
        return label;
    }

    private static String group(PropertyDescriptor descriptor) {
        String group = (String)descriptor.getValue(GROUP);
        if (group == null) {
            group = DEFAULT_GROUP;
        }
        return group;
    }

    private String groupDisplayName(String group) {
        ResourceBundle b = (ResourceBundle)this.beanInfo.getBeanDescriptor().getValue(RESOURCE_BUNDLE);
        if (b == null) {
            return group;
        }
        String key = group + ".displayName";
        if (b.containsKey(key)) {
            return b.getString(key);
        }
        return group;
    }

    void saveGuiFields() {
        for (int i = 0; i < this.editors.length; ++i) {
            PropertyEditor propertyEditor = this.editors[i];
            if (propertyEditor == null) continue;
            Object value = propertyEditor.getValue();
            String name = this.descriptors[i].getName();
            if (value == null) {
                this.propertyMap.remove(name);
                if (!log.isDebugEnabled()) continue;
                log.debug("Unset " + name);
                continue;
            }
            this.propertyMap.put(name, value);
            if (!log.isDebugEnabled()) continue;
            log.debug("Set " + name + "= " + value);
        }
    }

    void clearGuiFields() {
        for (int i = 0; i < this.editors.length; ++i) {
            PropertyEditor propertyEditor = this.editors[i];
            if (propertyEditor == null) continue;
            try {
                if (propertyEditor instanceof ClearGui) {
                    ((ClearGui)((Object)propertyEditor)).clearGui();
                    continue;
                }
                if (propertyEditor instanceof WrapperEditor) {
                    WrapperEditor we = (WrapperEditor)propertyEditor;
                    String[] tags = we.getTags();
                    if (tags != null && tags.length > 0) {
                        we.setAsText(tags[0]);
                        continue;
                    }
                    we.resetValue();
                    continue;
                }
                propertyEditor.setAsText(DEFAULT_GROUP);
                continue;
            }
            catch (IllegalArgumentException ex) {
                log.error("Failed to set field " + this.descriptors[i].getName(), (Throwable)ex);
            }
        }
    }

    static {
        PropertyEditorManager.registerEditor(Long.class, LongPropertyEditor.class);
        PropertyEditorManager.registerEditor(Integer.class, IntegerPropertyEditor.class);
        PropertyEditorManager.registerEditor(Boolean.class, BooleanPropertyEditor.class);
    }

    private static class PropertyComparator
    implements Comparator<PropertyDescriptor>,
    Serializable {
        private static final long serialVersionUID = 240L;
        private final BeanInfo beanInfo;

        public PropertyComparator(BeanInfo beanInfo) {
            this.beanInfo = beanInfo;
        }

        @Override
        public int compare(PropertyDescriptor d1, PropertyDescriptor d2) {
            Integer po2;
            Integer go2;
            String g1 = GenericTestBeanCustomizer.group(d1);
            String g2 = GenericTestBeanCustomizer.group(d2);
            Integer go1 = this.groupOrder(g1);
            int result = go1.compareTo(go2 = this.groupOrder(g2));
            if (result != 0) {
                return result;
            }
            result = g1.compareTo(g2);
            if (result != 0) {
                return result;
            }
            Integer po1 = this.propertyOrder(d1);
            result = po1.compareTo(po2 = this.propertyOrder(d2));
            if (result != 0) {
                return result;
            }
            return d1.getName().compareTo(d2.getName());
        }

        private Integer groupOrder(String group) {
            Integer order = (Integer)this.beanInfo.getBeanDescriptor().getValue(GenericTestBeanCustomizer.ORDER(group));
            if (order == null) {
                order = 0;
            }
            return order;
        }

        private Integer propertyOrder(PropertyDescriptor d) {
            Integer order = (Integer)d.getValue(GenericTestBeanCustomizer.ORDER);
            if (order == null) {
                order = 0;
            }
            return order;
        }
    }
}

