/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.RemoteThreadsLifeCycleListener;
import org.apache.jmeter.threads.RemoteThreadsListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.log.Logger;

public class RemoteThreadsListenerImpl
extends UnicastRemoteObject
implements RemoteThreadsListener,
ThreadListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final List<RemoteThreadsLifeCycleListener> listeners = new ArrayList<RemoteThreadsLifeCycleListener>();
    private static final long serialVersionUID = 4790505101521183660L;
    private static final int DEFAULT_LOCAL_PORT = JMeterUtils.getPropDefault("client.rmi.localport", 0);

    public RemoteThreadsListenerImpl() throws RemoteException {
        super(DEFAULT_LOCAL_PORT);
        try {
            List listClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{RemoteThreadsLifeCycleListener.class});
            for (String strClassName : listClasses) {
                try {
                    Class<?> commandClass;
                    if (log.isDebugEnabled()) {
                        log.debug("Loading class: " + strClassName);
                    }
                    if (Modifier.isAbstract((commandClass = Class.forName(strClassName)).getModifiers())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Instantiating: " + commandClass.getName());
                    }
                    RemoteThreadsLifeCycleListener listener = (RemoteThreadsLifeCycleListener)commandClass.newInstance();
                    this.listeners.add(listener);
                }
                catch (Exception e) {
                    log.error("Exception registering " + RemoteThreadsLifeCycleListener.class.getName() + " with implementation:" + strClassName, (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            log.error("Exception finding implementations of " + RemoteThreadsLifeCycleListener.class, (Throwable)e);
        }
    }

    @Override
    public void threadStarted() {
        JMeterContextService.incrNumberOfThreads();
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null) {
            gp.getMainFrame().updateCounts();
        }
        for (RemoteThreadsLifeCycleListener listener : this.listeners) {
            listener.threadNumberIncreased(JMeterContextService.getNumberOfThreads());
        }
    }

    @Override
    public void threadFinished() {
        JMeterContextService.decrNumberOfThreads();
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null) {
            gp.getMainFrame().updateCounts();
        }
        for (RemoteThreadsLifeCycleListener listener : this.listeners) {
            listener.threadNumberDecreased(JMeterContextService.getNumberOfThreads());
        }
    }
}

