/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter;

import com.thoughtworks.xstream.converters.ConversionException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.cli.avalon.CLArgsParser;
import org.apache.commons.cli.avalon.CLOption;
import org.apache.commons.cli.avalon.CLOptionDescriptor;
import org.apache.commons.cli.avalon.CLUtil;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.NewDriver;
import org.apache.jmeter.ProxyAuthenticator;
import org.apache.jmeter.control.ReplaceableController;
import org.apache.jmeter.engine.ClientJMeterEngine;
import org.apache.jmeter.engine.DistributedRunner;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.engine.RemoteJMeterEngineImpl;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Load;
import org.apache.jmeter.gui.action.LoadRecentProject;
import org.apache.jmeter.gui.action.LookAndFeelCommand;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.FocusRequester;
import org.apache.jmeter.plugin.JMeterPlugin;
import org.apache.jmeter.plugin.PluginManager;
import org.apache.jmeter.report.config.ConfigurationException;
import org.apache.jmeter.report.dashboard.GenerationException;
import org.apache.jmeter.report.dashboard.ReportGenerator;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.reporters.Summariser;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.RemoteThreadsListenerTestElement;
import org.apache.jmeter.util.BeanShellInterpreter;
import org.apache.jmeter.util.BeanShellServer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.SearchByClass;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassTools;
import org.apache.jorphan.util.HeapDumper;
import org.apache.jorphan.util.JMeterException;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class JMeter
implements JMeterPlugin {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final int UDP_PORT_DEFAULT = 4445;
    public static final String HTTP_PROXY_PASS = "http.proxyPass";
    public static final String HTTP_PROXY_USER = "http.proxyUser";
    public static final String JMETER_NON_GUI = "JMeter.NonGui";
    public static final String JMETER_REPORT_OUTPUT_DIR_PROPERTY = "jmeter.reportgenerator.outputdir";
    public static final String TREE_ICON_SIZE = "jmeter.tree.icons.size";
    public static final String DEFAULT_TREE_ICON_SIZE = "19x19";
    protected static final String KEY_SIZE = "<SIZE>";
    private static final String USE_LAST_JMX = "LAST";
    private static final int PROXY_PASSWORD = 97;
    private static final int JMETER_HOME_OPT = 100;
    private static final int HELP_OPT = 104;
    private static final int OPTIONS_OPT = 63;
    private static final int JMLOGFILE_OPT = 106;
    private static final int LOGFILE_OPT = 108;
    private static final int NONGUI_OPT = 110;
    private static final int PROPFILE_OPT = 112;
    private static final int PROPFILE2_OPT = 113;
    private static final int REMOTE_OPT = 114;
    private static final int SERVER_OPT = 115;
    private static final int TESTFILE_OPT = 116;
    private static final int PROXY_USERNAME = 117;
    private static final int VERSION_OPT = 118;
    private static final int REPORT_GENERATING_OPT = 103;
    private static final int REPORT_AT_END_OPT = 101;
    private static final int REPORT_OUTPUT_FOLDER_OPT = 111;
    private static final int SYSTEM_PROPERTY = 68;
    private static final int JMETER_GLOBAL_PROP = 71;
    private static final int PROXY_HOST = 72;
    private static final int JMETER_PROPERTY = 74;
    private static final int LOGLEVEL = 76;
    private static final int NONPROXY_HOSTS = 78;
    private static final int PROXY_PORT = 80;
    private static final int REMOTE_OPT_PARAM = 82;
    private static final int SYSTEM_PROPFILE = 83;
    private static final int REMOTE_STOP = 88;
    private static final CLOptionDescriptor D_OPTIONS_OPT = new CLOptionDescriptor("?", 8, 63, "print command line options and exit");
    private static final CLOptionDescriptor D_HELP_OPT = new CLOptionDescriptor("help", 8, 104, "print usage information and exit");
    private static final CLOptionDescriptor D_VERSION_OPT = new CLOptionDescriptor("version", 8, 118, "print the version information and exit");
    private static final CLOptionDescriptor D_PROPFILE_OPT = new CLOptionDescriptor("propfile", 2, 112, "the jmeter property file to use");
    private static final CLOptionDescriptor D_PROPFILE2_OPT = new CLOptionDescriptor("addprop", 34, 113, "additional JMeter property file(s)");
    private static final CLOptionDescriptor D_TESTFILE_OPT = new CLOptionDescriptor("testfile", 2, 116, "the jmeter test(.jmx) file to run");
    private static final CLOptionDescriptor D_LOGFILE_OPT = new CLOptionDescriptor("logfile", 2, 108, "the file to log samples to");
    private static final CLOptionDescriptor D_JMLOGFILE_OPT = new CLOptionDescriptor("jmeterlogfile", 2, 106, "jmeter run log file (jmeter.log)");
    private static final CLOptionDescriptor D_NONGUI_OPT = new CLOptionDescriptor("nongui", 8, 110, "run JMeter in nongui mode");
    private static final CLOptionDescriptor D_SERVER_OPT = new CLOptionDescriptor("server", 8, 115, "run the JMeter server");
    private static final CLOptionDescriptor D_PROXY_HOST = new CLOptionDescriptor("proxyHost", 2, 72, "Set a proxy server for JMeter to use");
    private static final CLOptionDescriptor D_PROXY_PORT = new CLOptionDescriptor("proxyPort", 2, 80, "Set proxy server port for JMeter to use");
    private static final CLOptionDescriptor D_NONPROXY_HOSTS = new CLOptionDescriptor("nonProxyHosts", 2, 78, "Set nonproxy host list (e.g. *.apache.org|localhost)");
    private static final CLOptionDescriptor D_PROXY_USERNAME = new CLOptionDescriptor("username", 2, 117, "Set username for proxy server that JMeter is to use");
    private static final CLOptionDescriptor D_PROXY_PASSWORD = new CLOptionDescriptor("password", 2, 97, "Set password for proxy server that JMeter is to use");
    private static final CLOptionDescriptor D_JMETER_PROPERTY = new CLOptionDescriptor("jmeterproperty", 48, 74, "Define additional JMeter properties");
    private static final CLOptionDescriptor D_JMETER_GLOBAL_PROP = new CLOptionDescriptor("globalproperty", 48, 71, "Define Global properties (sent to servers)\n\t\te.g. -Gport=123 or -Gglobal.properties");
    private static final CLOptionDescriptor D_SYSTEM_PROPERTY = new CLOptionDescriptor("systemproperty", 48, 68, "Define additional system properties");
    private static final CLOptionDescriptor D_SYSTEM_PROPFILE = new CLOptionDescriptor("systemPropertyFile", 34, 83, "additional system property file(s)");
    private static final CLOptionDescriptor D_LOGLEVEL = new CLOptionDescriptor("loglevel", 48, 76, "[category=]level e.g. jorphan=INFO or jmeter.util=DEBUG");
    private static final CLOptionDescriptor D_REMOTE_OPT = new CLOptionDescriptor("runremote", 8, 114, "Start remote servers (as defined in remote_hosts)");
    private static final CLOptionDescriptor D_REMOTE_OPT_PARAM = new CLOptionDescriptor("remotestart", 2, 82, "Start these remote servers (overrides remote_hosts)");
    private static final CLOptionDescriptor D_JMETER_HOME_OPT = new CLOptionDescriptor("homedir", 2, 100, "the jmeter home directory to use");
    private static final CLOptionDescriptor D_REMOTE_STOP = new CLOptionDescriptor("remoteexit", 8, 88, "Exit the remote servers at end of test (non-GUI)");
    private static final CLOptionDescriptor D_REPORT_GENERATING_OPT = new CLOptionDescriptor("reportonly", 2, 103, "generate report dashboard only, from a test results file", new CLOptionDescriptor[]{D_NONGUI_OPT, D_REMOTE_OPT, D_REMOTE_OPT_PARAM, D_LOGFILE_OPT});
    private static final CLOptionDescriptor D_REPORT_AT_END_OPT = new CLOptionDescriptor("reportatendofloadtests", 8, 101, "generate report dashboard after load test");
    private static final CLOptionDescriptor D_REPORT_OUTPUT_FOLDER_OPT = new CLOptionDescriptor("reportoutputfolder", 2, 111, "output folder for report dashboard");
    private static final CLOptionDescriptor[] options = new CLOptionDescriptor[]{D_OPTIONS_OPT, D_HELP_OPT, D_VERSION_OPT, D_PROPFILE_OPT, D_PROPFILE2_OPT, D_TESTFILE_OPT, D_LOGFILE_OPT, D_JMLOGFILE_OPT, D_NONGUI_OPT, D_SERVER_OPT, D_PROXY_HOST, D_PROXY_PORT, D_NONPROXY_HOSTS, D_PROXY_USERNAME, D_PROXY_PASSWORD, D_JMETER_PROPERTY, D_JMETER_GLOBAL_PROP, D_SYSTEM_PROPERTY, D_SYSTEM_PROPFILE, D_LOGLEVEL, D_REMOTE_OPT, D_REMOTE_OPT_PARAM, D_JMETER_HOME_OPT, D_REMOTE_STOP, D_REPORT_GENERATING_OPT, D_REPORT_AT_END_OPT, D_REPORT_OUTPUT_FOLDER_OPT};
    private JMeter parent;
    private Properties remoteProps;
    private boolean remoteStop;
    private static final String[][] DEFAULT_ICONS = new String[][]{{"org.apache.jmeter.control.gui.TestPlanGui", "org/apache/jmeter/images/beaker.gif"}, {"org.apache.jmeter.timers.gui.AbstractTimerGui", "org/apache/jmeter/images/timer.gif"}, {"org.apache.jmeter.threads.gui.ThreadGroupGui", "org/apache/jmeter/images/thread.gif"}, {"org.apache.jmeter.visualizers.gui.AbstractListenerGui", "org/apache/jmeter/images/meter.png"}, {"org.apache.jmeter.config.gui.AbstractConfigGui", "org/apache/jmeter/images/testtubes.png"}, {"org.apache.jmeter.processor.gui.AbstractPreProcessorGui", "org/apache/jmeter/images/leafnode.gif"}, {"org.apache.jmeter.processor.gui.AbstractPostProcessorGui", "org/apache/jmeter/images/leafnodeflip.gif"}, {"org.apache.jmeter.control.gui.AbstractControllerGui", "org/apache/jmeter/images/knob.gif"}, {"org.apache.jmeter.control.gui.WorkBenchGui", "org/apache/jmeter/images/clipboard.gif"}, {"org.apache.jmeter.samplers.gui.AbstractSamplerGui", "org/apache/jmeter/images/pipet.png"}, {"org.apache.jmeter.assertions.gui.AbstractAssertionGui", "org/apache/jmeter/images/question.gif"}};

    private void startGui(String testFile) {
        System.out.println("================================================================================");
        System.out.println("Don't use GUI mode for load testing, only for Test creation and Test debugging !");
        System.out.println("For load testing, use NON GUI Mode & adapt Java Heap to your test requirements");
        System.out.println("================================================================================");
        String jMeterLaf = LookAndFeelCommand.getJMeterLaf();
        try {
            UIManager.setLookAndFeel(jMeterLaf);
        }
        catch (Exception ex) {
            log.warn("Could not set LAF to:" + jMeterLaf, (Throwable)ex);
        }
        PluginManager.install(this, true);
        JMeterTreeModel treeModel = new JMeterTreeModel();
        JMeterTreeListener treeLis = new JMeterTreeListener(treeModel);
        ActionRouter instance = ActionRouter.getInstance();
        instance.populateCommandMap();
        treeLis.setActionHandler(instance);
        GuiPackage.initInstance(treeLis, treeModel);
        MainFrame main = new MainFrame(treeModel, treeLis);
        ComponentUtil.centerComponentInWindow((Component)main, (int)80);
        main.setVisible(true);
        instance.actionPerformed(new ActionEvent(main, 1, "add_all"));
        if (testFile != null) {
            try {
                File f = new File(testFile);
                log.info("Loading file: " + f);
                FileServer.getFileServer().setBaseForScript(f);
                HashTree tree = SaveService.loadTree(f);
                GuiPackage.getInstance().setTestPlanFile(f.getAbsolutePath());
                Load.insertLoadedTree(1, tree);
            }
            catch (ConversionException e) {
                log.error("Failure loading test file", (Throwable)e);
                JMeterUtils.reportErrorToUser(SaveService.CEtoString(e));
            }
            catch (Exception e) {
                log.error("Failure loading test file", (Throwable)e);
                JMeterUtils.reportErrorToUser(e.toString());
            }
        } else {
            JTree jTree = GuiPackage.getInstance().getMainFrame().getTree();
            TreePath path = jTree.getPathForRow(0);
            jTree.setSelectionPath(path);
            FocusRequester.requestFocus(jTree);
        }
    }

    public void start(String[] args) {
        block23: {
            CLArgsParser parser = new CLArgsParser(args, options);
            String error = parser.getErrorString();
            if (error == null) {
                boolean nonGuiOnly;
                boolean gui = parser.getArgumentById(110) == null;
                boolean bl = nonGuiOnly = parser.getArgumentById(114) != null || parser.getArgumentById(82) != null || parser.getArgumentById(88) != null;
                if (gui && nonGuiOnly) {
                    error = "-r and -R and -X are only valid in non-GUI mode";
                }
            }
            if (null != error) {
                System.err.println("Error: " + error);
                System.out.println("Usage");
                System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])options).toString());
                System.out.println("Error: " + error);
                return;
            }
            try {
                CLOption testReportOpt;
                this.initializeProperties(parser);
                if (System.getProperty("org.apache.commons.logging.Log") == null) {
                    System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.LogKitLogger");
                }
                Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        if (!(e instanceof ThreadDeath)) {
                            log.error("Uncaught exception: ", e);
                            System.err.println("Uncaught Exception " + e + ". See log file for details.");
                        }
                    }
                });
                log.info(JMeterUtils.getJMeterCopyright());
                log.info("Version " + JMeterUtils.getJMeterVersion());
                this.logProperty("java.version");
                this.logProperty("java.vm.name");
                this.logProperty("os.name");
                this.logProperty("os.arch");
                this.logProperty("os.version");
                this.logProperty("file.encoding");
                log.info("Max memory     =" + Runtime.getRuntime().maxMemory());
                log.info("Available Processors =" + Runtime.getRuntime().availableProcessors());
                log.info("Default Locale=" + Locale.getDefault().getDisplayName());
                log.info("JMeter  Locale=" + JMeterUtils.getLocale().getDisplayName());
                log.info("JMeterHome=" + JMeterUtils.getJMeterHome());
                this.logProperty("user.dir", "  =");
                log.info("PWD       =" + new File(".").getCanonicalPath());
                log.info("IP: " + JMeterUtils.getLocalHostIP() + " Name: " + JMeterUtils.getLocalHostName() + " FullName: " + JMeterUtils.getLocalHostFullName());
                this.setProxy(parser);
                this.updateClassLoader();
                if (log.isDebugEnabled()) {
                    String jcp = System.getProperty("java.class.path");
                    String[] bits = jcp.split(File.pathSeparator);
                    log.debug("ClassPath");
                    for (String bit : bits) {
                        log.debug(bit);
                    }
                }
                long now = System.currentTimeMillis();
                JMeterUtils.setProperty("START.MS", Long.toString(now));
                Date today = new Date(now);
                JMeterUtils.setProperty("START.YMD", new SimpleDateFormat("yyyyMMdd").format(today));
                JMeterUtils.setProperty("START.HMS", new SimpleDateFormat("HHmmss").format(today));
                if (parser.getArgumentById(118) != null) {
                    this.displayAsciiArt();
                    break block23;
                }
                if (parser.getArgumentById(104) != null) {
                    this.displayAsciiArt();
                    System.out.println(JMeterUtils.getResourceFileAsText("org/apache/jmeter/help.txt"));
                    break block23;
                }
                if (parser.getArgumentById(63) != null) {
                    this.displayAsciiArt();
                    System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])options).toString());
                    break block23;
                }
                if (parser.getArgumentById(115) != null) {
                    try {
                        RemoteJMeterEngineImpl.startServer(JMeterUtils.getPropDefault("server_port", 0));
                    }
                    catch (Exception ex) {
                        System.err.println("Server failed to start: " + ex);
                        log.error("Giving up, as server failed with:", (Throwable)ex);
                        throw ex;
                    }
                    this.startOptionalServers();
                    break block23;
                }
                String testFile = null;
                CLOption testFileOpt = parser.getArgumentById(116);
                if (testFileOpt != null && USE_LAST_JMX.equals(testFile = testFileOpt.getArgument())) {
                    testFile = LoadRecentProject.getRecentFile(0);
                }
                if ((testReportOpt = parser.getArgumentById(103)) != null) {
                    String reportFile = testReportOpt.getArgument();
                    this.extractAndSetReportOutputFolder(parser);
                    ReportGenerator generator = new ReportGenerator(reportFile, null);
                    generator.generate();
                } else if (parser.getArgumentById(110) == null) {
                    this.startGui(testFile);
                    this.startOptionalServers();
                } else {
                    CLOption reportAtEndOpt;
                    this.extractAndSetReportOutputFolder(parser);
                    CLOption rem = parser.getArgumentById(82);
                    if (rem == null) {
                        rem = parser.getArgumentById(114);
                    }
                    CLOption jtl = parser.getArgumentById(108);
                    String jtlFile = null;
                    if (jtl != null) {
                        jtlFile = this.processLAST(jtl.getArgument(), ".jtl");
                    }
                    if ((reportAtEndOpt = parser.getArgumentById(101)) != null && jtlFile == null) {
                        throw new IllegalUserActionException("Option -e requires -l option");
                    }
                    this.startNonGui(testFile, jtlFile, rem, reportAtEndOpt != null);
                    this.startOptionalServers();
                }
            }
            catch (IllegalUserActionException e) {
                System.out.println("Incorrect Usage:" + e.getMessage());
                System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])options).toString());
            }
            catch (Throwable e) {
                log.fatalError("An error occurred: ", e);
                System.out.println("An error occurred: " + e.getMessage());
                System.exit(1);
            }
        }
    }

    private void extractAndSetReportOutputFolder(CLArgsParser parser) throws IllegalArgumentException {
        CLOption reportOutputFolderOpt = parser.getArgumentById(111);
        if (reportOutputFolderOpt != null) {
            String reportOutputFolder = parser.getArgumentById(111).getArgument();
            File reportOutputFolderAsFile = new File(reportOutputFolder);
            JOrphanUtils.canSafelyWriteToFolder((File)reportOutputFolderAsFile);
            log.info("Setting property 'jmeter.reportgenerator.outputdir' to:'" + reportOutputFolderAsFile.getAbsolutePath() + "'");
            JMeterUtils.setProperty(JMETER_REPORT_OUTPUT_DIR_PROPERTY, reportOutputFolderAsFile.getAbsolutePath());
        }
    }

    private void displayAsciiArt() {
        try (InputStream inputStream = JMeter.class.getResourceAsStream("jmeter_as_ascii_art.txt");){
            if (inputStream != null) {
                String text = IOUtils.toString((InputStream)inputStream);
                System.out.println(text);
            }
        }
        catch (Exception e1) {
            System.out.println(JMeterUtils.getJMeterCopyright());
            System.out.println("Version " + JMeterUtils.getJMeterVersion());
        }
    }

    private void updateClassLoader() {
        this.updatePath("search_paths", ";", true);
        this.updatePath("user.classpath", File.pathSeparator, true);
        this.updatePath("plugin_dependency_paths", ";", false);
    }

    private void updatePath(String property, String sep, boolean cp) {
        String userpath = JMeterUtils.getPropDefault(property, "");
        if (userpath.length() <= 0) {
            return;
        }
        log.info(property + "=" + userpath);
        StringTokenizer tok = new StringTokenizer(userpath, sep);
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            File f = new File(path);
            if (!f.canRead() && !f.isDirectory()) {
                log.warn("Can't read " + path);
                continue;
            }
            if (cp) {
                log.info("Adding to classpath and loader: " + path);
                try {
                    NewDriver.addPath((String)path);
                }
                catch (MalformedURLException e) {
                    log.warn("Error adding: " + path + " " + e.getLocalizedMessage());
                }
                continue;
            }
            log.info("Adding to loader: " + path);
            NewDriver.addURL((String)path);
        }
    }

    private void startOptionalServers() {
        int mirrorPort;
        String bshinit;
        int bshport = JMeterUtils.getPropDefault("beanshell.server.port", 0);
        String bshfile = JMeterUtils.getPropDefault("beanshell.server.file", "");
        if (bshport > 0) {
            log.info("Starting Beanshell server (" + bshport + "," + bshfile + ")");
            BeanShellServer t = new BeanShellServer(bshport, bshfile);
            t.run();
        }
        if ((bshinit = JMeterUtils.getProperty("beanshell.init.file")) != null) {
            log.info("Run Beanshell on file: " + bshinit);
            try {
                BeanShellInterpreter bsi = new BeanShellInterpreter();
                bsi.source(bshinit);
            }
            catch (ClassNotFoundException e) {
                log.warn("Could not start Beanshell: " + e.getLocalizedMessage());
            }
            catch (JMeterException e) {
                log.warn("Could not process Beanshell file: " + e.getLocalizedMessage());
            }
        }
        if ((mirrorPort = JMeterUtils.getPropDefault("mirror.server.port", 0)) > 0) {
            log.info("Starting Mirror server (" + mirrorPort + ")");
            try {
                Object instance = ClassTools.construct((String)"org.apache.jmeter.protocol.http.control.HttpMirrorControl", (int)mirrorPort);
                ClassTools.invoke((Object)instance, (String)"startHttpMirror");
            }
            catch (JMeterException e) {
                log.warn("Could not start Mirror server", (Throwable)e);
            }
        }
    }

    private void setProxy(CLArgsParser parser) throws IllegalUserActionException {
        if (parser.getArgumentById(117) != null) {
            String u;
            Properties jmeterProps = JMeterUtils.getJMeterProperties();
            if (parser.getArgumentById(97) != null) {
                u = parser.getArgumentById(117).getArgument();
                String p = parser.getArgumentById(97).getArgument();
                Authenticator.setDefault(new ProxyAuthenticator(u, p));
                log.info("Set Proxy login: " + u + "/" + p);
                jmeterProps.setProperty(HTTP_PROXY_USER, u);
                jmeterProps.setProperty(HTTP_PROXY_PASS, p);
            } else {
                u = parser.getArgumentById(117).getArgument();
                Authenticator.setDefault(new ProxyAuthenticator(u, ""));
                log.info("Set Proxy login: " + u);
                jmeterProps.setProperty(HTTP_PROXY_USER, u);
            }
        }
        if (parser.getArgumentById(72) != null && parser.getArgumentById(80) != null) {
            String h = parser.getArgumentById(72).getArgument();
            String p = parser.getArgumentById(80).getArgument();
            System.setProperty("http.proxyHost", h);
            System.setProperty("https.proxyHost", h);
            System.setProperty("http.proxyPort", p);
            System.setProperty("https.proxyPort", p);
            log.info("Set http[s].proxyHost: " + h + " Port: " + p);
        } else if (parser.getArgumentById(72) != null || parser.getArgumentById(80) != null) {
            throw new IllegalUserActionException(JMeterUtils.getResString("proxy_cl_error"));
        }
        if (parser.getArgumentById(78) != null) {
            String n = parser.getArgumentById(78).getArgument();
            System.setProperty("http.nonProxyHosts", n);
            System.setProperty("https.nonProxyHosts", n);
            log.info("Set http[s].nonProxyHosts: " + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void initializeProperties(CLArgsParser parser) {
        String sysProp;
        if (parser.getArgumentById(112) != null) {
            JMeterUtils.loadJMeterProperties(parser.getArgumentById(112).getArgument());
        } else {
            JMeterUtils.loadJMeterProperties(NewDriver.getJMeterDir() + File.separator + "bin" + File.separator + "jmeter.properties");
        }
        if (parser.getArgumentById(106) != null) {
            String jmlogfile = parser.getArgumentById(106).getArgument();
            jmlogfile = this.processLAST(jmlogfile, ".log");
            JMeterUtils.setProperty("log_file", jmlogfile);
        }
        JMeterUtils.initLogging();
        JMeterUtils.initLocale();
        if (parser.getArgumentById(100) == null) {
            JMeterUtils.setJMeterHome(NewDriver.getJMeterDir());
        } else {
            JMeterUtils.setJMeterHome(parser.getArgumentById(100).getArgument());
        }
        Properties jmeterProps = JMeterUtils.getJMeterProperties();
        this.remoteProps = new Properties();
        String userProp = JMeterUtils.getPropDefault("user.properties", "");
        if (userProp.length() > 0) {
            FileInputStream fis = null;
            try {
                File file = JMeterUtils.findFile(userProp);
                if (file.canRead()) {
                    log.info("Loading user properties from: " + file.getCanonicalPath());
                    fis = new FileInputStream(file);
                    Properties tmp = new Properties();
                    tmp.load(fis);
                    jmeterProps.putAll((Map<?, ?>)tmp);
                    LoggingManager.setLoggingLevels((Properties)tmp);
                }
            }
            catch (IOException e) {
                log.warn("Error loading user property file: " + userProp, (Throwable)e);
            }
            finally {
                JOrphanUtils.closeQuietly(fis);
            }
        }
        if ((sysProp = JMeterUtils.getPropDefault("system.properties", "")).length() > 0) {
            FileInputStream fis = null;
            try {
                File file = JMeterUtils.findFile(sysProp);
                if (file.canRead()) {
                    log.info("Loading system properties from: " + file.getCanonicalPath());
                    fis = new FileInputStream(file);
                    System.getProperties().load(fis);
                }
            }
            catch (IOException e) {
                log.warn("Error loading system property file: " + sysProp, (Throwable)e);
            }
            finally {
                JOrphanUtils.closeQuietly(fis);
            }
        }
        Vector clOptions = parser.getArguments();
        block38: for (CLOption option : clOptions) {
            String name = option.getArgument(0);
            String value = option.getArgument(1);
            FileInputStream fis = null;
            switch (option.getDescriptor().getId()) {
                case 0: {
                    throw new IllegalArgumentException("Unknown arg: " + option.getArgument());
                }
                case 113: {
                    try {
                        fis = new FileInputStream(new File(name));
                        Properties tmp = new Properties();
                        tmp.load(fis);
                        jmeterProps.putAll((Map<?, ?>)tmp);
                        LoggingManager.setLoggingLevels((Properties)tmp);
                    }
                    catch (FileNotFoundException e) {
                        log.warn("Can't find additional property file: " + name, (Throwable)e);
                        JOrphanUtils.closeQuietly((Closeable)fis);
                        break;
                    }
                    catch (IOException e2) {
                        log.warn("Error loading additional property file: " + name, (Throwable)e2);
                        {
                            catch (Throwable throwable) {
                                JOrphanUtils.closeQuietly(fis);
                                throw throwable;
                            }
                        }
                        JOrphanUtils.closeQuietly((Closeable)fis);
                        break;
                    }
                    JOrphanUtils.closeQuietly((Closeable)fis);
                    break;
                }
                case 83: {
                    log.info("Setting System properties from file: " + name);
                    try {
                        fis = new FileInputStream(new File(name));
                        System.getProperties().load(fis);
                        continue block38;
                    }
                    catch (IOException e) {
                        log.warn("Cannot find system property file " + e.getLocalizedMessage());
                        continue block38;
                    }
                    finally {
                        JOrphanUtils.closeQuietly((Closeable)fis);
                        continue block38;
                    }
                }
                case 68: {
                    if (value.length() > 0) {
                        log.info("Setting System property: " + name + "=" + value);
                        System.getProperties().setProperty(name, value);
                        break;
                    }
                    log.warn("Removing System property: " + name);
                    System.getProperties().remove(name);
                    break;
                }
                case 74: {
                    if (value.length() > 0) {
                        log.info("Setting JMeter property: " + name + "=" + value);
                        jmeterProps.setProperty(name, value);
                        break;
                    }
                    log.warn("Removing JMeter property: " + name);
                    jmeterProps.remove(name);
                    break;
                }
                case 71: {
                    if (value.length() > 0) {
                        log.info("Setting Global property: " + name + "=" + value);
                        this.remoteProps.setProperty(name, value);
                        break;
                    }
                    File propFile = new File(name);
                    if (!propFile.canRead()) continue block38;
                    log.info("Setting Global properties from the file " + name);
                    try {
                        fis = new FileInputStream(propFile);
                        this.remoteProps.load(fis);
                        continue block38;
                    }
                    catch (FileNotFoundException e) {
                        log.warn("Could not find properties file: " + e.getLocalizedMessage());
                        continue block38;
                    }
                    catch (IOException e) {
                        log.warn("Could not load properties file: " + e.getLocalizedMessage());
                        continue block38;
                    }
                    finally {
                        JOrphanUtils.closeQuietly((Closeable)fis);
                        continue block38;
                    }
                }
                case 76: {
                    if (value.length() > 0) {
                        log.info("LogLevel: " + name + "=" + value);
                        LoggingManager.setPriority((String)value, (String)name);
                        break;
                    }
                    log.warn("LogLevel: " + name);
                    LoggingManager.setPriority((String)name);
                    break;
                }
                case 88: {
                    this.remoteStop = true;
                    break;
                }
            }
        }
        String sampleVariables = (String)jmeterProps.get("sample_variables");
        if (sampleVariables != null) {
            this.remoteProps.put("sample_variables", sampleVariables);
        }
        jmeterProps.put("jmeter.version", JMeterUtils.getJMeterVersion());
    }

    private String processLAST(String jmlogfile, String suffix) {
        if (USE_LAST_JMX.equals(jmlogfile) || USE_LAST_JMX.concat(suffix).equals(jmlogfile)) {
            String last = LoadRecentProject.getRecentFile(0);
            String JMX_SUFFIX = ".JMX";
            if (last.toUpperCase(Locale.ENGLISH).endsWith(".JMX")) {
                jmlogfile = last.substring(0, last.length() - ".JMX".length()).concat(suffix);
            }
        }
        return jmlogfile;
    }

    private void startNonGui(String testFile, String logFile, CLOption remoteStart, boolean generateReportDashboard) throws IllegalUserActionException, ConfigurationException {
        System.setProperty(JMETER_NON_GUI, "true");
        JMeter driver = new JMeter();
        driver.remoteProps = this.remoteProps;
        driver.remoteStop = this.remoteStop;
        driver.parent = this;
        PluginManager.install(this, false);
        String remoteHostsString = null;
        if (remoteStart != null && (remoteHostsString = remoteStart.getArgument()) == null) {
            remoteHostsString = JMeterUtils.getPropDefault("remote_hosts", "127.0.0.1");
        }
        if (testFile == null) {
            throw new IllegalUserActionException("Non-GUI runs require a test plan");
        }
        driver.runNonGui(testFile, logFile, remoteStart != null, remoteHostsString, generateReportDashboard);
    }

    private void runNonGui(String testFile, String logFile, boolean remoteStart, String remote_hosts_string, boolean generateReportDashboard) {
        try {
            File f = new File(testFile);
            if (!f.exists() || !f.isFile()) {
                JMeter.println("Could not open " + testFile);
                return;
            }
            FileServer.getFileServer().setBaseForScript(f);
            HashTree tree = SaveService.loadTree(f);
            JMeterTreeModel treeModel = new JMeterTreeModel(new Object());
            JMeterTreeNode root = (JMeterTreeNode)treeModel.getRoot();
            treeModel.addSubTree(tree, root);
            SearchByClass replaceableControllers = new SearchByClass(ReplaceableController.class);
            tree.traverse((HashTreeTraverser)replaceableControllers);
            Collection replaceableControllersRes = replaceableControllers.getSearchResults();
            for (ReplaceableController replaceableController : replaceableControllersRes) {
                replaceableController.resolveReplacementSubTree(root);
            }
            JMeter.convertSubTree(tree);
            Summariser summer = null;
            String summariserName = JMeterUtils.getPropDefault("summariser.name", "");
            if (summariserName.length() > 0) {
                log.info("Creating summariser <" + summariserName + ">");
                JMeter.println("Creating summariser <" + summariserName + ">");
                summer = new Summariser(summariserName);
            }
            ReportGenerator reportGenerator = null;
            if (logFile != null) {
                ResultCollector logger = new ResultCollector(summer);
                logger.setFilename(logFile);
                tree.add(tree.getArray()[0], (Object)logger);
                if (generateReportDashboard) {
                    reportGenerator = new ReportGenerator(logFile, logger);
                }
            } else if (summer != null) {
                tree.add(tree.getArray()[0], summer);
            }
            tree.add(tree.getArray()[0], (Object)new RemoteThreadsListenerTestElement());
            LinkedList<JMeterEngine> engines = new LinkedList<JMeterEngine>();
            tree.add(tree.getArray()[0], (Object)new ListenToTest(this.parent, remoteStart && this.remoteStop ? engines : null, reportGenerator));
            JMeter.println("Created the tree successfully using " + testFile);
            if (!remoteStart) {
                StandardJMeterEngine engine = new StandardJMeterEngine();
                engine.configure(tree);
                long now = System.currentTimeMillis();
                JMeter.println("Starting the test @ " + new Date(now) + " (" + now + ")");
                engine.runTest();
                engines.add(engine);
            } else {
                StringTokenizer st = new StringTokenizer(remote_hosts_string, ",");
                LinkedList<String> hosts = new LinkedList<String>();
                while (st.hasMoreElements()) {
                    hosts.add((String)st.nextElement());
                }
                DistributedRunner distributedRunner = new DistributedRunner(this.remoteProps);
                distributedRunner.setStdout(System.out);
                distributedRunner.setStdErr(System.err);
                distributedRunner.init(hosts, tree);
                engines.addAll(distributedRunner.getEngines());
                distributedRunner.start();
            }
            JMeter.startUdpDdaemon(engines);
        }
        catch (Exception e) {
            System.out.println("Error in NonGUIDriver " + e.toString());
            log.error("Error in NonGUIDriver", (Throwable)e);
        }
    }

    public static void convertSubTree(HashTree tree) {
        LinkedList copyList = new LinkedList(tree.list());
        for (Object o : copyList) {
            Cloneable item;
            if (o instanceof TestElement) {
                item = (TestElement)o;
                if (item.isEnabled()) {
                    if (item instanceof ReplaceableController) {
                        HashTree replacementTree;
                        ReplaceableController rc = JMeter.ensureReplaceableControllerIsLoaded((TestElement)item);
                        HashTree subTree = tree.getTree((Object)item);
                        if (subTree == null || (replacementTree = rc.getReplacementSubTree()) == null) continue;
                        JMeter.convertSubTree(replacementTree);
                        tree.replaceKey((Object)item, (Object)rc);
                        tree.set((Object)rc, replacementTree);
                        continue;
                    }
                    JMeter.convertSubTree(tree.getTree((Object)item));
                    continue;
                }
                tree.remove((Object)item);
                continue;
            }
            item = (JMeterTreeNode)o;
            if (((JMeterTreeNode)item).isEnabled()) {
                if (((DefaultMutableTreeNode)item).getUserObject() instanceof ReplaceableController) {
                    HashTree replacementTree;
                    TestElement controllerAsItem = ((JMeterTreeNode)item).getTestElement();
                    ReplaceableController rc = JMeter.ensureReplaceableControllerIsLoaded(controllerAsItem);
                    HashTree subTree = tree.getTree((Object)item);
                    if (subTree == null || (replacementTree = rc.getReplacementSubTree()) == null) continue;
                    JMeter.convertSubTree(replacementTree);
                    tree.replaceKey((Object)item, (Object)rc);
                    tree.set((Object)rc, replacementTree);
                    continue;
                }
                JMeter.convertSubTree(tree.getTree((Object)item));
                TestElement testElement = ((JMeterTreeNode)item).getTestElement();
                tree.replaceKey((Object)item, (Object)testElement);
                continue;
            }
            tree.remove((Object)item);
        }
    }

    private static ReplaceableController ensureReplaceableControllerIsLoaded(TestElement item) {
        ReplaceableController rc = item.getClass().getName().equals("org.apache.jmeter.control.ModuleController") ? (ReplaceableController)((Object)item) : (ReplaceableController)item.clone();
        return rc;
    }

    private static void println(String str) {
        System.out.println(str);
    }

    @Override
    public String[][] getIconMappings() {
        String defaultIconProp = "org/apache/jmeter/images/icon.properties";
        String iconSize = JMeterUtils.getPropDefault(TREE_ICON_SIZE, DEFAULT_TREE_ICON_SIZE);
        String iconProp = JMeterUtils.getPropDefault("jmeter.icons", "org/apache/jmeter/images/icon.properties");
        Properties p = JMeterUtils.loadProperties(iconProp);
        if (p == null && !iconProp.equals("org/apache/jmeter/images/icon.properties")) {
            log.info(iconProp + " not found - using " + "org/apache/jmeter/images/icon.properties");
            iconProp = "org/apache/jmeter/images/icon.properties";
            p = JMeterUtils.loadProperties(iconProp);
        }
        if (p == null) {
            log.info(iconProp + " not found - using inbuilt icon set");
            return DEFAULT_ICONS;
        }
        log.info("Loaded icon properties from " + iconProp);
        String[][] iconlist = new String[p.size()][3];
        Enumeration<Object> pe = p.keys();
        int i = 0;
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            String[] icons = JOrphanUtils.split((String)p.getProperty(key), (String)" ");
            iconlist[i][0] = key;
            iconlist[i][1] = icons[0].replace(KEY_SIZE, iconSize);
            if (icons.length > 1) {
                iconlist[i][2] = icons[1].replace(KEY_SIZE, iconSize);
            }
            ++i;
        }
        return iconlist;
    }

    @Override
    public String[][] getResourceBundles() {
        return new String[0][];
    }

    public static boolean isNonGUI() {
        return "true".equals(System.getProperty(JMETER_NON_GUI));
    }

    private void logProperty(String prop) {
        log.info(prop + "=" + System.getProperty(prop));
    }

    private void logProperty(String prop, String separator) {
        log.info(prop + separator + System.getProperty(prop));
    }

    private static void startUdpDdaemon(final List<JMeterEngine> engines) {
        int port = JMeterUtils.getPropDefault("jmeterengine.nongui.port", 4445);
        int maxPort = JMeterUtils.getPropDefault("jmeterengine.nongui.maxport", 4455);
        if (port > 1000) {
            final DatagramSocket socket = JMeter.getSocket(port, maxPort);
            if (socket != null) {
                Thread waiter = new Thread("UDP Listener"){

                    @Override
                    public void run() {
                        JMeter.waitForSignals(engines, socket);
                    }
                };
                waiter.setDaemon(true);
                waiter.start();
            } else {
                System.out.println("Failed to create UDP port");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForSignals(List<JMeterEngine> engines, DatagramSocket socket) {
        byte[] buf = new byte[80];
        System.out.println("Waiting for possible Shutdown/StopTestNow/Heapdump message on port " + socket.getLocalPort());
        DatagramPacket request = new DatagramPacket(buf, buf.length);
        try {
            try {
                block4: while (true) {
                    JMeterEngine engine;
                    Iterator<JMeterEngine> i$;
                    socket.receive(request);
                    InetAddress address = request.getAddress();
                    if (!address.isLoopbackAddress()) continue;
                    String command = new String(request.getData(), request.getOffset(), request.getLength(), "ASCII");
                    System.out.println("Command: " + command + " received from " + address);
                    log.info("Command: " + command + " received from " + address);
                    if (command.equals("StopTestNow")) {
                        i$ = engines.iterator();
                        while (true) {
                            if (!i$.hasNext()) continue block4;
                            engine = i$.next();
                            engine.stopTest(true);
                        }
                    }
                    if (command.equals("Shutdown")) {
                        i$ = engines.iterator();
                        while (true) {
                            if (!i$.hasNext()) continue block4;
                            engine = i$.next();
                            engine.stopTest(false);
                        }
                    }
                    if (command.equals("HeapDump")) {
                        HeapDumper.dumpHeap();
                        continue;
                    }
                    System.out.println("Command: " + command + " not recognised ");
                }
            }
            catch (Exception e) {
                System.out.println(e);
                socket.close();
            }
        }
        catch (Throwable throwable) {
            socket.close();
            throw throwable;
        }
    }

    private static DatagramSocket getSocket(int udpPort, int udpPortMax) {
        DatagramSocket socket = null;
        for (int i = udpPort; i <= udpPortMax; ++i) {
            try {
                socket = new DatagramSocket(i);
                break;
            }
            catch (SocketException e) {
                continue;
            }
        }
        return socket;
    }

    private static class ListenToTest
    implements TestStateListener,
    Runnable,
    Remoteable {
        private final AtomicInteger started = new AtomicInteger(0);
        private final List<JMeterEngine> engines;
        private final ReportGenerator reportGenerator;

        public ListenToTest(JMeter unused, List<JMeterEngine> engines, ReportGenerator reportGenerator) {
            this.engines = engines;
            this.reportGenerator = reportGenerator;
        }

        @Override
        public void testEnded(String host) {
            long now = System.currentTimeMillis();
            log.info("Finished remote host: " + host + " (" + now + ")");
            if (this.started.decrementAndGet() <= 0) {
                Thread stopSoon = new Thread(this);
                stopSoon.setDaemon(false);
                stopSoon.start();
            }
        }

        @Override
        public void testEnded() {
            long now = System.currentTimeMillis();
            JMeter.println("Tidying up ...    @ " + new Date(now) + " (" + now + ")");
            try {
                this.generateReport();
            }
            catch (Exception e) {
                System.err.println("Error generating the report: " + e);
                log.error("Error generating the report", (Throwable)e);
            }
            this.checkForRemainingThreads();
            JMeter.println("... end of run");
        }

        @Override
        public void testStarted(String host) {
            this.started.incrementAndGet();
            long now = System.currentTimeMillis();
            log.info("Started remote host:  " + host + " (" + now + ")");
        }

        @Override
        public void testStarted() {
            long now = System.currentTimeMillis();
            log.info(JMeterUtils.getResString("running_test") + " (" + now + ")");
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            JMeter.println("Tidying up remote @ " + new Date(now) + " (" + now + ")");
            if (this.engines != null) {
                JMeter.println("Exiting remote servers");
                for (JMeterEngine e : this.engines) {
                    e.exit();
                }
            }
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException i$) {
                // empty catch block
            }
            ClientJMeterEngine.tidyRMI(log);
            try {
                this.generateReport();
            }
            catch (Exception e) {
                System.err.println("Error generating the report: " + e);
                log.error("Error generating the report", (Throwable)e);
            }
            this.checkForRemainingThreads();
            JMeter.println("... end of run");
        }

        private void generateReport() {
            if (this.reportGenerator != null) {
                try {
                    log.info("Generating Dashboard");
                    this.reportGenerator.generate();
                    log.info("Dashboard generated");
                }
                catch (GenerationException ex) {
                    log.error("Error generating dashboard:" + ex.getMessage(), (Throwable)ex);
                }
            }
        }

        private void checkForRemainingThreads() {
            final int REMAIN_THREAD_PAUSE = JMeterUtils.getPropDefault("jmeter.exit.check.pause", 2000);
            if (REMAIN_THREAD_PAUSE > 0) {
                Thread daemon = new Thread(){

                    @Override
                    public void run() {
                        try {
                            TimeUnit.MILLISECONDS.sleep(REMAIN_THREAD_PAUSE);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        System.out.println("The JVM should have exitted but did not.");
                        System.out.println("The following non-daemon threads are still running (DestroyJavaVM is OK):");
                        JOrphanUtils.displayThreads((boolean)false);
                    }
                };
                daemon.setDaemon(true);
                daemon.start();
            } else if (REMAIN_THREAD_PAUSE <= 0 && log.isDebugEnabled()) {
                log.debug("jmeter.exit.check.pause is <= 0, JMeter won't check for unterminated non-daemon threads");
            }
        }
    }
}

