/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class Clear
extends AbstractAction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public void doAction(ActionEvent e) {
        GuiPackage guiPackage = GuiPackage.getInstance();
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("action.clear")) {
            JMeterGUIComponent guiComp = guiPackage.getCurrentGui();
            if (guiComp instanceof Clearable) {
                ((Clearable)((Object)guiComp)).clearData();
            }
        } else if (actionCommand.equals("reset_gui")) {
            JMeterGUIComponent guiComp = guiPackage.getCurrentGui();
            guiComp.clearGui();
        } else {
            guiPackage.getMainFrame().clearData();
            for (JMeterTreeNode node : guiPackage.getTreeModel().getNodesOfType(Clearable.class)) {
                JMeterGUIComponent guiComp = guiPackage.getGui(node.getTestElement());
                if (!(guiComp instanceof Clearable)) continue;
                Clearable item = (Clearable)((Object)guiComp);
                try {
                    item.clearData();
                }
                catch (Exception ex) {
                    log.error("Can't clear: " + node + " " + guiComp, (Throwable)ex);
                }
            }
        }
    }

    static {
        commands.add("action.clear");
        commands.add("action.clear_all");
        commands.add("reset_gui");
    }
}

