/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class EnableComponent
extends AbstractAction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public void doAction(ActionEvent e) {
        JMeterTreeNode[] nodes = GuiPackage.getInstance().getTreeListener().getSelectedNodes();
        if (e.getActionCommand().equals("enable")) {
            log.debug("enabling currently selected gui objects");
            this.enableComponents(nodes, true);
        } else if (e.getActionCommand().equals("disable")) {
            log.debug("disabling currently selected gui objects");
            this.enableComponents(nodes, false);
        } else if (e.getActionCommand().equals("toggle")) {
            log.debug("toggling currently selected gui objects");
            this.toggleComponents(nodes);
        }
    }

    private void enableComponents(JMeterTreeNode[] nodes, boolean enable) {
        GuiPackage pack = GuiPackage.getInstance();
        for (JMeterTreeNode node : nodes) {
            node.setEnabled(enable);
            pack.getGui(node.getTestElement()).setEnabled(enable);
        }
    }

    private void toggleComponents(JMeterTreeNode[] nodes) {
        GuiPackage pack = GuiPackage.getInstance();
        for (JMeterTreeNode node : nodes) {
            boolean enable = !node.isEnabled();
            node.setEnabled(enable);
            pack.getGui(node.getTestElement()).setEnabled(enable);
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    static {
        commands.add("enable");
        commands.add("disable");
        commands.add("toggle");
    }
}

