/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import com.thoughtworks.xstream.converters.ConversionException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractActionWithNoRunningTest;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Close;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.gui.util.FocusRequester;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.WorkBench;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class Load
extends AbstractActionWithNoRunningTest {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final boolean expandTree = JMeterUtils.getPropDefault("onload.expandtree", false);
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public void doActionAfterCheck(ActionEvent e) {
        JFileChooser chooser = FileDialoger.promptToOpenFile(new String[]{".jmx"});
        if (chooser == null) {
            return;
        }
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile != null) {
            boolean merging = e.getActionCommand().equals("merge");
            if (!merging && !Close.performAction(e)) {
                return;
            }
            Load.loadProjectFile(e, selectedFile, merging);
        }
    }

    static void loadProjectFile(ActionEvent e, File f, boolean merging) {
        Load.loadProjectFile(e, f, merging, true);
    }

    static void loadProjectFile(ActionEvent e, File f, boolean merging, boolean setDetails) {
        ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "stop_thread"));
        GuiPackage guiPackage = GuiPackage.getInstance();
        if (f != null) {
            try {
                if (merging) {
                    log.info("Merging file: " + f);
                } else {
                    log.info("Loading file: " + f);
                    if (setDetails) {
                        FileServer.getFileServer().setBaseForScript(f);
                    }
                }
                HashTree tree = SaveService.loadTree(f);
                boolean isTestPlan = Load.insertLoadedTree(e.getID(), tree, merging);
                if (!merging && isTestPlan && setDetails) {
                    guiPackage.setTestPlanFile(f.getAbsolutePath());
                }
            }
            catch (NoClassDefFoundError ex) {
                Load.reportError("Missing jar file", ex, true);
            }
            catch (ConversionException ex) {
                log.warn("Could not convert file " + (Object)((Object)ex));
                JMeterUtils.reportErrorToUser(SaveService.CEtoString(ex));
            }
            catch (IOException ex) {
                Load.reportError("Error reading file: ", ex, false);
            }
            catch (Exception ex) {
                Load.reportError("Unexpected error", ex, true);
            }
            FileDialoger.setLastJFCDirectory(f.getParentFile().getAbsolutePath());
            guiPackage.updateCurrentGui();
            guiPackage.getMainFrame().repaint();
        }
    }

    public static boolean insertLoadedTree(int id, HashTree tree, boolean merging) throws IllegalUserActionException {
        boolean ok;
        TestElement te;
        if (tree == null) {
            throw new IllegalUserActionException("Empty TestPlan or error reading test plan - see log file");
        }
        boolean isTestPlan = tree.getArray()[0] instanceof TestPlan;
        GuiPackage guiInstance = GuiPackage.getInstance();
        if (isTestPlan && !merging) {
            guiInstance.clearTestPlan((TestElement)tree.getArray()[0]);
        }
        if (merging && !((te = (TestElement)tree.getArray()[0]) instanceof WorkBench) && !(te instanceof TestPlan) && !(ok = MenuFactory.canAddTo(guiInstance.getCurrentNode(), te))) {
            String name = te.getName();
            String className = te.getClass().getName();
            className = className.substring(className.lastIndexOf(46) + 1);
            throw new IllegalUserActionException("Can't merge " + name + " (" + className + ") here");
        }
        HashTree newTree = guiInstance.addSubTree(tree);
        guiInstance.updateCurrentGui();
        guiInstance.getMainFrame().getTree().setSelectionPath(new TreePath(((JMeterTreeNode)newTree.getArray()[0]).getPath()));
        HashTree subTree = guiInstance.getCurrentSubTree();
        ActionEvent actionEvent = new ActionEvent(subTree.get(subTree.getArray()[subTree.size() - 1]), id, merging ? "sub_tree_merged" : "sub_tree_loaded");
        ActionRouter.getInstance().actionPerformed(actionEvent);
        JTree jTree = guiInstance.getMainFrame().getTree();
        if (expandTree && !merging) {
            for (int i = 0; i < jTree.getRowCount(); ++i) {
                jTree.expandRow(i);
            }
        } else {
            jTree.expandRow(0);
        }
        jTree.setSelectionPath(jTree.getPathForRow(1));
        FocusRequester.requestFocus(jTree);
        return isTestPlan;
    }

    public static boolean insertLoadedTree(int id, HashTree tree) throws IllegalUserActionException {
        return Load.insertLoadedTree(id, tree, false);
    }

    private static void reportError(String reason, Throwable ex, boolean stackTrace) {
        if (stackTrace) {
            log.warn(reason, ex);
        } else {
            log.warn(reason + ex);
        }
        String msg = ex.getMessage();
        if (msg == null) {
            msg = "Unexpected error - see log for details";
        }
        JMeterUtils.reportErrorToUser(msg);
    }

    static {
        commands.add("open");
        commands.add("merge");
    }
}

