/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.jmeter.JMeter;
import org.apache.jmeter.engine.DistributedRunner;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.threads.RemoteThreadsListenerTestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;

public class RemoteStart
extends AbstractAction {
    private static final String LOCAL_HOST = "127.0.0.1";
    private static final String REMOTE_HOSTS = "remote_hosts";
    private static final String REMOTE_HOSTS_SEPARATOR = ",";
    private static final Set<String> commands = new HashSet<String>();
    private DistributedRunner distributedRunner = new DistributedRunner();

    @Override
    public void doAction(ActionEvent e) {
        String action;
        String name = ((Component)e.getSource()).getName();
        if (name != null) {
            name = name.trim();
        }
        if ((action = e.getActionCommand()).equals("remote_stop")) {
            GuiPackage.getInstance().getMainFrame().showStoppingMessage(name);
            this.distributedRunner.stop(Arrays.asList(name));
        } else if (action.equals("remote_shut")) {
            GuiPackage.getInstance().getMainFrame().showStoppingMessage(name);
            this.distributedRunner.shutdown(Arrays.asList(name));
        } else if (action.equals("remote_start")) {
            this.popupShouldSave(e);
            this.distributedRunner.init(Arrays.asList(name), this.getTestTree());
            this.distributedRunner.start(Arrays.asList(name));
        } else if (action.equals("remote_start_all")) {
            this.popupShouldSave(e);
            this.distributedRunner.init(this.getRemoteHosts(), this.getTestTree());
            this.distributedRunner.start();
        } else if (action.equals("remote_stop_all")) {
            this.distributedRunner.stop(this.getRemoteHosts());
        } else if (action.equals("remote_shut_all")) {
            this.distributedRunner.shutdown(this.getRemoteHosts());
        } else if (action.equals("remote_exit")) {
            this.distributedRunner.exit(Arrays.asList(name));
        } else if (action.equals("remote_exit_all")) {
            this.distributedRunner.exit(this.getRemoteHosts());
        }
    }

    private List<String> getRemoteHosts() {
        String remoteHostsString = JMeterUtils.getPropDefault(REMOTE_HOSTS, LOCAL_HOST);
        StringTokenizer st = new StringTokenizer(remoteHostsString, REMOTE_HOSTS_SEPARATOR);
        LinkedList<String> list = new LinkedList<String>();
        while (st.hasMoreElements()) {
            list.add((String)st.nextElement());
        }
        return list;
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    private HashTree getTestTree() {
        GuiPackage gui = GuiPackage.getInstance();
        HashTree testTree = gui.getTreeModel().getTestPlan();
        JMeter.convertSubTree(testTree);
        testTree.add(testTree.getArray()[0], (Object)gui.getMainFrame());
        testTree.add(testTree.getArray()[0], (Object)new RemoteThreadsListenerTestElement());
        return testTree;
    }

    static {
        commands.add("remote_start");
        commands.add("remote_stop");
        commands.add("remote_shut");
        commands.add("remote_start_all");
        commands.add("remote_stop_all");
        commands.add("remote_shut_all");
        commands.add("remote_exit");
        commands.add("remote_exit_all");
    }
}

