/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.jmeter.control.gui.TestFragmentControllerGui;
import org.apache.jmeter.engine.TreeCloner;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.WorkBench;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class Save
extends AbstractAction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final List<File> EMPTY_FILE_LIST = Collections.emptyList();
    private static final String JMX_BACKUP_ON_SAVE = "jmeter.gui.action.save.backup_on_save";
    private static final String JMX_BACKUP_DIRECTORY = "jmeter.gui.action.save.backup_directory";
    private static final String JMX_BACKUP_MAX_HOURS = "jmeter.gui.action.save.keep_backup_max_hours";
    private static final String JMX_BACKUP_MAX_COUNT = "jmeter.gui.action.save.keep_backup_max_count";
    public static final String JMX_FILE_EXTENSION = ".jmx";
    private static final String DEFAULT_BACKUP_DIRECTORY = JMeterUtils.getJMeterHome() + "/backups";
    private static final boolean BACKUP_ENABLED = JMeterUtils.getPropDefault("jmeter.gui.action.save.backup_on_save", true);
    private static final String BACKUP_DIRECTORY = JMeterUtils.getPropDefault("jmeter.gui.action.save.backup_directory", DEFAULT_BACKUP_DIRECTORY);
    private static final int BACKUP_MAX_HOURS = JMeterUtils.getPropDefault("jmeter.gui.action.save.keep_backup_max_hours", 0);
    private static final int BACKUP_MAX_COUNT = JMeterUtils.getPropDefault("jmeter.gui.action.save.keep_backup_max_count", 10);
    private static final DecimalFormat BACKUP_VERSION_FORMATER = new DecimalFormat("000000");
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doAction(ActionEvent e) throws IllegalUserActionException {
        JMeterTreeNode[] nodes;
        HashTree subTree = null;
        boolean fullSave = false;
        if (!commands.contains(e.getActionCommand())) {
            throw new IllegalUserActionException("Invalid user command:" + e.getActionCommand());
        }
        if (e.getActionCommand().equals("save_as")) {
            nodes = GuiPackage.getInstance().getTreeListener().getSelectedNodes();
            if (nodes.length > 1) {
                JMeterUtils.reportErrorToUser(JMeterUtils.getResString("save_as_error"), JMeterUtils.getResString("save_as"));
                return;
            }
            subTree = GuiPackage.getInstance().getCurrentSubTree();
        } else if (e.getActionCommand().equals("save_as_test_fragment")) {
            nodes = GuiPackage.getInstance().getTreeListener().getSelectedNodes();
            if (!Save.checkAcceptableForTestFragment(nodes)) {
                JMeterUtils.reportErrorToUser(JMeterUtils.getResString("save_as_test_fragment_error"), JMeterUtils.getResString("save_as_test_fragment"));
                return;
            }
            subTree = GuiPackage.getInstance().getCurrentSubTree();
            TestElement element = GuiPackage.getInstance().createTestElement(TestFragmentControllerGui.class.getName());
            ListedHashTree hashTree = new ListedHashTree();
            HashTree tfTree = hashTree.add((Object)new JMeterTreeNode(element, null));
            for (JMeterTreeNode node : nodes) {
                TreeCloner cloner = new TreeCloner(false);
                GuiPackage.getInstance().getTreeModel().getCurrentSubTree(node).traverse((HashTreeTraverser)cloner);
                tfTree.add((HashTree)cloner.getClonedTree());
            }
            subTree = hashTree;
        } else {
            fullSave = true;
            HashTree testPlan = GuiPackage.getInstance().getTreeModel().getTestPlan();
            if (this.isWorkbenchSaveable()) {
                HashTree workbench = GuiPackage.getInstance().getTreeModel().getWorkBench();
                testPlan.add(workbench);
            }
            subTree = testPlan;
        }
        String updateFile = GuiPackage.getInstance().getTestPlanFile();
        if (!"save".equals(e.getActionCommand()) || updateFile == null) {
            int response;
            File f;
            JFileChooser chooser = FileDialoger.promptToSaveFile(updateFile == null ? GuiPackage.getInstance().getTreeListener().getCurrentNode().getName() + JMX_FILE_EXTENSION : updateFile);
            if (chooser == null) {
                return;
            }
            updateFile = chooser.getSelectedFile().getAbsolutePath();
            if (FilenameUtils.getExtension((String)updateFile).isEmpty()) {
                updateFile = updateFile + JMX_FILE_EXTENSION;
            }
            if ((f = new File(updateFile)).exists() && ((response = JOptionPane.showConfirmDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("save_overwrite_existing_file"), JMeterUtils.getResString("save?"), 0, 3)) == -1 || response == 1)) {
                return;
            }
            if (!e.getActionCommand().equals("save_as")) {
                GuiPackage.getInstance().setTestPlanFile(updateFile);
            }
        }
        List<File> expiredBackupFiles = EMPTY_FILE_LIST;
        File fileToBackup = new File(updateFile);
        try {
            expiredBackupFiles = this.createBackupFile(fileToBackup);
        }
        catch (Exception ex) {
            log.error("Failed to create a backup for " + fileToBackup.getName(), (Throwable)ex);
        }
        try {
            this.convertSubTree(subTree);
        }
        catch (Exception err) {
            log.warn("Error converting subtree " + err);
        }
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(updateFile);
            SaveService.saveTree(subTree, ostream);
            if (fullSave) {
                subTree = GuiPackage.getInstance().getTreeModel().getTestPlan();
                if (this.isWorkbenchSaveable()) {
                    HashTree workbench = GuiPackage.getInstance().getTreeModel().getWorkBench();
                    subTree.add(workbench);
                }
                ActionRouter.getInstance().doActionNow(new ActionEvent(subTree, e.getID(), "sub_tree_saved"));
            }
            for (File expiredBackupFile : expiredBackupFiles) {
                try {
                    FileUtils.deleteQuietly((File)expiredBackupFile);
                }
                catch (Exception ex) {
                    log.warn("Failed to delete backup file " + expiredBackupFile.getName());
                }
            }
        }
        catch (Throwable ex) {
            try {
                log.error("Error saving tree:", ex);
                if (ex instanceof Error) {
                    throw (Error)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new IllegalUserActionException("Couldn't save test plan to file: " + updateFile, ex);
            }
            catch (Throwable throwable) {
                JOrphanUtils.closeQuietly(ostream);
                throw throwable;
            }
        }
        JOrphanUtils.closeQuietly((Closeable)ostream);
        GuiPackage.getInstance().updateCurrentGui();
    }

    private List<File> createBackupFile(File fileToBackup) {
        if (!BACKUP_ENABLED || !fileToBackup.exists()) {
            return EMPTY_FILE_LIST;
        }
        char versionSeparator = '-';
        String baseName = fileToBackup.getName();
        baseName = baseName.endsWith(JMX_FILE_EXTENSION) ? baseName.substring(0, baseName.length() - JMX_FILE_EXTENSION.length()) : baseName;
        File backupDir = new File(BACKUP_DIRECTORY);
        backupDir.mkdirs();
        if (!backupDir.isDirectory()) {
            log.error("Could not backup file ! Backup directory does not exist, is not a directory or could not be created ! <" + backupDir.getAbsolutePath() + ">");
        }
        String backupPatternRegex = Pattern.quote(baseName + versionSeparator) + "([\\d]{6})" + Pattern.quote(JMX_FILE_EXTENSION);
        Pattern backupPattern = Pattern.compile(backupPatternRegex);
        PrivatePatternFileFilter patternFileFilter = new PrivatePatternFileFilter(backupPattern);
        ArrayList<File> backupFiles = new ArrayList<File>(FileUtils.listFiles((File)backupDir, (IOFileFilter)patternFileFilter, null));
        int lastVersionNumber = 0;
        for (File backupFile : backupFiles) {
            Matcher matcher = backupPattern.matcher(backupFile.getName());
            if (!matcher.find() || matcher.groupCount() <= 0) continue;
            int version = Integer.parseInt(matcher.group(1));
            lastVersionNumber = Math.max(lastVersionNumber, version);
        }
        ArrayList<File> expiredFiles = new ArrayList<File>();
        if (BACKUP_MAX_HOURS > 0) {
            Calendar cal = Calendar.getInstance();
            cal.add(11, -BACKUP_MAX_HOURS);
            long expiryDate = cal.getTime().getTime();
            IOFileFilter expiredFileFilter = FileFilterUtils.ageFileFilter((long)expiryDate, (boolean)true);
            expiredFiles.addAll(FileFilterUtils.filterList((IOFileFilter)expiredFileFilter, backupFiles));
        }
        Collections.sort(backupFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                long diff = o1.lastModified() - o2.lastModified();
                return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
            }
        });
        String backupName = baseName + versionSeparator + BACKUP_VERSION_FORMATER.format(lastVersionNumber + 1) + JMX_FILE_EXTENSION;
        File backupFile = new File(backupDir, backupName);
        try {
            FileUtils.copyFile((File)fileToBackup, (File)backupFile);
        }
        catch (IOException e) {
            log.error("Failed to backup file :" + fileToBackup.getAbsolutePath(), (Throwable)e);
            return EMPTY_FILE_LIST;
        }
        backupFiles.add(backupFile);
        if (BACKUP_MAX_COUNT > 0 && backupFiles.size() > BACKUP_MAX_COUNT) {
            expiredFiles.addAll(backupFiles.subList(0, backupFiles.size() - BACKUP_MAX_COUNT));
        }
        return expiredFiles;
    }

    private boolean isWorkbenchSaveable() {
        JMeterTreeNode workbenchNode = (JMeterTreeNode)((JMeterTreeNode)GuiPackage.getInstance().getTreeModel().getRoot()).getChildAt(1);
        return ((WorkBench)workbenchNode.getUserObject()).getSaveWorkBench();
    }

    private static boolean checkAcceptableForTestFragment(JMeterTreeNode[] nodes) {
        for (JMeterTreeNode node : nodes) {
            Object userObject = node.getUserObject();
            if (!(userObject instanceof ThreadGroup) && !(userObject instanceof TestPlan)) continue;
            return false;
        }
        return true;
    }

    void convertSubTree(HashTree tree) {
        for (Object o : new LinkedList(tree.list())) {
            JMeterTreeNode item = (JMeterTreeNode)o;
            this.convertSubTree(tree.getTree((Object)item));
            TestElement testElement = item.getTestElement();
            tree.replaceKey((Object)item, (Object)testElement);
        }
    }

    static {
        commands.add("save_as");
        commands.add("save_as_test_fragment");
        commands.add("save_all_as");
        commands.add("save");
    }

    private static class PrivatePatternFileFilter
    implements IOFileFilter {
        private Pattern pattern;

        public PrivatePatternFileFilter(Pattern pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException("pattern cannot be null !");
            }
            this.pattern = pattern;
        }

        public boolean accept(File dir, String fileName) {
            return this.pattern.matcher(fileName).matches();
        }

        public boolean accept(File file) {
            return this.accept(file.getParentFile(), file.getName());
        }
    }
}

