/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.HeapDumper;
import org.apache.log.Logger;

public class What
extends AbstractAction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Set<String> commandSet;

    @Override
    public void doAction(ActionEvent e) throws IllegalUserActionException {
        JMeterTreeNode node = GuiPackage.getInstance().getTreeListener().getCurrentNode();
        TestElement te = (TestElement)node.getUserObject();
        if ("what_class".equals(e.getActionCommand())) {
            String guiClassName = te.getPropertyAsString("TestElement.gui_class");
            System.out.println(te.getClass().getName());
            System.out.println(guiClassName);
            log.info("TestElement:" + te.getClass().getName() + ", guiClassName:" + guiClassName);
        } else if ("debug_on".equals(e.getActionCommand())) {
            LoggingManager.setPriorityFullName((String)"DEBUG", (String)te.getClass().getName());
        } else if ("debug_off".equals(e.getActionCommand())) {
            LoggingManager.setPriorityFullName((String)"INFO", (String)te.getClass().getName());
        } else if ("heap_dump".equals(e.getActionCommand())) {
            try {
                String s = HeapDumper.dumpHeap();
                JOptionPane.showMessageDialog(null, "Created " + s, "HeapDump", 1);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.toString(), "HeapDump", 0);
            }
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commandSet;
    }

    static {
        HashSet<String> commands = new HashSet<String>();
        commands.add("what_class");
        commands.add("debug_on");
        commands.add("debug_off");
        commands.add("heap_dump");
        commandSet = Collections.unmodifiableSet(commands);
    }
}

