/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.plugin;

import java.net.URL;
import javax.swing.ImageIcon;
import org.apache.jmeter.gui.GUIFactory;
import org.apache.jmeter.plugin.JMeterPlugin;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public final class PluginManager {
    private static final PluginManager instance = new PluginManager();
    private static final Logger log = LoggingManager.getLoggerForClass();

    private PluginManager() {
    }

    public static void install(JMeterPlugin plugin, boolean useGui) {
        if (useGui) {
            instance.installPlugin(plugin);
        }
    }

    private void installPlugin(JMeterPlugin plugin) {
        String[][] icons = plugin.getIconMappings();
        ClassLoader classloader = plugin.getClass().getClassLoader();
        for (String[] icon : icons) {
            URL resource = classloader.getResource(icon[1].trim());
            if (resource == null) {
                log.warn("Can't find icon for " + icon[0] + " - " + icon[1]);
                continue;
            }
            GUIFactory.registerIcon(icon[0], new ImageIcon(resource));
            if (icon.length <= 2 || icon[2] == null) continue;
            URL resource2 = classloader.getResource(icon[2].trim());
            if (resource2 == null) {
                log.info("Can't find disabled icon for " + icon[0] + " - " + icon[2]);
                continue;
            }
            GUIFactory.registerDisabledIcon(icon[0], new ImageIcon(resource2));
        }
    }
}

