/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.core;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.core.SampleException;
import org.apache.jmeter.report.core.SampleMetaDataParser;
import org.apache.jmeter.report.core.SampleMetadata;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.save.CSVSaveService;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class CsvSampleReader
implements Closeable {
    private static final Logger LOG = LoggingManager.getLoggerForClass();
    private static final int BUF_SIZE = 0x100000;
    private static final String CHARSET = SaveService.getFileEncoding(StandardCharsets.UTF_8.displayName());
    private static final char DEFAULT_SEPARATOR = JMeterUtils.getDelimiter(JMeterUtils.getJMeterProperties().getProperty("jmeter.save.saveservice.default_delimiter", ",")).charAt(0);
    private File file;
    private BufferedReader reader;
    private char separator;
    private long row;
    private SampleMetadata metadata;
    private int columnCount;
    private Sample lastSampleRead;

    public CsvSampleReader(File inputFile, char separator, boolean useSaveSampleCfg) {
        this(inputFile, null, separator, useSaveSampleCfg);
    }

    public CsvSampleReader(File inputFile, SampleMetadata metadata) {
        this(inputFile, metadata, DEFAULT_SEPARATOR, false);
    }

    private CsvSampleReader(File inputFile, SampleMetadata metadata, char separator, boolean useSaveSampleCfg) {
        if (!inputFile.isFile() || !inputFile.canRead()) {
            throw new IllegalArgumentException(inputFile.getAbsolutePath() + " does not exist or is not readable");
        }
        this.file = inputFile;
        try {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), CHARSET), 0x100000);
        }
        catch (FileNotFoundException | UnsupportedEncodingException ex) {
            throw new SampleException("Could not create file reader !", ex);
        }
        this.metadata = metadata == null ? this.readMetadata(separator, useSaveSampleCfg) : metadata;
        this.columnCount = this.metadata.getColumnCount();
        this.separator = this.metadata.getSeparator();
        this.row = 0L;
        this.lastSampleRead = this.nextSample();
    }

    private SampleMetadata readMetadata(char separator, boolean useSaveSampleCfg) {
        try {
            SampleMetadata result;
            String line = this.reader.readLine();
            if (line == null) {
                throw new IllegalArgumentException("File is empty");
            }
            if (useSaveSampleCfg && CSVSaveService.getSampleSaveConfiguration(line, this.file.getAbsolutePath()) == null) {
                LOG.warn("File '" + this.file.getAbsolutePath() + "' does not contain the field names header, " + "ensure the jmeter.save.saveservice.* properties are the same as when the CSV file was created or the file may be read incorrectly");
                System.err.println("File '" + this.file.getAbsolutePath() + "' does not contain the field names header, " + "ensure the jmeter.save.saveservice.* properties are the same as when the CSV file was created or the file may be read incorrectly");
                result = new SampleMetadata(SampleSaveConfiguration.staticConfig());
            } else {
                result = new SampleMetaDataParser(separator).parse(line);
            }
            return result;
        }
        catch (Exception e) {
            throw new SampleException("Could not read metadata !", e);
        }
    }

    public SampleMetadata getMetadata() {
        return this.metadata;
    }

    private Sample nextSample() {
        try {
            String[] data = CSVSaveService.csvReadFile(this.reader, this.separator);
            Sample sample = null;
            if (data.length > 0) {
                if (data.length != this.columnCount) {
                    throw new SampleException("Mismatch between expected number of columns:" + this.columnCount + " and columns in CSV file:" + data.length + ", check your jmeter.save.saveservice.* configuration");
                }
                sample = new Sample(this.row, this.metadata, data);
            }
            return sample;
        }
        catch (IOException e) {
            throw new SampleException("Could not read sample <" + this.row + ">", e);
        }
    }

    public Sample readSample() {
        Sample out = this.lastSampleRead;
        this.lastSampleRead = this.nextSample();
        return out;
    }

    public Sample peek() {
        return this.lastSampleRead;
    }

    public boolean hasNext() {
        return this.lastSampleRead != null;
    }

    @Override
    public void close() {
        JOrphanUtils.closeQuietly((Closeable)this.reader);
    }
}

