/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.dashboard;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.jmeter.report.config.ConfigurationException;
import org.apache.jmeter.report.config.ExporterConfiguration;
import org.apache.jmeter.report.config.GraphConfiguration;
import org.apache.jmeter.report.config.InstanceConfiguration;
import org.apache.jmeter.report.config.ReportGeneratorConfiguration;
import org.apache.jmeter.report.core.ControllerSamplePredicate;
import org.apache.jmeter.report.core.ConvertException;
import org.apache.jmeter.report.core.Converters;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.core.SampleException;
import org.apache.jmeter.report.core.SamplePredicate;
import org.apache.jmeter.report.core.SampleSelector;
import org.apache.jmeter.report.core.StringConverter;
import org.apache.jmeter.report.dashboard.DataExporter;
import org.apache.jmeter.report.dashboard.ExportException;
import org.apache.jmeter.report.dashboard.GenerationException;
import org.apache.jmeter.report.processor.AggregateConsumer;
import org.apache.jmeter.report.processor.ApdexSummaryConsumer;
import org.apache.jmeter.report.processor.ApdexThresholdsInfo;
import org.apache.jmeter.report.processor.CsvFileSampleSource;
import org.apache.jmeter.report.processor.ErrorsSummaryConsumer;
import org.apache.jmeter.report.processor.FilterConsumer;
import org.apache.jmeter.report.processor.MaxAggregator;
import org.apache.jmeter.report.processor.MinAggregator;
import org.apache.jmeter.report.processor.NormalizerSampleConsumer;
import org.apache.jmeter.report.processor.RequestsSummaryConsumer;
import org.apache.jmeter.report.processor.SampleConsumer;
import org.apache.jmeter.report.processor.SampleContext;
import org.apache.jmeter.report.processor.StatisticsSummaryConsumer;
import org.apache.jmeter.report.processor.ThresholdSelector;
import org.apache.jmeter.report.processor.Top5ErrorsBySamplerConsumer;
import org.apache.jmeter.report.processor.graph.AbstractGraphConsumer;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ReportGenerator {
    private static final String REPORTGENERATOR_PROPERTIES = "reportgenerator.properties";
    private static final Logger LOG = LoggingManager.getLoggerForClass();
    private static final boolean CSV_OUTPUT_FORMAT = "csv".equalsIgnoreCase(JMeterUtils.getPropDefault("jmeter.save.saveservice.output_format", "csv"));
    private static final char CSV_DEFAULT_SEPARATOR = JMeterUtils.getDelimiter(JMeterUtils.getJMeterProperties().getProperty("jmeter.save.saveservice.default_delimiter", ",")).charAt(0);
    private static final String INVALID_CLASS_FMT = "Class name \"%s\" is not valid.";
    private static final String INVALID_EXPORT_FMT = "Data exporter \"%s\" is unable to export data.";
    private static final String NOT_SUPPORTED_CONVERTION_FMT = "Not supported conversion to \"%s\"";
    public static final String NORMALIZER_CONSUMER_NAME = "normalizer";
    public static final String BEGIN_DATE_CONSUMER_NAME = "beginDate";
    public static final String END_DATE_CONSUMER_NAME = "endDate";
    public static final String NAME_FILTER_CONSUMER_NAME = "nameFilter";
    public static final String DATE_RANGE_FILTER_CONSUMER_NAME = "dateRangeFilter";
    public static final String APDEX_SUMMARY_CONSUMER_NAME = "apdexSummary";
    public static final String ERRORS_SUMMARY_CONSUMER_NAME = "errorsSummary";
    public static final String REQUESTS_SUMMARY_CONSUMER_NAME = "requestsSummary";
    public static final String STATISTICS_SUMMARY_CONSUMER_NAME = "statisticsSummary";
    public static final String TOP5_ERRORS_BY_SAMPLER_CONSUMER_NAME = "top5ErrorsBySampler";
    public static final String START_INTERVAL_CONTROLLER_FILTER_CONSUMER_NAME = "startIntervalControlerFilter";
    private static final Pattern POTENTIAL_CAMEL_CASE_PATTERN = Pattern.compile("_(.)");
    private final File testFile;
    private final ReportGeneratorConfiguration configuration;
    private final ResultCollector resultCollector;

    public ReportGenerator(String resultsFile, ResultCollector resultCollector) throws ConfigurationException {
        if (!CSV_OUTPUT_FORMAT) {
            throw new IllegalArgumentException("Report generation requires csv output format, check 'jmeter.save.saveservice.output_format' property");
        }
        LOG.info("ReportGenerator will use for Parsing the separator:'" + CSV_DEFAULT_SEPARATOR + "'");
        File file = new File(resultsFile);
        if (resultCollector == null) {
            if (!file.isFile() || !file.canRead()) {
                throw new IllegalArgumentException(String.format("Cannot read test results file : %s", file));
            }
            LOG.info("Will only generate report from results file:" + resultsFile);
        } else {
            if (file.exists() && file.length() > 0L) {
                throw new IllegalArgumentException("Results file:" + resultsFile + " is not empty");
            }
            LOG.info("Will generate report at end of test from  results file:" + resultsFile);
        }
        this.resultCollector = resultCollector;
        this.testFile = file;
        Properties merged = new Properties();
        File rgp = new File(JMeterUtils.getJMeterBinDir(), REPORTGENERATOR_PROPERTIES);
        if (LOG.isInfoEnabled()) {
            LOG.info("Reading report generator properties from:" + rgp.getAbsolutePath());
        }
        merged.putAll((Map<?, ?>)ReportGenerator.loadProps(rgp));
        if (LOG.isInfoEnabled()) {
            LOG.info("Merging with JMeter properties");
        }
        merged.putAll((Map<?, ?>)JMeterUtils.getJMeterProperties());
        this.configuration = ReportGeneratorConfiguration.loadFromProperties(merged);
    }

    private static Properties loadProps(File file) {
        Properties props = new Properties();
        try (FileInputStream inStream = new FileInputStream(file);){
            props.load(inStream);
        }
        catch (IOException e) {
            LOG.error("Problem loading properties from file ", (Throwable)e);
            System.err.println("Problem loading properties " + e);
        }
        return props;
    }

    private static String getSetterName(String propertyKey) {
        Matcher matcher = POTENTIAL_CAMEL_CASE_PATTERN.matcher(propertyKey);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public void generate() throws GenerationException {
        if (this.resultCollector != null) {
            LOG.info("Flushing result collector before report Generation");
            this.resultCollector.flushFile();
        }
        LOG.debug("Start report generation");
        File tmpDir = this.configuration.getTempDirectory();
        boolean tmpDirCreated = this.createTempDir(tmpDir);
        SampleContext sampleContext = new SampleContext();
        sampleContext.setWorkingDirectory(tmpDir);
        CsvFileSampleSource source = new CsvFileSampleSource(this.testFile, CSV_DEFAULT_SEPARATOR);
        source.setSampleContext(sampleContext);
        NormalizerSampleConsumer normalizer = new NormalizerSampleConsumer();
        normalizer.setName(NORMALIZER_CONSUMER_NAME);
        FilterConsumer dateRangeConsumer = this.createFilterByDateRange();
        dateRangeConsumer.addSampleConsumer(this.createBeginDateConsumer());
        dateRangeConsumer.addSampleConsumer(this.createEndDateConsumer());
        FilterConsumer nameFilter = this.createNameFilter();
        FilterConsumer excludeControllerFilter = this.createExcludeControllerFilter();
        nameFilter.addSampleConsumer(excludeControllerFilter);
        dateRangeConsumer.addSampleConsumer(nameFilter);
        normalizer.addSampleConsumer(dateRangeConsumer);
        source.addSampleConsumer(normalizer);
        Map<String, GraphConfiguration> graphConfigurations = this.configuration.getGraphConfigurations();
        for (Map.Entry<String, GraphConfiguration> entry : graphConfigurations.entrySet()) {
            this.addGraphConsumer(nameFilter, excludeControllerFilter, entry);
        }
        LOG.debug("Start samples processing");
        try {
            source.run();
        }
        catch (SampleException ex) {
            throw new GenerationException("Error while processing samples:" + ex.getMessage(), ex);
        }
        LOG.debug("End of samples processing");
        LOG.debug("Start data exporting");
        for (Map.Entry<String, InstanceConfiguration> entry : this.configuration.getExportConfigurations().entrySet()) {
            LOG.info("Exporting data using exporter:'" + entry.getKey() + "' of className:'" + ((ExporterConfiguration)entry.getValue()).getClassName() + "'");
            this.exportData(sampleContext, entry.getKey(), (ExporterConfiguration)entry.getValue());
        }
        LOG.debug("End of data exporting");
        this.removeTempDir(tmpDir, tmpDirCreated);
        LOG.debug("End of report generation");
    }

    private FilterConsumer createFilterByDateRange() {
        FilterConsumer dateRangeFilter = new FilterConsumer();
        dateRangeFilter.setName(DATE_RANGE_FILTER_CONSUMER_NAME);
        dateRangeFilter.setSamplePredicate(new SamplePredicate(){

            @Override
            public boolean matches(Sample sample) {
                long sampleStartTime = sample.getStartTime();
                if (ReportGenerator.this.configuration.getStartDate() != null) {
                    if (sampleStartTime >= ReportGenerator.this.configuration.getStartDate().getTime()) {
                        if (ReportGenerator.this.configuration.getEndDate() != null) {
                            return sampleStartTime <= ReportGenerator.this.configuration.getEndDate().getTime();
                        }
                        return true;
                    }
                    return false;
                }
                if (ReportGenerator.this.configuration.getEndDate() != null) {
                    return sampleStartTime <= ReportGenerator.this.configuration.getEndDate().getTime();
                }
                return true;
            }
        });
        return dateRangeFilter;
    }

    private void removeTempDir(File tmpDir, boolean tmpDirCreated) {
        if (tmpDirCreated) {
            try {
                FileUtils.deleteDirectory((File)tmpDir);
            }
            catch (IOException ex) {
                LOG.warn(String.format("Cannot delete created temporary directory \"%s\".", tmpDir), (Throwable)ex);
            }
        }
    }

    private boolean createTempDir(File tmpDir) throws GenerationException {
        boolean tmpDirCreated = false;
        if (!tmpDir.exists() && !(tmpDirCreated = tmpDir.mkdir())) {
            String message = String.format("Cannot create temporary directory \"%s\".", tmpDir);
            LOG.error(message);
            throw new GenerationException(message);
        }
        return tmpDirCreated;
    }

    private void addGraphConsumer(FilterConsumer nameFilter, FilterConsumer excludeControllerFilter, Map.Entry<String, GraphConfiguration> entryGraphCfg) throws GenerationException {
        String graphName = entryGraphCfg.getKey();
        GraphConfiguration graphConfiguration = entryGraphCfg.getValue();
        String className = graphConfiguration.getClassName();
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.newInstance();
            AbstractGraphConsumer graph = (AbstractGraphConsumer)obj;
            graph.setName(graphName);
            graph.setTitle(graphConfiguration.getTitle());
            Method[] methods = clazz.getMethods();
            for (Map.Entry<String, String> entryProperty : graphConfiguration.getProperties().entrySet()) {
                String propertyName = entryProperty.getKey();
                String propertyValue = entryProperty.getValue();
                String setterName = ReportGenerator.getSetterName(propertyName);
                this.setProperty(className, obj, methods, propertyName, propertyValue, setterName);
            }
            FilterConsumer entryPoint = graphConfiguration.excludesControllers() ? excludeControllerFilter : nameFilter;
            entryPoint.addSampleConsumer(graph);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            String error = String.format(INVALID_CLASS_FMT, className);
            LOG.error(error, (Throwable)ex);
            throw new GenerationException(error, ex);
        }
    }

    private void exportData(SampleContext sampleContext, String exporterName, ExporterConfiguration exporterConfiguration) throws GenerationException {
        String className = exporterConfiguration.getClassName();
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.newInstance();
            DataExporter exporter = (DataExporter)obj;
            exporter.setName(exporterName);
            exporter.export(sampleContext, this.testFile, this.configuration);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            String error = String.format(INVALID_CLASS_FMT, className);
            LOG.error(error, (Throwable)ex);
            throw new GenerationException(error, ex);
        }
        catch (ExportException ex) {
            String error = String.format(INVALID_EXPORT_FMT, exporterName);
            LOG.error(error, (Throwable)ex);
            throw new GenerationException(error, ex);
        }
    }

    private ErrorsSummaryConsumer createErrorsSummaryConsumer() {
        ErrorsSummaryConsumer errorsSummaryConsumer = new ErrorsSummaryConsumer();
        errorsSummaryConsumer.setName(ERRORS_SUMMARY_CONSUMER_NAME);
        return errorsSummaryConsumer;
    }

    private FilterConsumer createExcludeControllerFilter() {
        FilterConsumer excludeControllerFilter = new FilterConsumer();
        excludeControllerFilter.setName(START_INTERVAL_CONTROLLER_FILTER_CONSUMER_NAME);
        excludeControllerFilter.setSamplePredicate(new ControllerSamplePredicate());
        excludeControllerFilter.setReverseFilter(true);
        excludeControllerFilter.addSampleConsumer(this.createErrorsSummaryConsumer());
        return excludeControllerFilter;
    }

    private SampleConsumer createTop5ErrorsConsumer(ReportGeneratorConfiguration configuration) {
        Top5ErrorsBySamplerConsumer top5ErrorsBySamplerConsumer = new Top5ErrorsBySamplerConsumer();
        top5ErrorsBySamplerConsumer.setName(TOP5_ERRORS_BY_SAMPLER_CONSUMER_NAME);
        top5ErrorsBySamplerConsumer.setHasOverallResult(true);
        top5ErrorsBySamplerConsumer.setIgnoreTransactionController(configuration.isIgnoreTCFromTop5ErrorsBySampler());
        return top5ErrorsBySamplerConsumer;
    }

    private StatisticsSummaryConsumer createStatisticsSummaryConsumer() {
        StatisticsSummaryConsumer statisticsSummaryConsumer = new StatisticsSummaryConsumer();
        statisticsSummaryConsumer.setName(STATISTICS_SUMMARY_CONSUMER_NAME);
        statisticsSummaryConsumer.setHasOverallResult(true);
        return statisticsSummaryConsumer;
    }

    private RequestsSummaryConsumer createRequestsSummaryConsumer() {
        RequestsSummaryConsumer requestsSummaryConsumer = new RequestsSummaryConsumer();
        requestsSummaryConsumer.setName(REQUESTS_SUMMARY_CONSUMER_NAME);
        return requestsSummaryConsumer;
    }

    private ApdexSummaryConsumer createApdexSummaryConsumer() {
        ApdexSummaryConsumer apdexSummaryConsumer = new ApdexSummaryConsumer();
        apdexSummaryConsumer.setName(APDEX_SUMMARY_CONSUMER_NAME);
        apdexSummaryConsumer.setHasOverallResult(true);
        apdexSummaryConsumer.setThresholdSelector(new ThresholdSelector(){

            @Override
            public ApdexThresholdsInfo select(String sampleName) {
                ApdexThresholdsInfo info = new ApdexThresholdsInfo();
                info.setSatisfiedThreshold(ReportGenerator.this.configuration.getApdexSatisfiedThreshold());
                info.setToleratedThreshold(ReportGenerator.this.configuration.getApdexToleratedThreshold());
                return info;
            }
        });
        return apdexSummaryConsumer;
    }

    private FilterConsumer createNameFilter() {
        FilterConsumer nameFilter = new FilterConsumer();
        nameFilter.setName(NAME_FILTER_CONSUMER_NAME);
        nameFilter.setSamplePredicate(new SamplePredicate(){

            @Override
            public boolean matches(Sample sample) {
                Pattern filteredSamplesPattern = ReportGenerator.this.configuration.getFilteredSamplesPattern();
                return filteredSamplesPattern == null || filteredSamplesPattern.matcher(sample.getName()).matches();
            }
        });
        nameFilter.addSampleConsumer(this.createApdexSummaryConsumer());
        nameFilter.addSampleConsumer(this.createRequestsSummaryConsumer());
        nameFilter.addSampleConsumer(this.createStatisticsSummaryConsumer());
        nameFilter.addSampleConsumer(this.createTop5ErrorsConsumer(this.configuration));
        return nameFilter;
    }

    private AggregateConsumer createEndDateConsumer() {
        AggregateConsumer endDateConsumer = new AggregateConsumer(new MaxAggregator(), new SampleSelector<Double>(){

            @Override
            public Double select(Sample sample) {
                return sample.getEndTime();
            }
        });
        endDateConsumer.setName(END_DATE_CONSUMER_NAME);
        return endDateConsumer;
    }

    private AggregateConsumer createBeginDateConsumer() {
        AggregateConsumer beginDateConsumer = new AggregateConsumer(new MinAggregator(), new SampleSelector<Double>(){

            @Override
            public Double select(Sample sample) {
                return sample.getStartTime();
            }
        });
        beginDateConsumer.setName(BEGIN_DATE_CONSUMER_NAME);
        return beginDateConsumer;
    }

    private void setProperty(String className, Object obj, Method[] methods, String propertyName, String propertyValue, String setterName) throws IllegalAccessException, GenerationException {
        try {
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] parameterTypes;
                Method method = methods[i];
                if (!method.getName().equals(setterName) || (parameterTypes = method.getParameterTypes()).length != 1) continue;
                Class<String> parameterType = parameterTypes[0];
                if (parameterType.isAssignableFrom(String.class)) {
                    method.invoke(obj, propertyValue);
                } else {
                    StringConverter<?> converter = Converters.getConverter(parameterType);
                    if (converter == null) {
                        throw new GenerationException(String.format(NOT_SUPPORTED_CONVERTION_FMT, parameterType.getName()));
                    }
                    method.invoke(obj, converter.convert(propertyValue));
                }
                return;
            }
            LOG.warn(String.format("\"%s\" is not a valid property for class \"%s\", skip it", propertyName, className));
        }
        catch (InvocationTargetException | ConvertException ex) {
            String message = String.format("Cannot assign \"%s\" to property \"%s\" (mapped as \"%s\"), skip it", propertyValue, propertyName, setterName);
            LOG.error(message, (Throwable)ex);
            throw new GenerationException(message, ex);
        }
    }
}

