/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class Top5ErrorsSummaryData {
    private static final Long ONE = new Long(1L);
    private Map<String, Long> countPerError = new HashMap<String, Long>();
    private long total;
    private long errors;

    public void registerError(String errorMessage) {
        Long value = this.countPerError.get(errorMessage);
        if (value == null) {
            this.countPerError.put(errorMessage, ONE);
        } else {
            this.countPerError.put(errorMessage, value + 1L);
        }
    }

    public void incErrors() {
        ++this.errors;
    }

    public void incTotal() {
        ++this.total;
    }

    public long getTotal() {
        return this.total;
    }

    public long getErrors() {
        return this.errors;
    }

    public Object[][] getTop5ErrorsMetrics() {
        TreeSet<Map.Entry<String, Long>> reverseSortedSet = new TreeSet<Map.Entry<String, Long>>(new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> e1, Map.Entry<String, Long> e2) {
                return -e1.getValue().compareTo(e2.getValue());
            }
        });
        reverseSortedSet.addAll(this.countPerError.entrySet());
        Object[][] result = new Object[5][2];
        int size = 0;
        for (Map.Entry entry : reverseSortedSet) {
            if (size == 5) break;
            result[size] = new Object[]{entry.getKey(), entry.getValue()};
            ++size;
        }
        return result;
    }
}

