/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor.graph.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.MapResultData;
import org.apache.jmeter.report.processor.SumAggregatorFactory;
import org.apache.jmeter.report.processor.ValueResultData;
import org.apache.jmeter.report.processor.graph.AbstractGraphConsumer;
import org.apache.jmeter.report.processor.graph.CountValueSelector;
import org.apache.jmeter.report.processor.graph.GraphKeysSelector;
import org.apache.jmeter.report.processor.graph.GroupInfo;
import org.apache.jmeter.report.processor.graph.NameSeriesSelector;

public class ResponseTimeDistributionGraphConsumer
extends AbstractGraphConsumer {
    private long granularity = 1L;

    public final long getGranularity() {
        return this.granularity;
    }

    public final void setGranularity(long granularity) {
        this.granularity = granularity;
    }

    @Override
    protected final GraphKeysSelector createKeysSelector() {
        return new GraphKeysSelector(){

            @Override
            public Double select(Sample sample) {
                long elapsed = sample.getElapsedTime();
                return elapsed - elapsed % ResponseTimeDistributionGraphConsumer.this.granularity;
            }
        };
    }

    @Override
    protected Map<String, GroupInfo> createGroupInfos() {
        HashMap<String, GroupInfo> groupInfos = new HashMap<String, GroupInfo>(1);
        groupInfos.put("Generic group", new GroupInfo(new SumAggregatorFactory(), new NameSeriesSelector(), new CountValueSelector(false), false, false));
        return groupInfos;
    }

    @Override
    protected void initializeExtraResults(MapResultData parentResult) {
        parentResult.setResult("granularity", new ValueResultData(this.granularity));
    }
}

