/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterError;
import org.apache.log.Logger;

public class SampleEvent
implements Serializable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 232L;
    public static final String SAMPLE_VARIABLES = "sample_variables";
    public static final String HOSTNAME;
    private static volatile String[] variableNames;
    private final String[] values;
    private final SampleResult result;
    private final String threadGroup;
    private final String hostname;
    private final boolean isTransactionSampleEvent;

    public static void initSampleVariables() {
        String vars = JMeterUtils.getProperty(SAMPLE_VARIABLES);
        variableNames = vars != null ? vars.split(",") : new String[]{};
        log.info("List of sample_variables: " + Arrays.toString(variableNames));
    }

    public SampleEvent() {
        this(null, null);
    }

    public SampleEvent(SampleResult result, String threadGroup) {
        this(result, threadGroup, HOSTNAME, false);
    }

    public SampleEvent(SampleResult result, String threadGroup, JMeterVariables jmvars) {
        this(result, threadGroup, jmvars, false);
    }

    public SampleEvent(SampleResult result, String threadGroup, String hostname) {
        this(result, threadGroup, hostname, false);
    }

    private SampleEvent(SampleResult result, String threadGroup, String hostname, boolean isTransactionSampleEvent) {
        this.result = result;
        this.threadGroup = threadGroup;
        this.hostname = hostname;
        this.values = new String[variableNames.length];
        this.isTransactionSampleEvent = isTransactionSampleEvent;
    }

    public SampleEvent(SampleResult result, String threadGroup, JMeterVariables jmvars, boolean isTransactionSampleEvent) {
        this(result, threadGroup, HOSTNAME, isTransactionSampleEvent);
        this.saveVars(jmvars);
    }

    private void saveVars(JMeterVariables vars) {
        for (int i = 0; i < variableNames.length; ++i) {
            this.values[i] = vars.get(variableNames[i]);
        }
    }

    public static int getVarCount() {
        return variableNames.length;
    }

    public static String getVarName(int i) {
        return variableNames[i];
    }

    public String getVarValue(int i) {
        try {
            return this.values[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new JMeterError("Check the sample_variable settings!", (Throwable)e);
        }
    }

    public SampleResult getResult() {
        return this.result;
    }

    public String getThreadGroup() {
        return this.threadGroup;
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean isTransactionSampleEvent() {
        return this.isTransactionSampleEvent;
    }

    static {
        variableNames = new String[0];
        HOSTNAME = JMeterUtils.getLocalHostName();
        SampleEvent.initSampleVariables();
    }
}

