/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.CharUtils;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterError;
import org.apache.log.Logger;

public class SampleSaveConfiguration
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String XML = "xml";
    private static final String CSV = "csv";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    public static final String MILLISECONDS = "ms";
    public static final String NONE = "none";
    private static final String FIRST = "first";
    private static final String ALL = "all";
    public static final String ASSERTION_RESULTS_FAILURE_MESSAGE_PROP = "jmeter.save.saveservice.assertion_results_failure_message";
    private static final String ASSERTION_RESULTS_PROP = "jmeter.save.saveservice.assertion_results";
    public static final String DEFAULT_DELIMITER_PROP = "jmeter.save.saveservice.default_delimiter";
    private static final String OUTPUT_FORMAT_PROP = "jmeter.save.saveservice.output_format";
    private static final String PRINT_FIELD_NAMES_PROP = "jmeter.save.saveservice.print_field_names";
    private static final String SAVE_DATA_TYPE_PROP = "jmeter.save.saveservice.data_type";
    private static final String SAVE_LABEL_PROP = "jmeter.save.saveservice.label";
    private static final String SAVE_RESPONSE_CODE_PROP = "jmeter.save.saveservice.response_code";
    private static final String SAVE_RESPONSE_DATA_PROP = "jmeter.save.saveservice.response_data";
    private static final String SAVE_RESPONSE_DATA_ON_ERROR_PROP = "jmeter.save.saveservice.response_data.on_error";
    private static final String SAVE_RESPONSE_MESSAGE_PROP = "jmeter.save.saveservice.response_message";
    private static final String SAVE_SUCCESSFUL_PROP = "jmeter.save.saveservice.successful";
    private static final String SAVE_THREAD_NAME_PROP = "jmeter.save.saveservice.thread_name";
    private static final String SAVE_BYTES_PROP = "jmeter.save.saveservice.bytes";
    private static final String SAVE_SENT_BYTES_PROP = "jmeter.save.saveservice.sent_bytes";
    private static final String SAVE_URL_PROP = "jmeter.save.saveservice.url";
    private static final String SAVE_FILENAME_PROP = "jmeter.save.saveservice.filename";
    private static final String SAVE_HOSTNAME_PROP = "jmeter.save.saveservice.hostname";
    private static final String SAVE_TIME_PROP = "jmeter.save.saveservice.time";
    private static final String TIME_STAMP_FORMAT_PROP = "jmeter.save.saveservice.timestamp_format";
    private static final String SUBRESULTS_PROP = "jmeter.save.saveservice.subresults";
    private static final String ASSERTIONS_PROP = "jmeter.save.saveservice.assertions";
    private static final String LATENCY_PROP = "jmeter.save.saveservice.latency";
    private static final String CONNECT_TIME_PROP = "jmeter.save.saveservice.connect_time";
    private static final String SAMPLERDATA_PROP = "jmeter.save.saveservice.samplerData";
    private static final String RESPONSEHEADERS_PROP = "jmeter.save.saveservice.responseHeaders";
    private static final String REQUESTHEADERS_PROP = "jmeter.save.saveservice.requestHeaders";
    private static final String ENCODING_PROP = "jmeter.save.saveservice.encoding";
    private static final String XML_PI = "jmeter.save.saveservice.xml_pi";
    private static final String SAVE_THREAD_COUNTS = "jmeter.save.saveservice.thread_counts";
    private static final String SAVE_SAMPLE_COUNT = "jmeter.save.saveservice.sample_count";
    private static final String SAVE_IDLE_TIME = "jmeter.save.saveservice.idle_time";
    private boolean time = _time;
    private boolean latency = _latency;
    private boolean connectTime = _connectTime;
    private boolean timestamp = _timestamp;
    private boolean success = _success;
    private boolean label = _label;
    private boolean code = _code;
    private boolean message = _message;
    private boolean threadName = _threadName;
    private boolean dataType = _dataType;
    private boolean encoding = _encoding;
    private boolean assertions = _assertions;
    private boolean subresults = _subresults;
    private boolean responseData = _responseData;
    private boolean samplerData = _samplerData;
    private boolean xml = _xml;
    private boolean fieldNames = _fieldNames;
    private boolean responseHeaders = _responseHeaders;
    private boolean requestHeaders = _requestHeaders;
    private boolean responseDataOnError = _responseDataOnError;
    private boolean saveAssertionResultsFailureMessage = _saveAssertionResultsFailureMessage;
    private boolean url = _url;
    private boolean bytes = _bytes;
    private boolean sentBytes = _sentBytes;
    private boolean fileName = _fileName;
    private boolean hostname = _hostname;
    private boolean threadCounts = _threadCounts;
    private boolean sampleCount = _sampleCount;
    private boolean idleTime = _idleTime;
    private int assertionsResultsToSave = _assertionsResultsToSave;
    private boolean printMilliseconds = _printMilliseconds;
    private transient DateFormat formatter = _formatter;
    private static final boolean _time;
    private static final boolean _timestamp;
    private static final boolean _success;
    private static final boolean _label;
    private static final boolean _code;
    private static final boolean _message;
    private static final boolean _threadName;
    private static final boolean _xml;
    private static final boolean _responseData;
    private static final boolean _dataType;
    private static final boolean _encoding;
    private static final boolean _assertions;
    private static final boolean _latency;
    private static final boolean _connectTime;
    private static final boolean _subresults;
    private static final boolean _samplerData;
    private static final boolean _fieldNames;
    private static final boolean _responseHeaders;
    private static final boolean _requestHeaders;
    private static final boolean _responseDataOnError;
    private static final boolean _saveAssertionResultsFailureMessage;
    private static final String _timeStampFormat;
    private static final int _assertionsResultsToSave;
    public static final int SAVE_NO_ASSERTIONS = 0;
    public static final int SAVE_FIRST_ASSERTION = 1;
    public static final int SAVE_ALL_ASSERTIONS = 2;
    private static final boolean _printMilliseconds;
    private static final boolean _bytes;
    private static final boolean _sentBytes;
    private static final boolean _url;
    private static final boolean _fileName;
    private static final boolean _hostname;
    private static final boolean _threadCounts;
    private static final boolean _sampleCount;
    private static final DateFormat _formatter;
    private static final String _delimiter;
    private static final boolean _idleTime;
    public static final String DEFAULT_DELIMITER = ",";
    private String delimiter = _delimiter;
    private transient int varCount = 0;
    private static final SampleSaveConfiguration _static;
    static final String CONFIG_GETTER_PREFIX = "save";
    static final String CONFIG_SETTER_PREFIX = "set";
    public static final List<String> SAVE_CONFIG_NAMES;

    public int getVarCount() {
        return this.varCount;
    }

    public void setVarCount(int varCount) {
        this.varCount = varCount;
    }

    public static SampleSaveConfiguration staticConfig() {
        return _static;
    }

    public static final String getterName(String configName) {
        return CONFIG_GETTER_PREFIX + configName;
    }

    public static final String setterName(String configName) {
        return CONFIG_SETTER_PREFIX + configName;
    }

    public SampleSaveConfiguration() {
    }

    public SampleSaveConfiguration(boolean value) {
        this.assertions = value;
        this.bytes = value;
        this.code = value;
        this.connectTime = value;
        this.dataType = value;
        this.encoding = value;
        this.fieldNames = value;
        this.fileName = value;
        this.hostname = value;
        this.idleTime = value;
        this.label = value;
        this.latency = value;
        this.message = value;
        this.printMilliseconds = _printMilliseconds;
        this.requestHeaders = value;
        this.responseData = value;
        this.responseDataOnError = value;
        this.responseHeaders = value;
        this.sampleCount = value;
        this.samplerData = value;
        this.saveAssertionResultsFailureMessage = value;
        this.sentBytes = value;
        this.subresults = value;
        this.success = value;
        this.threadCounts = value;
        this.threadName = value;
        this.time = value;
        this.timestamp = value;
        this.url = value;
        this.xml = value;
    }

    private Object readResolve() {
        this.formatter = _formatter;
        return this;
    }

    public Object clone() {
        try {
            SampleSaveConfiguration clone = (SampleSaveConfiguration)super.clone();
            if (this.formatter != null) {
                clone.formatter = (SimpleDateFormat)this.formatter.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SampleSaveConfiguration s = (SampleSaveConfiguration)obj;
        boolean primitiveValues = s.time == this.time && s.latency == this.latency && s.connectTime == this.connectTime && s.timestamp == this.timestamp && s.success == this.success && s.label == this.label && s.code == this.code && s.message == this.message && s.threadName == this.threadName && s.dataType == this.dataType && s.encoding == this.encoding && s.assertions == this.assertions && s.subresults == this.subresults && s.responseData == this.responseData && s.samplerData == this.samplerData && s.xml == this.xml && s.fieldNames == this.fieldNames && s.responseHeaders == this.responseHeaders && s.requestHeaders == this.requestHeaders && s.assertionsResultsToSave == this.assertionsResultsToSave && s.saveAssertionResultsFailureMessage == this.saveAssertionResultsFailureMessage && s.printMilliseconds == this.printMilliseconds && s.responseDataOnError == this.responseDataOnError && s.url == this.url && s.bytes == this.bytes && s.sentBytes == this.sentBytes && s.fileName == this.fileName && s.hostname == this.hostname && s.sampleCount == this.sampleCount && s.idleTime == this.idleTime && s.threadCounts == this.threadCounts;
        boolean stringValues = false;
        if (primitiveValues) {
            stringValues = Objects.equals(this.delimiter, s.delimiter);
        }
        boolean complexValues = false;
        if (primitiveValues && stringValues) {
            complexValues = Objects.equals(this.formatter, s.formatter);
        }
        return primitiveValues && stringValues && complexValues;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.time ? 1 : 0);
        hash = 31 * hash + (this.latency ? 1 : 0);
        hash = 31 * hash + (this.connectTime ? 1 : 0);
        hash = 31 * hash + (this.timestamp ? 1 : 0);
        hash = 31 * hash + (this.success ? 1 : 0);
        hash = 31 * hash + (this.label ? 1 : 0);
        hash = 31 * hash + (this.code ? 1 : 0);
        hash = 31 * hash + (this.message ? 1 : 0);
        hash = 31 * hash + (this.threadName ? 1 : 0);
        hash = 31 * hash + (this.dataType ? 1 : 0);
        hash = 31 * hash + (this.encoding ? 1 : 0);
        hash = 31 * hash + (this.assertions ? 1 : 0);
        hash = 31 * hash + (this.subresults ? 1 : 0);
        hash = 31 * hash + (this.responseData ? 1 : 0);
        hash = 31 * hash + (this.samplerData ? 1 : 0);
        hash = 31 * hash + (this.xml ? 1 : 0);
        hash = 31 * hash + (this.fieldNames ? 1 : 0);
        hash = 31 * hash + (this.responseHeaders ? 1 : 0);
        hash = 31 * hash + (this.requestHeaders ? 1 : 0);
        hash = 31 * hash + this.assertionsResultsToSave;
        hash = 31 * hash + (this.saveAssertionResultsFailureMessage ? 1 : 0);
        hash = 31 * hash + (this.printMilliseconds ? 1 : 0);
        hash = 31 * hash + (this.responseDataOnError ? 1 : 0);
        hash = 31 * hash + (this.url ? 1 : 0);
        hash = 31 * hash + (this.bytes ? 1 : 0);
        hash = 31 * hash + (this.sentBytes ? 1 : 0);
        hash = 31 * hash + (this.fileName ? 1 : 0);
        hash = 31 * hash + (this.hostname ? 1 : 0);
        hash = 31 * hash + (this.threadCounts ? 1 : 0);
        hash = 31 * hash + (this.delimiter != null ? this.delimiter.hashCode() : 0);
        hash = 31 * hash + (this.formatter != null ? this.formatter.hashCode() : 0);
        hash = 31 * hash + (this.sampleCount ? 1 : 0);
        hash = 31 * hash + (this.idleTime ? 1 : 0);
        return hash;
    }

    public boolean saveResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(boolean r) {
        this.responseHeaders = r;
    }

    public boolean saveRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(boolean r) {
        this.requestHeaders = r;
    }

    public boolean saveAssertions() {
        return this.assertions;
    }

    public void setAssertions(boolean assertions) {
        this.assertions = assertions;
    }

    public boolean saveCode() {
        return this.code;
    }

    public void setCode(boolean code) {
        this.code = code;
    }

    public boolean saveDataType() {
        return this.dataType;
    }

    public void setDataType(boolean dataType) {
        this.dataType = dataType;
    }

    public boolean saveEncoding() {
        return this.encoding;
    }

    public void setEncoding(boolean encoding) {
        this.encoding = encoding;
    }

    public boolean saveLabel() {
        return this.label;
    }

    public void setLabel(boolean label) {
        this.label = label;
    }

    public boolean saveLatency() {
        return this.latency;
    }

    public void setLatency(boolean latency) {
        this.latency = latency;
    }

    public boolean saveConnectTime() {
        return this.connectTime;
    }

    public void setConnectTime(boolean connectTime) {
        this.connectTime = connectTime;
    }

    public boolean saveMessage() {
        return this.message;
    }

    public void setMessage(boolean message) {
        this.message = message;
    }

    public boolean saveResponseData(SampleResult res) {
        return this.responseData || TestPlan.getFunctionalMode() || this.responseDataOnError && !res.isSuccessful();
    }

    public boolean saveResponseData() {
        return this.responseData;
    }

    public void setResponseData(boolean responseData) {
        this.responseData = responseData;
    }

    public boolean saveSamplerData(SampleResult res) {
        return this.samplerData || TestPlan.getFunctionalMode() || this.responseDataOnError && !res.isSuccessful();
    }

    public boolean saveSamplerData() {
        return this.samplerData;
    }

    public void setSamplerData(boolean samplerData) {
        this.samplerData = samplerData;
    }

    public boolean saveSubresults() {
        return this.subresults;
    }

    public void setSubresults(boolean subresults) {
        this.subresults = subresults;
    }

    public boolean saveSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean saveThreadName() {
        return this.threadName;
    }

    public void setThreadName(boolean threadName) {
        this.threadName = threadName;
    }

    public boolean saveTime() {
        return this.time;
    }

    public void setTime(boolean time) {
        this.time = time;
    }

    public boolean saveTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(boolean timestamp) {
        this.timestamp = timestamp;
    }

    public boolean saveAsXml() {
        return this.xml;
    }

    public void setAsXml(boolean xml) {
        this.xml = xml;
    }

    public boolean saveFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(boolean printFieldNames) {
        this.fieldNames = printFieldNames;
    }

    public boolean saveUrl() {
        return this.url;
    }

    public void setUrl(boolean save) {
        this.url = save;
    }

    public boolean saveBytes() {
        return this.bytes;
    }

    public void setBytes(boolean save) {
        this.bytes = save;
    }

    public boolean saveSentBytes() {
        return this.sentBytes;
    }

    public void setSentBytes(boolean save) {
        this.sentBytes = save;
    }

    public boolean saveFileName() {
        return this.fileName;
    }

    public void setFileName(boolean save) {
        this.fileName = save;
    }

    public boolean saveAssertionResultsFailureMessage() {
        return this.saveAssertionResultsFailureMessage;
    }

    public void setAssertionResultsFailureMessage(boolean b) {
        this.saveAssertionResultsFailureMessage = b;
    }

    public boolean saveThreadCounts() {
        return this.threadCounts;
    }

    public void setThreadCounts(boolean save) {
        this.threadCounts = save;
    }

    public boolean saveSampleCount() {
        return this.sampleCount;
    }

    public void setSampleCount(boolean save) {
        this.sampleCount = save;
    }

    public void setFormatter(DateFormat fmt) {
        this.printMilliseconds = fmt == null;
        this.formatter = fmt;
    }

    public boolean printMilliseconds() {
        return this.printMilliseconds;
    }

    public DateFormat formatter() {
        return this.formatter;
    }

    public int assertionsResultsToSave() {
        return this.assertionsResultsToSave;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getXmlPi() {
        return JMeterUtils.getJMeterProperties().getProperty(XML_PI, "");
    }

    public void setDelimiter(String delim) {
        this.delimiter = delim;
    }

    public void setDefaultDelimiter() {
        this.delimiter = _delimiter;
    }

    public void setDefaultTimeStampFormat() {
        this.printMilliseconds = _printMilliseconds;
        this.formatter = _formatter;
    }

    public boolean saveHostname() {
        return this.hostname;
    }

    public void setHostname(boolean save) {
        this.hostname = save;
    }

    public boolean saveIdleTime() {
        return this.idleTime;
    }

    public void setIdleTime(boolean save) {
        this.idleTime = save;
    }

    static {
        Properties props = JMeterUtils.getJMeterProperties();
        _subresults = TRUE.equalsIgnoreCase(props.getProperty(SUBRESULTS_PROP, TRUE));
        _assertions = TRUE.equalsIgnoreCase(props.getProperty(ASSERTIONS_PROP, TRUE));
        _latency = TRUE.equalsIgnoreCase(props.getProperty(LATENCY_PROP, TRUE));
        _connectTime = TRUE.equalsIgnoreCase(props.getProperty(CONNECT_TIME_PROP, TRUE));
        _samplerData = TRUE.equalsIgnoreCase(props.getProperty(SAMPLERDATA_PROP, FALSE));
        _responseHeaders = TRUE.equalsIgnoreCase(props.getProperty(RESPONSEHEADERS_PROP, FALSE));
        _requestHeaders = TRUE.equalsIgnoreCase(props.getProperty(REQUESTHEADERS_PROP, FALSE));
        _encoding = TRUE.equalsIgnoreCase(props.getProperty(ENCODING_PROP, FALSE));
        String dlm = JMeterUtils.getDelimiter(props.getProperty(DEFAULT_DELIMITER_PROP, DEFAULT_DELIMITER));
        char ch = dlm.charAt(0);
        if (CharUtils.isAsciiAlphanumeric((char)ch) || ch == '\"') {
            throw new JMeterError("Delimiter '" + ch + "' must not be alphanumeric or " + '\"' + ".");
        }
        if (ch != '\t' && !CharUtils.isAsciiPrintable((char)ch)) {
            throw new JMeterError("Delimiter (code " + ch + ") must be printable.");
        }
        _delimiter = dlm;
        _fieldNames = TRUE.equalsIgnoreCase(props.getProperty(PRINT_FIELD_NAMES_PROP, TRUE));
        _dataType = TRUE.equalsIgnoreCase(props.getProperty(SAVE_DATA_TYPE_PROP, TRUE));
        _label = TRUE.equalsIgnoreCase(props.getProperty(SAVE_LABEL_PROP, TRUE));
        _code = TRUE.equalsIgnoreCase(props.getProperty(SAVE_RESPONSE_CODE_PROP, TRUE));
        _responseData = TRUE.equalsIgnoreCase(props.getProperty(SAVE_RESPONSE_DATA_PROP, FALSE));
        _responseDataOnError = TRUE.equalsIgnoreCase(props.getProperty(SAVE_RESPONSE_DATA_ON_ERROR_PROP, FALSE));
        _message = TRUE.equalsIgnoreCase(props.getProperty(SAVE_RESPONSE_MESSAGE_PROP, TRUE));
        _success = TRUE.equalsIgnoreCase(props.getProperty(SAVE_SUCCESSFUL_PROP, TRUE));
        _threadName = TRUE.equalsIgnoreCase(props.getProperty(SAVE_THREAD_NAME_PROP, TRUE));
        _bytes = TRUE.equalsIgnoreCase(props.getProperty(SAVE_BYTES_PROP, TRUE));
        _sentBytes = TRUE.equalsIgnoreCase(props.getProperty(SAVE_SENT_BYTES_PROP, TRUE));
        _url = TRUE.equalsIgnoreCase(props.getProperty(SAVE_URL_PROP, FALSE));
        _fileName = TRUE.equalsIgnoreCase(props.getProperty(SAVE_FILENAME_PROP, FALSE));
        _hostname = TRUE.equalsIgnoreCase(props.getProperty(SAVE_HOSTNAME_PROP, FALSE));
        _time = TRUE.equalsIgnoreCase(props.getProperty(SAVE_TIME_PROP, TRUE));
        _timeStampFormat = props.getProperty(TIME_STAMP_FORMAT_PROP, MILLISECONDS);
        _printMilliseconds = MILLISECONDS.equalsIgnoreCase(_timeStampFormat);
        _formatter = !_printMilliseconds && !NONE.equalsIgnoreCase(_timeStampFormat) && _timeStampFormat != null ? new SimpleDateFormat(_timeStampFormat) : null;
        _timestamp = !NONE.equalsIgnoreCase(_timeStampFormat);
        _saveAssertionResultsFailureMessage = TRUE.equalsIgnoreCase(props.getProperty(ASSERTION_RESULTS_FAILURE_MESSAGE_PROP, TRUE));
        String whichAssertionResults = props.getProperty(ASSERTION_RESULTS_PROP, NONE);
        _assertionsResultsToSave = NONE.equals(whichAssertionResults) ? 0 : (FIRST.equals(whichAssertionResults) ? 1 : (ALL.equals(whichAssertionResults) ? 2 : 0));
        String howToSave = props.getProperty(OUTPUT_FORMAT_PROP, CSV);
        if (XML.equals(howToSave)) {
            _xml = true;
        } else {
            if (!CSV.equals(howToSave)) {
                log.warn("jmeter.save.saveservice.output_format has unexepected value: '" + howToSave + "' - assuming 'csv' format");
            }
            _xml = false;
        }
        _threadCounts = TRUE.equalsIgnoreCase(props.getProperty(SAVE_THREAD_COUNTS, TRUE));
        _sampleCount = TRUE.equalsIgnoreCase(props.getProperty(SAVE_SAMPLE_COUNT, FALSE));
        _idleTime = TRUE.equalsIgnoreCase(props.getProperty(SAVE_IDLE_TIME, TRUE));
        _static = new SampleSaveConfiguration();
        SAVE_CONFIG_NAMES = Collections.unmodifiableList(Arrays.asList("AsXml", "FieldNames", "Timestamp", "Time", "Label", "Code", "Message", "ThreadName", "DataType", "Success", "AssertionResultsFailureMessage", "Bytes", "SentBytes", "ThreadCounts", "Url", "FileName", "Latency", "ConnectTime", "Encoding", "SampleCount", "Hostname", "IdleTime", "RequestHeaders", "SamplerData", "ResponseHeaders", "ResponseData", "Subresults", "Assertions"));
    }
}

