/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save.converters;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.save.converters.ConversionHelp;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.NameUpdater;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class TestElementConverter
extends AbstractCollectionConverter {
    private static final Logger log = LoggingManager.getLoggerForClass();

    public static String getVersion() {
        return "$Revision: 1733049 $";
    }

    public boolean canConvert(Class arg0) {
        return TestElement.class.isAssignableFrom(arg0);
    }

    public void marshal(Object arg0, HierarchicalStreamWriter writer, MarshallingContext context) {
        TestElement el = (TestElement)arg0;
        ConversionHelp.saveSpecialProperties(el, writer);
        PropertyIterator iter = el.propertyIterator();
        while (iter.hasNext()) {
            JMeterProperty jmp = iter.next();
            if (ConversionHelp.isSpecialProperty(jmp.getName()) || "TestPlan.comments".equals(jmp.getName()) && jmp.getStringValue().length() == 0 && !el.getClass().equals(TestPlan.class)) continue;
            this.writeItem(jmp, context, writer);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String inputName;
        String classAttribute = reader.getAttribute("class");
        Class type = classAttribute == null ? this.mapper().realClass(reader.getNodeName()) : this.mapper().realClass(classAttribute);
        String targetName = inputName = type.getName();
        String guiClassName = SaveService.aliasToClass(reader.getAttribute("guiclass"));
        targetName = NameUpdater.getCurrentTestName(inputName, guiClassName);
        if (!targetName.equals(inputName)) {
            type = this.mapper().realClass(targetName);
        }
        context.put((Object)"TestClassName", (Object)targetName);
        try {
            TestElement el = (TestElement)type.newInstance();
            ConversionHelp.restoreSpecialProperties(el, reader);
            el.setProperty("TestElement.test_class", targetName);
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                JMeterProperty prop = (JMeterProperty)this.readItem(reader, context, el);
                if (prop != null) {
                    el.setProperty(prop);
                }
                reader.moveUp();
            }
            return el;
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("TestElement not instantiable: " + type, (Throwable)e);
            return null;
        }
    }

    public TestElementConverter(Mapper arg0) {
        super(arg0);
    }
}

