/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.TreeCloner;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterStopTestException;
import org.apache.log.Logger;

public class ThreadGroup
extends AbstractThreadGroup {
    private static final long serialVersionUID = 280L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String DATE_FIELD_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private static final long WAIT_TO_DIE = JMeterUtils.getPropDefault("jmeterengine.threadstop.wait", 5000);
    private static final int RAMPUP_GRANULARITY = JMeterUtils.getPropDefault("jmeterthread.rampup.granularity", 1000);
    public static final String RAMP_TIME = "ThreadGroup.ramp_time";
    public static final String DELAYED_START = "ThreadGroup.delayedStart";
    public static final String SCHEDULER = "ThreadGroup.scheduler";
    public static final String START_TIME = "ThreadGroup.start_time";
    public static final String END_TIME = "ThreadGroup.end_time";
    public static final String DURATION = "ThreadGroup.duration";
    public static final String DELAY = "ThreadGroup.delay";
    private transient Thread threadStarter;
    private final Map<JMeterThread, Thread> allThreads = new ConcurrentHashMap<JMeterThread, Thread>();
    private volatile boolean running = false;
    private boolean delayedStartup;

    public void setScheduler(boolean Scheduler) {
        this.setProperty(new BooleanProperty(SCHEDULER, Scheduler));
    }

    public boolean getScheduler() {
        return this.getPropertyAsBoolean(SCHEDULER);
    }

    public void setStartTime(long stime) {
        this.setProperty(new LongProperty(START_TIME, stime));
    }

    public long getStartTime() {
        return this.getPropertyAsLong(START_TIME);
    }

    public long getDuration() {
        return this.getPropertyAsLong(DURATION);
    }

    public void setDuration(long duration) {
        this.setProperty(new LongProperty(DURATION, duration));
    }

    public long getDelay() {
        return this.getPropertyAsLong(DELAY);
    }

    public void setDelay(long delay) {
        this.setProperty(new LongProperty(DELAY, delay));
    }

    public void setEndTime(long etime) {
        this.setProperty(new LongProperty(END_TIME, etime));
    }

    public long getEndTime() {
        return this.getPropertyAsLong(END_TIME);
    }

    public void setRampUp(int rampUp) {
        this.setProperty(new IntegerProperty(RAMP_TIME, rampUp));
    }

    public int getRampUp() {
        return this.getPropertyAsInt(RAMP_TIME);
    }

    private boolean isDelayedStartup() {
        return this.getPropertyAsBoolean(DELAYED_START);
    }

    private void scheduleThread(JMeterThread thread, long now) {
        if (this.getScheduler()) {
            if (this.getDelay() > 0L) {
                thread.setStartTime(this.getDelay() * 1000L + now);
            } else {
                long start = this.getStartTime();
                if (start < now) {
                    start = now;
                }
                thread.setStartTime(start);
            }
            if (this.getDuration() > 0L) {
                thread.setEndTime(this.getDuration() * 1000L + thread.getStartTime());
            } else {
                if (this.getEndTime() <= now) {
                    SimpleDateFormat sdf = new SimpleDateFormat(DATE_FIELD_FORMAT);
                    throw new JMeterStopTestException("End Time (" + sdf.format(new Date(this.getEndTime())) + ") of Scheduler for Thread Group " + this.getName() + " is in the past, fix value of End Time field");
                }
                thread.setEndTime(this.getEndTime());
            }
            thread.setScheduled(true);
        }
    }

    private void delayBy(long delay) {
        if (delay > 0L) {
            long start = System.currentTimeMillis();
            long end = start + delay;
            long now = 0L;
            long pause = RAMPUP_GRANULARITY;
            while (this.running && (now = System.currentTimeMillis()) < end) {
                long togo = end - now;
                if (togo < pause) {
                    pause = togo;
                }
                this.pause(pause);
            }
        }
    }

    @Override
    public void start(int groupCount, ListenerNotifier notifier, ListedHashTree threadGroupTree, StandardJMeterEngine engine) {
        this.running = true;
        int numThreads = this.getNumThreads();
        int rampUpPeriodInSeconds = this.getRampUp();
        float perThreadDelayInMillis = (float)(rampUpPeriodInSeconds * 1000) / (float)this.getNumThreads();
        this.delayedStartup = this.isDelayedStartup();
        log.info("Starting thread group number " + groupCount + " threads " + numThreads + " ramp-up " + rampUpPeriodInSeconds + " perThread " + perThreadDelayInMillis + " delayedStart=" + this.delayedStartup);
        if (this.delayedStartup) {
            this.threadStarter = new Thread((Runnable)new ThreadStarter(groupCount, notifier, threadGroupTree, engine), this.getName() + "-ThreadStarter");
            this.threadStarter.setDaemon(true);
            this.threadStarter.start();
        } else {
            long now = System.currentTimeMillis();
            JMeterContext context = JMeterContextService.getContext();
            for (int i = 0; this.running && i < numThreads; ++i) {
                JMeterThread jmThread = this.makeThread(groupCount, notifier, threadGroupTree, engine, i, context);
                this.scheduleThread(jmThread, now);
                jmThread.setInitialDelay((int)((float)i * perThreadDelayInMillis));
                Thread newThread = new Thread((Runnable)jmThread, jmThread.getThreadName());
                this.registerStartedThread(jmThread, newThread);
                newThread.start();
            }
        }
        log.info("Started thread group number " + groupCount);
    }

    private void registerStartedThread(JMeterThread jMeterThread, Thread newThread) {
        this.allThreads.put(jMeterThread, newThread);
    }

    private JMeterThread makeThread(int groupCount, ListenerNotifier notifier, ListedHashTree threadGroupTree, StandardJMeterEngine engine, int i, JMeterContext context) {
        boolean onErrorStopTest = this.getOnErrorStopTest();
        boolean onErrorStopTestNow = this.getOnErrorStopTestNow();
        boolean onErrorStopThread = this.getOnErrorStopThread();
        boolean onErrorStartNextLoop = this.getOnErrorStartNextLoop();
        String groupName = this.getName();
        JMeterThread jmeterThread = new JMeterThread((HashTree)this.cloneTree(threadGroupTree), this, notifier);
        jmeterThread.setThreadNum(i);
        jmeterThread.setThreadGroup(this);
        jmeterThread.setInitialContext(context);
        String threadName = groupName + " " + groupCount + "-" + (i + 1);
        jmeterThread.setThreadName(threadName);
        jmeterThread.setEngine(engine);
        jmeterThread.setOnErrorStopTest(onErrorStopTest);
        jmeterThread.setOnErrorStopTestNow(onErrorStopTestNow);
        jmeterThread.setOnErrorStopThread(onErrorStopThread);
        jmeterThread.setOnErrorStartNextLoop(onErrorStartNextLoop);
        return jmeterThread;
    }

    @Override
    public boolean stopThread(String threadName, boolean now) {
        for (Map.Entry<JMeterThread, Thread> entry : this.allThreads.entrySet()) {
            JMeterThread thrd = entry.getKey();
            if (!thrd.getThreadName().equals(threadName)) continue;
            this.stopThread(thrd, entry.getValue(), now);
            return true;
        }
        return false;
    }

    private void stopThread(JMeterThread thrd, Thread t, boolean interrupt) {
        thrd.stop();
        thrd.interrupt();
        if (interrupt && t != null) {
            t.interrupt();
        }
    }

    @Override
    public void threadFinished(JMeterThread thread) {
        log.debug("Ending thread " + thread.getThreadName());
        this.allThreads.remove(thread);
    }

    @Override
    public void tellThreadsToStop() {
        this.running = false;
        if (this.delayedStartup) {
            try {
                this.threadStarter.interrupt();
            }
            catch (Exception e) {
                log.warn("Exception occured interrupting ThreadStarter");
            }
        }
        for (Map.Entry<JMeterThread, Thread> entry : this.allThreads.entrySet()) {
            this.stopThread(entry.getKey(), entry.getValue(), true);
        }
    }

    @Override
    public void stop() {
        this.running = false;
        if (this.delayedStartup) {
            try {
                this.threadStarter.interrupt();
            }
            catch (Exception e) {
                log.warn("Exception occured interrupting ThreadStarter");
            }
        }
        for (JMeterThread item : this.allThreads.keySet()) {
            item.stop();
        }
    }

    @Override
    public int numberOfActiveThreads() {
        return this.allThreads.size();
    }

    @Override
    public boolean verifyThreadsStopped() {
        boolean stoppedAll = true;
        if (this.delayedStartup) {
            stoppedAll = this.verifyThreadStopped(this.threadStarter);
        }
        for (Thread t : this.allThreads.values()) {
            stoppedAll = stoppedAll && this.verifyThreadStopped(t);
        }
        return stoppedAll;
    }

    private boolean verifyThreadStopped(Thread thread) {
        boolean stopped = true;
        if (thread != null && thread.isAlive()) {
            try {
                thread.join(WAIT_TO_DIE);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (thread.isAlive()) {
                stopped = false;
                log.warn("Thread won't exit: " + thread.getName());
            }
        }
        return stopped;
    }

    @Override
    public void waitThreadsStopped() {
        if (this.delayedStartup) {
            this.waitThreadStopped(this.threadStarter);
        }
        for (Thread t : this.allThreads.values()) {
            this.waitThreadStopped(t);
        }
    }

    private void waitThreadStopped(Thread thread) {
        if (thread != null) {
            while (thread.isAlive()) {
                try {
                    thread.join(WAIT_TO_DIE);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private ListedHashTree cloneTree(ListedHashTree tree) {
        TreeCloner cloner = new TreeCloner(true);
        tree.traverse((HashTreeTraverser)cloner);
        return cloner.getClonedTree();
    }

    private void pause(long ms) {
        try {
            TimeUnit.MILLISECONDS.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class ThreadStarter
    implements Runnable {
        private final int groupCount;
        private final ListenerNotifier notifier;
        private final ListedHashTree threadGroupTree;
        private final StandardJMeterEngine engine;
        private final JMeterContext context;

        public ThreadStarter(int groupCount, ListenerNotifier notifier, ListedHashTree threadGroupTree, StandardJMeterEngine engine) {
            this.groupCount = groupCount;
            this.notifier = notifier;
            this.threadGroupTree = threadGroupTree;
            this.engine = engine;
            this.context = JMeterContextService.getContext();
        }

        @Override
        public void run() {
            try {
                JMeterContextService.getContext().setVariables(this.context.getVariables());
                long now = System.currentTimeMillis();
                long endtime = 0L;
                boolean usingScheduler = ThreadGroup.this.getScheduler();
                if (usingScheduler) {
                    if (ThreadGroup.this.getDelay() > 0L) {
                        ThreadGroup.this.delayBy(ThreadGroup.this.getDelay() * 1000L);
                    } else {
                        long start = ThreadGroup.this.getStartTime();
                        if (start >= now) {
                            ThreadGroup.this.delayBy(start - now);
                        }
                    }
                    endtime = ThreadGroup.this.getDuration();
                    if (endtime > 0L) {
                        endtime = endtime * 1000L + System.currentTimeMillis();
                    } else {
                        if (ThreadGroup.this.getEndTime() <= now) {
                            SimpleDateFormat sdf = new SimpleDateFormat(ThreadGroup.DATE_FIELD_FORMAT);
                            throw new JMeterStopTestException("End Time (" + sdf.format(new Date(ThreadGroup.this.getEndTime())) + ") of Scheduler for Thread Group " + ThreadGroup.this.getName() + " is in the past, fix value of End Time field");
                        }
                        endtime = ThreadGroup.this.getEndTime();
                    }
                }
                int numThreads = ThreadGroup.this.getNumThreads();
                int perThreadDelayInMillis = Math.round((float)(ThreadGroup.this.getRampUp() * 1000) / (float)numThreads);
                for (int i = 0; ThreadGroup.this.running && i < numThreads; ++i) {
                    if (i > 0) {
                        ThreadGroup.this.pause(perThreadDelayInMillis);
                    }
                    if (!usingScheduler || System.currentTimeMillis() <= endtime) {
                        JMeterThread jmThread = ThreadGroup.this.makeThread(this.groupCount, this.notifier, this.threadGroupTree, this.engine, i, this.context);
                        jmThread.setInitialDelay(0);
                        if (usingScheduler) {
                            jmThread.setScheduled(true);
                            jmThread.setEndTime(endtime);
                        }
                        Thread newThread = new Thread((Runnable)jmThread, jmThread.getThreadName());
                        newThread.setDaemon(false);
                        ThreadGroup.this.registerStartedThread(jmThread, newThread);
                        newThread.start();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                log.error("An error occured scheduling delay start of threads for Thread Group:" + ThreadGroup.this.getName(), (Throwable)ex);
            }
        }
    }
}

