/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Properties;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.commons.io.FileUtils;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.ScriptingTestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public abstract class BSFTestElement
extends ScriptingTestElement
implements Serializable {
    private static final long serialVersionUID = 234L;
    private static final Logger log = LoggingManager.getLoggerForClass();

    protected BSFManager getManager() throws BSFException {
        BSFManager mgr = new BSFManager();
        this.initManager(mgr);
        return mgr;
    }

    protected void initManager(BSFManager mgr) throws BSFException {
        String label = this.getName();
        String fileName = this.getFilename();
        String scriptParameters = this.getParameters();
        Logger logger = LoggingManager.getLoggerForShortName((String)this.getClass().getName());
        mgr.declareBean("log", (Object)logger, Logger.class);
        mgr.declareBean("Label", (Object)label, String.class);
        mgr.declareBean("FileName", (Object)fileName, String.class);
        mgr.declareBean("Parameters", (Object)scriptParameters, String.class);
        String[] args = JOrphanUtils.split((String)scriptParameters, (String)" ");
        mgr.declareBean("args", (Object)args, args.getClass());
        JMeterContext jmctx = JMeterContextService.getContext();
        JMeterVariables vars = jmctx.getVariables();
        Properties props = JMeterUtils.getJMeterProperties();
        mgr.declareBean("ctx", (Object)jmctx, jmctx.getClass());
        mgr.declareBean("vars", (Object)vars, vars.getClass());
        mgr.declareBean("props", (Object)props, props.getClass());
        mgr.declareBean("OUT", (Object)System.out, PrintStream.class);
        Sampler sampler = jmctx.getCurrentSampler();
        mgr.declareBean("sampler", (Object)sampler, Sampler.class);
        SampleResult prev = jmctx.getPreviousResult();
        mgr.declareBean("prev", (Object)prev, SampleResult.class);
    }

    protected void processFileOrScript(BSFManager mgr) throws BSFException {
        BSFEngine bsfEngine = mgr.loadScriptingEngine(this.getScriptLanguage());
        String scriptFile = this.getFilename();
        if (scriptFile.length() == 0) {
            bsfEngine.exec("[script]", 0, 0, (Object)this.getScript());
        } else {
            try {
                String script = FileUtils.readFileToString((File)new File(scriptFile));
                bsfEngine.exec(scriptFile, 0, 0, (Object)script);
            }
            catch (IOException e) {
                log.warn(e.getLocalizedMessage());
                throw new BSFException(10, "Problem reading script file", (Throwable)e);
            }
        }
    }

    protected Object evalFileOrScript(BSFManager mgr) throws BSFException {
        BSFEngine bsfEngine = mgr.loadScriptingEngine(this.getScriptLanguage());
        String scriptFile = this.getFilename();
        if (scriptFile.length() == 0) {
            return bsfEngine.eval("[script]", 0, 0, (Object)this.getScript());
        }
        try {
            String script = FileUtils.readFileToString((File)new File(scriptFile));
            return bsfEngine.eval(scriptFile, 0, 0, (Object)script);
        }
        catch (IOException e) {
            log.warn(e.getLocalizedMessage());
            throw new BSFException(10, "Problem reading script file", (Throwable)e);
        }
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(String s) {
        this.scriptLanguage = s;
    }

    static {
        log.info("Registering JMeter version of JavaScript engine as work-round for BSF-22");
        BSFManager.registerScriptingEngine((String)"javascript", (String)"org.apache.jmeter.util.BSFJavaScriptEngine", (String[])new String[]{"js"});
    }
}

