/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.JsseSSLManager;
import org.apache.jmeter.util.SlowSSLSocket;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HttpSSLProtocolSocketFactory
extends SSLSocketFactory
implements SecureProtocolSocketFactory {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final JsseSSLManager sslManager;
    private final int CPS;
    private static final String protocolList = JMeterUtils.getPropDefault("https.socket.protocols", "");
    private static final String[] protocols;

    public HttpSSLProtocolSocketFactory(JsseSSLManager sslManager) {
        this(sslManager, 0);
    }

    public HttpSSLProtocolSocketFactory(JsseSSLManager sslManager, int cps) {
        this.sslManager = sslManager;
        this.CPS = cps;
    }

    private void setSocket(Socket socket) {
        if (!(socket instanceof SSLSocket)) {
            throw new IllegalArgumentException("Expected SSLSocket");
        }
        SSLSocket sock = (SSLSocket)socket;
        if (protocolList.length() > 0) {
            try {
                sock.setEnabledProtocols(protocols);
            }
            catch (IllegalArgumentException e) {
                log.warn("Could not set protocol list: " + protocolList + ".");
                log.warn("Valid protocols are: " + this.join(sock.getSupportedProtocols()));
            }
        }
    }

    private String join(String[] strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(strings[i]);
        }
        return sb.toString();
    }

    private SSLSocketFactory getSSLSocketFactory() throws IOException {
        try {
            SSLContext sslContext = this.sslManager.getContext();
            return sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException ex) {
            throw new IOException("Rethrown as IOE", ex);
        }
    }

    private Socket wrapSocket(Socket sock) {
        if (this.CPS > 0) {
            return new SlowSSLSocket((SSLSocket)sock, this.CPS);
        }
        return sock;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        Socket socket;
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        if (timeout == 0) {
            socket = sslfac.createSocket(host, port, localAddress, localPort);
        } else {
            socket = sslfac.createSocket();
            InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
            InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
            socket.bind(localaddr);
            socket.connect(remoteaddr, timeout);
        }
        this.setSocket(socket);
        return this.wrapSocket(socket);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket(host, port);
        this.setSocket(sock);
        return this.wrapSocket(sock);
    }

    @Override
    public Socket createSocket() throws IOException, UnknownHostException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket();
        this.setSocket(sock);
        return this.wrapSocket(sock);
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket(socket, host, port, autoClose);
        this.setSocket(sock);
        return this.wrapSocket(sock);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket(host, port, clientHost, clientPort);
        this.setSocket(sock);
        return this.wrapSocket(sock);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket(host, port);
        this.setSocket(sock);
        return this.wrapSocket(sock);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket(address, port, localAddress, localPort);
        this.setSocket(sock);
        return this.wrapSocket(sock);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        try {
            SSLSocketFactory sslfac = this.getSSLSocketFactory();
            return sslfac.getDefaultCipherSuites();
        }
        catch (IOException ex) {
            return new String[0];
        }
    }

    @Override
    public String[] getSupportedCipherSuites() {
        try {
            SSLSocketFactory sslfac = this.getSSLSocketFactory();
            return sslfac.getSupportedCipherSuites();
        }
        catch (IOException ex) {
            return new String[0];
        }
    }

    static {
        if (protocolList.length() > 0) {
            log.info("Using protocol list: " + protocolList);
        }
        protocols = protocolList.split(" ");
    }
}

