/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.ScriptingTestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public abstract class JSR223TestElement
extends ScriptingTestElement
implements Serializable,
TestStateListener {
    private static final long serialVersionUID = 231L;
    private String cacheKey = "";
    private String scriptMd5 = null;
    private static final Map<String, CompiledScript> compiledScriptsCache = Collections.synchronizedMap(new LRUMap(JMeterUtils.getPropDefault("jsr223.compiled_scripts_cache_size", 100)));

    public static ScriptEngineManager getInstance() {
        return LazyHolder.INSTANCE;
    }

    protected ScriptEngine getScriptEngine() throws ScriptException {
        String lang = this.getScriptLanguageWithDefault();
        ScriptEngine scriptEngine = JSR223TestElement.getInstance().getEngineByName(lang);
        if (scriptEngine == null) {
            throw new ScriptException("Cannot find engine named: '" + lang + "', ensure you set language field in JSR223 Test Element: " + this.getName());
        }
        return scriptEngine;
    }

    private String getScriptLanguageWithDefault() {
        String lang = this.getScriptLanguage();
        if (StringUtils.isNotEmpty((CharSequence)lang)) {
            return lang;
        }
        return "groovy";
    }

    protected void populateBindings(Bindings bindings) {
        String label = this.getName();
        String fileName = this.getFilename();
        String scriptParameters = this.getParameters();
        Logger logger = LoggingManager.getLoggerForShortName((String)this.getClass().getName());
        bindings.put("log", (Object)logger);
        bindings.put("Label", (Object)label);
        bindings.put("FileName", (Object)fileName);
        bindings.put("Parameters", (Object)scriptParameters);
        String[] args = JOrphanUtils.split((String)scriptParameters, (String)" ");
        bindings.put("args", (Object)args);
        JMeterContext jmctx = JMeterContextService.getContext();
        bindings.put("ctx", (Object)jmctx);
        JMeterVariables vars = jmctx.getVariables();
        bindings.put("vars", (Object)vars);
        Properties props = JMeterUtils.getJMeterProperties();
        bindings.put("props", (Object)props);
        bindings.put("OUT", (Object)System.out);
        Sampler sampler = jmctx.getCurrentSampler();
        bindings.put("sampler", (Object)sampler);
        SampleResult prev = jmctx.getPreviousResult();
        bindings.put("prev", (Object)prev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object processFileOrScript(ScriptEngine scriptEngine, Bindings bindings) throws IOException, ScriptException {
        boolean supportsCompilable;
        if (bindings == null) {
            bindings = scriptEngine.createBindings();
        }
        this.populateBindings(bindings);
        File scriptFile = new File(this.getFilename());
        boolean bl = supportsCompilable = scriptEngine instanceof Compilable && !scriptEngine.getClass().getName().equals("bsh.engine.BshScriptEngine");
        if (!StringUtils.isEmpty((CharSequence)this.getFilename())) {
            if (scriptFile.exists() && scriptFile.canRead()) {
                BufferedReader fileReader;
                block18: {
                    Object object;
                    fileReader = null;
                    try {
                        if (!supportsCompilable) break block18;
                        String cacheKey = this.getScriptLanguage() + "#" + scriptFile.getAbsolutePath() + "#" + scriptFile.lastModified();
                        CompiledScript compiledScript = compiledScriptsCache.get(cacheKey);
                        if (compiledScript == null) {
                            object = compiledScriptsCache;
                            synchronized (object) {
                                compiledScript = compiledScriptsCache.get(cacheKey);
                                if (compiledScript == null) {
                                    fileReader = new BufferedReader(new FileReader(scriptFile), (int)scriptFile.length());
                                    compiledScript = ((Compilable)((Object)scriptEngine)).compile(fileReader);
                                    compiledScriptsCache.put(cacheKey, compiledScript);
                                }
                            }
                        }
                        object = compiledScript.eval(bindings);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fileReader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)fileReader);
                    return object;
                }
                fileReader = new BufferedReader(new FileReader(scriptFile), (int)scriptFile.length());
                Object object = scriptEngine.eval((Reader)fileReader, bindings);
                IOUtils.closeQuietly((Reader)fileReader);
                return object;
            }
            throw new ScriptException("Script file '" + scriptFile.getAbsolutePath() + "' does not exist or is unreadable for element:" + this.getName());
        }
        if (!StringUtils.isEmpty((CharSequence)this.getScript())) {
            if (supportsCompilable && !StringUtils.isEmpty((CharSequence)this.cacheKey)) {
                this.computeScriptMD5();
                CompiledScript compiledScript = compiledScriptsCache.get(this.scriptMd5);
                if (compiledScript == null) {
                    Map<String, CompiledScript> map = compiledScriptsCache;
                    synchronized (map) {
                        compiledScript = compiledScriptsCache.get(this.scriptMd5);
                        if (compiledScript == null) {
                            compiledScript = ((Compilable)((Object)scriptEngine)).compile(this.getScript());
                            compiledScriptsCache.put(this.scriptMd5, compiledScript);
                        }
                    }
                }
                return compiledScript.eval(bindings);
            }
            return scriptEngine.eval(this.getScript(), bindings);
        }
        throw new ScriptException("Both script file and script text are empty for element:" + this.getName());
    }

    private void computeScriptMD5() {
        if (this.scriptMd5 == null) {
            this.scriptMd5 = DigestUtils.md5Hex((String)this.getScript());
        }
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    @Override
    public void testStarted() {
    }

    @Override
    public void testStarted(String host) {
    }

    @Override
    public void testEnded() {
        this.testEnded("");
    }

    @Override
    public void testEnded(String host) {
        compiledScriptsCache.clear();
        this.scriptMd5 = null;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(String s) {
        this.scriptLanguage = s;
    }

    private static class LazyHolder {
        public static final ScriptEngineManager INSTANCE = new ScriptEngineManager();

        private LazyHolder() {
        }
    }
}

