/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.net.HttpURLConnection;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.jmeter.util.CustomX509TrustManager;
import org.apache.jmeter.util.HttpSSLProtocolSocketFactory;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.SSLManager;
import org.apache.jmeter.util.keystore.JmeterKeyStore;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JsseSSLManager
extends SSLManager {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String HTTPS = "https";
    private static final String DEFAULT_SSL_PROTOCOL = JMeterUtils.getPropDefault("https.default.protocol", "TLS");
    private static final boolean SHARED_SESSION_CONTEXT = JMeterUtils.getPropDefault("https.sessioncontext.shared", false);
    public static final int CPS = JMeterUtils.getPropDefault("httpclient.socket.https.cps", 0);
    private SecureRandom rand;
    private Provider pro = null;
    private SSLContext defaultContext;
    private ThreadLocal<SSLContext> threadlocal;

    public JsseSSLManager(Provider provider) {
        log.debug("ssl Provider =  " + provider);
        this.setProvider(provider);
        if (null == this.rand) {
            this.rand = new SecureRandom();
        }
        try {
            if (SHARED_SESSION_CONTEXT) {
                log.debug("Creating shared context");
                this.defaultContext = this.createContext();
            } else {
                this.threadlocal = new ThreadLocal();
            }
            HttpsURLConnection.setDefaultSSLSocketFactory(new HttpSSLProtocolSocketFactory(this, CPS));
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            Protocol protocol = new Protocol(HTTPS, (ProtocolSocketFactory)new HttpSSLProtocolSocketFactory(this, CPS), 443);
            Protocol.registerProtocol((String)HTTPS, (Protocol)protocol);
            log.debug("SSL stuff all set");
        }
        catch (GeneralSecurityException ex) {
            log.error("Could not set up SSLContext", (Throwable)ex);
        }
        log.debug("JsseSSLManager installed");
    }

    @Override
    public void setContext(HttpURLConnection conn) {
        if (!(conn instanceof HttpsURLConnection)) {
            log.warn("Unexpected HttpURLConnection class: " + conn.getClass().getName());
        }
    }

    @Override
    protected final void setProvider(Provider p) {
        super.setProvider(p);
        if (null == this.pro) {
            this.pro = p;
        }
    }

    public SSLContext getContext() throws GeneralSecurityException {
        if (SHARED_SESSION_CONTEXT) {
            if (log.isDebugEnabled()) {
                log.debug("Using shared SSL context for: " + Thread.currentThread().getName());
            }
            return this.defaultContext;
        }
        SSLContext sslContext = this.threadlocal.get();
        if (sslContext == null) {
            if (log.isDebugEnabled()) {
                log.debug("Creating threadLocal SSL context for: " + Thread.currentThread().getName());
            }
            sslContext = this.createContext();
            this.threadlocal.set(sslContext);
        }
        if (log.isDebugEnabled()) {
            log.debug("Using threadLocal SSL context for: " + Thread.currentThread().getName());
        }
        return sslContext;
    }

    public void resetContext() {
        if (!SHARED_SESSION_CONTEXT) {
            log.debug("Clearing session context for current thread");
            this.threadlocal.set(null);
        }
    }

    private SSLContext createContext() throws GeneralSecurityException {
        SSLContext context = this.pro != null ? SSLContext.getInstance(DEFAULT_SSL_PROTOCOL, this.pro) : SSLContext.getInstance(DEFAULT_SSL_PROTOCOL);
        KeyManagerFactory managerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        JmeterKeyStore keys = this.getKeyStore();
        managerFactory.init(null, this.defaultpw == null ? new char[]{} : this.defaultpw.toCharArray());
        KeyManager[] managers = managerFactory.getKeyManagers();
        KeyManager[] newManagers = new KeyManager[managers.length];
        log.debug(keys.getClass().toString());
        for (int i = 0; i < managers.length; ++i) {
            if (managers[i] instanceof X509KeyManager) {
                X509KeyManager manager = (X509KeyManager)managers[i];
                newManagers[i] = new WrappedX509KeyManager(manager, keys);
                continue;
            }
            newManagers[i] = managers[i];
        }
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmfactory.init(this.getTrustStore());
        TrustManager[] trustmanagers = tmfactory.getTrustManagers();
        for (int i = 0; i < trustmanagers.length; ++i) {
            if (!(trustmanagers[i] instanceof X509TrustManager)) continue;
            trustmanagers[i] = new CustomX509TrustManager((X509TrustManager)trustmanagers[i]);
        }
        context.init(newManagers, trustmanagers, this.rand);
        if (log.isDebugEnabled()) {
            String[] sCiphers;
            String[] dCiphers = context.getSocketFactory().getDefaultCipherSuites();
            int len = dCiphers.length > (sCiphers = context.getSocketFactory().getSupportedCipherSuites()).length ? dCiphers.length : sCiphers.length;
            for (int i = 0; i < len; ++i) {
                if (i < dCiphers.length) {
                    log.debug("Default Cipher: " + dCiphers[i]);
                }
                if (i >= sCiphers.length) continue;
                log.debug("Supported Cipher: " + sCiphers[i]);
            }
        }
        return context;
    }

    static {
        log.info("Using default SSL protocol: " + DEFAULT_SSL_PROTOCOL);
        log.info("SSL session context: " + (SHARED_SESSION_CONTEXT ? "shared" : "per-thread"));
        if (CPS > 0) {
            log.info("Setting up HTTPS SlowProtocol, cps=" + CPS);
        }
    }

    private static class WrappedX509KeyManager
    extends X509ExtendedKeyManager {
        private final X509KeyManager manager;
        private final JmeterKeyStore store;

        public WrappedX509KeyManager(X509KeyManager parent, JmeterKeyStore ks) {
            this.manager = parent;
            this.store = ks;
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            log.debug("WrappedX509Manager: getClientAliases: ");
            return this.store.getClientAliases(keyType, issuers);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            log.debug("WrappedX509Manager: getServerAliases: ");
            return this.manager.getServerAliases(keyType, issuers);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            log.debug("WrappedX509Manager: getCertificateChain(" + alias + ")");
            return this.store.getCertificateChain(alias);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            PrivateKey privateKey = this.store.getPrivateKey(alias);
            log.debug("WrappedX509Manager: getPrivateKey: " + privateKey);
            return privateKey;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            if (log.isDebugEnabled()) {
                log.debug("keyType: " + keyType[0]);
            }
            String alias = this.store.getAlias();
            if (log.isDebugEnabled()) {
                log.debug("Client alias:'" + alias + "'");
            }
            return alias;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.manager.chooseServerAlias(keyType, issuers, socket);
        }
    }
}

