/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util.keystore;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jmeter.threads.JMeterContextService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmeterKeyStore {
    private static final Logger log = LoggerFactory.getLogger(JmeterKeyStore.class);
    public static final String DEFAULT_ALIAS_VAR_NAME = "certAlias";
    private final KeyStore store;
    private final int startIndex;
    private final int endIndex;
    private String clientCertAliasVarName;
    private String[] names = new String[0];
    private Map<String, PrivateKey> privateKeyByAlias = new HashMap<String, PrivateKey>();
    private Map<String, X509Certificate[]> certsByAlias = new HashMap<String, X509Certificate[]>();
    private int lastAliasIndex;
    private static final Map<String, String> EXTENDED_KEY_USAGES = new HashMap<String, String>();
    private static final List<String> SAN_GENERAL_NAMES;

    private JmeterKeyStore(String type, int startIndex, int endIndex, String clientCertAliasVarName) throws KeyStoreException {
        if (startIndex < 0 || endIndex != -1 && endIndex < startIndex) {
            throw new IllegalArgumentException("Invalid index(es). Start=" + startIndex + ", end=" + endIndex);
        }
        this.store = KeyStore.getInstance(type);
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.clientCertAliasVarName = clientCertAliasVarName;
    }

    public void load(InputStream is, String pword) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, UnrecoverableKeyException {
        char[] pw = this.toCharArrayOrNull(pword);
        this.store.load(is, pw);
        ArrayList<String> aliasesList = new ArrayList<String>();
        this.privateKeyByAlias = new HashMap<String, PrivateKey>();
        this.certsByAlias = new HashMap<String, X509Certificate[]>();
        PrivateKey privateKey = null;
        if (log.isDebugEnabled()) {
            this.logDetailsOnKeystore(this.store);
        }
        int index = 0;
        Enumeration<String> aliases = this.store.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!this.store.isKeyEntry(alias)) continue;
            if (this.isIndexInConfiguredRange(index)) {
                privateKey = Objects.requireNonNull((PrivateKey)this.store.getKey(alias, pw), "No key found for alias: " + alias);
                Certificate[] chain = Objects.requireNonNull(this.store.getCertificateChain(alias), "No certificate chain found for alias" + alias);
                aliasesList.add(alias);
                this.privateKeyByAlias.put(alias, privateKey);
                this.certsByAlias.put(alias, this.toX509Certificates(chain));
            }
            ++index;
        }
        if (is != null) {
            Objects.requireNonNull(privateKey, "No key(s) found");
            if (this.endIndex != -1 && index <= this.endIndex - this.startIndex && log.isWarnEnabled()) {
                log.warn("Did not find as much aliases as configured in indexes Start={}, end={}, found={}", new Object[]{this.startIndex, this.endIndex, this.certsByAlias.size()});
            }
        }
        this.names = aliasesList.toArray(new String[aliasesList.size()]);
    }

    private void logDetailsOnKeystore(KeyStore keystore) {
        Enumeration<String> aliases;
        try {
            aliases = keystore.aliases();
        }
        catch (KeyStoreException e) {
            log.debug("Problem reading the aliases from the store {}", (Object)keystore, (Object)e);
            return;
        }
        int i = 1;
        while (aliases.hasMoreElements()) {
            X509Certificate cert;
            String alias = aliases.nextElement();
            log.debug("Certificate at index {} with alias {}", (Object)i++, (Object)alias);
            try {
                cert = (X509Certificate)keystore.getCertificate(alias);
            }
            catch (KeyStoreException e) {
                log.debug("Can't read certificate for alias {}", (Object)alias, (Object)e);
                continue;
            }
            log.debug("Subject DN: {}", (Object)cert.getSubjectX500Principal());
            log.debug("Issuer DN: {}", (Object)cert.getIssuerX500Principal());
            log.debug("Not valid before: {}", (Object)cert.getNotBefore().toInstant());
            log.debug("Not valid after: {}", (Object)cert.getNotAfter().toInstant());
            try {
                Collection<List<?>> subjectAlternativeNames = cert.getSubjectAlternativeNames();
                if (subjectAlternativeNames != null && !subjectAlternativeNames.isEmpty()) {
                    log.debug("SAN: {}", (Object)this.decodeSanList(subjectAlternativeNames));
                }
            }
            catch (CertificateParsingException e) {
                log.debug("Problem parsing SAN for alias {}", (Object)alias, (Object)e);
            }
            try {
                List<String> extendedKeyUsage = cert.getExtendedKeyUsage();
                if (extendedKeyUsage == null) continue;
                for (String keyUsage : extendedKeyUsage) {
                    log.debug("EKU: {} ({})", (Object)EXTENDED_KEY_USAGES.getOrDefault(keyUsage, keyUsage), (Object)keyUsage);
                }
            }
            catch (CertificateParsingException e) {
                log.debug("Can't get EKU for alias {}", (Object)alias, (Object)e);
            }
        }
    }

    private String decodeSanList(Collection<List<?>> subjectAlternativeNames) {
        ArrayList<Pair> decodedEntries = new ArrayList<Pair>();
        for (List<?> entry : subjectAlternativeNames) {
            Object indexData = entry.get(0);
            Object data = entry.get(1);
            if (!(indexData instanceof Integer)) continue;
            Integer generalNameIndex = (Integer)indexData;
            String description = this.sanGeneralNameIndexToName(generalNameIndex);
            String valueString = this.sanDataToString(data);
            decodedEntries.add(Pair.of((Object)description, (Object)valueString));
        }
        return decodedEntries.stream().map(e -> (String)e.getKey() + ": " + (String)e.getValue()).collect(Collectors.joining(", "));
    }

    private String sanDataToString(Object data) {
        if (data instanceof String) {
            return (String)data;
        }
        return Hex.encodeHexString((byte[])((byte[])data));
    }

    private String sanGeneralNameIndexToName(Integer index) {
        String description = index < SAN_GENERAL_NAMES.size() ? SAN_GENERAL_NAMES.get(index) : "UNKNOWN_SAN_GENERAL_NAME";
        return description;
    }

    private X509Certificate[] toX509Certificates(Certificate[] chain) {
        X509Certificate[] x509certs = new X509Certificate[chain.length];
        for (int i = 0; i < x509certs.length; ++i) {
            x509certs[i] = (X509Certificate)chain[i];
        }
        return x509certs;
    }

    private boolean isIndexInConfiguredRange(int index) {
        return index >= this.startIndex && (this.endIndex == -1 || index <= this.endIndex);
    }

    private char[] toCharArrayOrNull(String pword) {
        if (pword == null) {
            return null;
        }
        return pword.toCharArray();
    }

    public X509Certificate[] getCertificateChain(String alias) {
        X509Certificate[] result = this.certsByAlias.get(alias);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("No certificate found for alias:'" + alias + "'");
    }

    public String getAlias() {
        if (StringUtils.isNotEmpty((CharSequence)this.clientCertAliasVarName)) {
            String aliasName = JMeterContextService.getContext().getVariables().get(this.clientCertAliasVarName);
            if (StringUtils.isEmpty((CharSequence)aliasName)) {
                log.error("No var called '{}' found", (Object)this.clientCertAliasVarName);
                throw new IllegalArgumentException("No var called '" + this.clientCertAliasVarName + "' found");
            }
            return aliasName;
        }
        int length = this.names.length;
        if (length == 0) {
            return null;
        }
        return this.names[this.getIndexAndIncrement(length)];
    }

    public int getAliasCount() {
        return this.names.length;
    }

    public String getAlias(int index) {
        int length = this.names.length;
        if (length == 0 && index == 0) {
            return null;
        }
        if (index >= length || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.names[index];
    }

    public PrivateKey getPrivateKey(String alias) {
        PrivateKey pk = this.privateKeyByAlias.get(alias);
        if (pk != null) {
            return pk;
        }
        throw new IllegalArgumentException("No PrivateKey found for alias:'" + alias + "'");
    }

    public static JmeterKeyStore getInstance(String type, int startIndex, int endIndex, String clientCertAliasVarName) throws KeyStoreException {
        return new JmeterKeyStore(type, startIndex, endIndex, clientCertAliasVarName);
    }

    public static JmeterKeyStore getInstance(String type) throws KeyStoreException {
        return JmeterKeyStore.getInstance(type, 0, -1, DEFAULT_ALIAS_VAR_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIndexAndIncrement(int length) {
        JmeterKeyStore jmeterKeyStore = this;
        synchronized (jmeterKeyStore) {
            int result = this.lastAliasIndex++;
            if (this.lastAliasIndex >= length) {
                this.lastAliasIndex = 0;
            }
            return result;
        }
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        int count = this.names.length;
        if (count == 0) {
            return null;
        }
        return Arrays.copyOf(this.names, count);
    }

    static {
        EXTENDED_KEY_USAGES.put("1.3.6.1.4.1.311.10.3.4", "Can use encrypted file systems (EFS) (EFS_CRYPTO)");
        EXTENDED_KEY_USAGES.put("1.3.6.1.4.1.311.10.3.4.1", "Can use encrypted file systems (EFS) (EFS_RECOVERY)");
        EXTENDED_KEY_USAGES.put("1.3.6.1.4.1.311.20.2.2", "Smartcard logon to Microsoft Windows");
        EXTENDED_KEY_USAGES.put("1.3.6.1.5.5.7.3.1", "Transport Layer Security (TLS) World Wide Web (WWW) server authentication");
        EXTENDED_KEY_USAGES.put("1.3.6.1.5.5.7.3.2", "Transport Layer Security (TLS) World Wide Web (WWW) client authentication");
        EXTENDED_KEY_USAGES.put("1.3.6.1.5.5.7.3.3", "Signing of downloadable executable code");
        EXTENDED_KEY_USAGES.put("1.3.6.1.5.5.7.3.4", "Email protection");
        EXTENDED_KEY_USAGES.put("1.3.6.1.5.5.7.3.5", "IP security end system");
        EXTENDED_KEY_USAGES.put("1.3.6.1.5.5.7.3.6", "IP security tunnel termination");
        EXTENDED_KEY_USAGES.put("1.3.6.1.5.5.7.3.7", "IP security user");
        EXTENDED_KEY_USAGES.put("1.3.6.1.5.5.7.3.8", "Time stamping");
        EXTENDED_KEY_USAGES.put("1.3.6.1.5.5.7.3.9", "Signing Online Certificate Status Protocol (OCSP) responses");
        EXTENDED_KEY_USAGES.put("2.5.29.37.0", "Any purpose");
        SAN_GENERAL_NAMES = Arrays.asList("otherName", "rfc822Name", "dNSName", "x400Address", "directoryName", "ediPartyName", "uniformResourceIdentifier", "iPAddress", "registeredID");
    }
}

