/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScript
extends AbstractFunction {
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__javaScript";
    private static final Logger log = LoggingManager.getLoggerForClass();
    private Object[] values;

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterContext jmctx = JMeterContextService.getContext();
        JMeterVariables vars = jmctx.getVariables();
        String script = ((CompoundVariable)this.values[0]).execute();
        String varName = this.values.length < 2 ? null : ((CompoundVariable)this.values[1]).execute().trim();
        String resultStr = "";
        Context cx = Context.enter();
        try {
            Scriptable scope = cx.initStandardObjects(null);
            scope.put("log", scope, (Object)log);
            scope.put("ctx", scope, (Object)jmctx);
            scope.put("vars", scope, (Object)vars);
            scope.put("props", scope, (Object)JMeterUtils.getJMeterProperties());
            scope.put("threadName", scope, (Object)Thread.currentThread().getName());
            scope.put("sampler", scope, (Object)currentSampler);
            scope.put("sampleResult", scope, (Object)previousResult);
            Object result = cx.evaluateString(scope, script, "<cmd>", 1, null);
            resultStr = Context.toString((Object)result);
            if (varName != null && vars != null) {
                vars.put(varName, resultStr);
            }
        }
        catch (RhinoException e) {
            log.error("Error processing Javascript: [" + script + "]\n", (Throwable)e);
            throw new InvalidVariableException("Error processing Javascript: [" + script + "]", (Throwable)e);
        }
        finally {
            Context.exit();
        }
        return resultStr;
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 2);
        this.values = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"javascript_expression"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }
}

