/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import jodd.lagarto.EmptyTagVisitor;
import jodd.lagarto.LagartoException;
import jodd.lagarto.LagartoParser;
import jodd.lagarto.Tag;
import jodd.lagarto.TagVisitor;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.http.parser.HTMLParseException;
import org.apache.jmeter.protocol.http.parser.HTMLParser;
import org.apache.jmeter.protocol.http.parser.HtmlParsingUtils;
import org.apache.jmeter.protocol.http.parser.URLCollection;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class LagartoBasedHtmlParser
extends HTMLParser {
    private static final Logger log = LoggingManager.getLoggerForClass();

    @Override
    public Iterator<URL> getEmbeddedResourceURLs(byte[] html, URL baseUrl, URLCollection coll, String encoding) throws HTMLParseException {
        try {
            String contents = new String(html, encoding);
            LagartoParser lagartoParser = new LagartoParser(contents);
            JMeterTagVisitor tagVisitor = new JMeterTagVisitor(new URLPointer(baseUrl), coll);
            lagartoParser.parse((TagVisitor)tagVisitor);
            return coll.iterator();
        }
        catch (LagartoException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error extracting embedded resource URLs from:'" + baseUrl + "', probably not text content, message:" + e.getMessage());
            }
            return Collections.emptyList().iterator();
        }
        catch (Exception e) {
            throw new HTMLParseException(e);
        }
    }

    @Override
    protected boolean isReusable() {
        return true;
    }

    private static final class JMeterTagVisitor
    extends EmptyTagVisitor {
        private URLCollection urls;
        private URLPointer baseUrl;

        public JMeterTagVisitor(URLPointer baseUrl, URLCollection urls) {
            this.urls = urls;
            this.baseUrl = baseUrl;
        }

        private final void extractAttribute(Tag tag, String attributeName) {
            String url = tag.getAttributeValue(attributeName, false);
            if (!StringUtils.isEmpty((CharSequence)url)) {
                this.urls.addURL(url, this.baseUrl.url);
            }
        }

        public void script(Tag tag, CharSequence body) {
            this.extractAttribute(tag, "src");
        }

        /*
         * Unable to fully structure code
         */
        public void tag(Tag tag) {
            tagName = tag.getName().toLowerCase();
            if (tagName.equals("body")) {
                this.extractAttribute(tag, "background");
            } else if (tagName.equals("base")) {
                baseref = tag.getAttributeValue("href", false);
                try {
                    if (StringUtils.isEmpty((CharSequence)baseref)) ** GOTO lbl45
                    URLPointer.access$002(this.baseUrl, ConversionUtils.makeRelativeURL(URLPointer.access$000(this.baseUrl), baseref));
                }
                catch (MalformedURLException e1) {
                    throw new RuntimeException(e1);
                }
            } else if (tagName.equals("img")) {
                this.extractAttribute(tag, "src");
            } else if (tagName.equals("applet")) {
                this.extractAttribute(tag, "code");
            } else if (tagName.equals("object")) {
                this.extractAttribute(tag, "codebase");
                this.extractAttribute(tag, "data");
            } else if (tagName.equals("input")) {
                if ("image".equalsIgnoreCase(tag.getAttributeValue("type", false))) {
                    this.extractAttribute(tag, "src");
                }
            } else if (tagName.equals("script")) {
                this.extractAttribute(tag, "src");
            } else if (tagName.equals("frame") || tagName.equals("iframe")) {
                this.extractAttribute(tag, "src");
            } else if (tagName.equals("embed")) {
                this.extractAttribute(tag, "src");
            } else if (tagName.equals("bgsound")) {
                this.extractAttribute(tag, "src");
            } else if (tagName.equals("link")) {
                if ("stylesheet".equalsIgnoreCase(tag.getAttributeValue("rel", false))) {
                    this.extractAttribute(tag, "href");
                }
            } else {
                this.extractAttribute(tag, "background");
            }
lbl45:
            // 13 sources

            styleTagStr = tag.getAttributeValue("style", false);
            if (styleTagStr != null) {
                HtmlParsingUtils.extractStyleURLs(URLPointer.access$000(this.baseUrl), this.urls, styleTagStr);
            }
        }
    }

    private static class URLPointer {
        private URL url;

        private URLPointer(URL newUrl) {
            this.url = newUrl;
        }

        static /* synthetic */ URL access$002(URLPointer x0, URL x1) {
            x0.url = x1;
            return x0.url;
        }
    }
}

