/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.jmeter.protocol.http.parser.HTMLParseException;
import org.apache.jmeter.protocol.http.parser.HTMLParser;
import org.apache.jmeter.protocol.http.parser.URLCollection;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;

class RegexpHTMLParser
extends HTMLParser {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String VALUE = "\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))";
    private static final String SEP = "\\s(?:[^>]*\\s)?";
    private static final String REGEXP = "<(?:!--.*?-->|BASE\\s(?:[^>]*\\s)?HREF\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|(?:IMG|SCRIPT|FRAME|IFRAME|BGSOUND)\\s(?:[^>]*\\s)?SRC\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|APPLET\\s(?:[^>]*\\s)?CODE(?:BASE)?\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|(?:EMBED|OBJECT)\\s(?:[^>]*\\s)?(?:SRC|CODEBASE|DATA)\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|(?:BODY|TABLE|TR|TD)\\s(?:[^>]*\\s)?BACKGROUND\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|[^<]+?STYLE\\s*=['\"].*?URL\\(\\s*['\"](.+?)['\"]\\s*\\)|INPUT(?:\\s(?:[^>]*\\s)?(?:SRC\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|TYPE\\s*=\\s*(?:\"image\"|'image'|image(?=[\\s>])))){2,}|LINK(?:\\s(?:[^>]*\\s)?(?:HREF\\s*=\\s*(?:\"([^\"]*)\"|'([^']*)'|([^\"'\\s>\\\\][^\\s>]*)(?=[\\s>]))|REL\\s*=\\s*(?:\"stylesheet\"|'stylesheet'|stylesheet(?=[\\s>])))){2,})";
    private static final int NUM_BASE_GROUPS = 3;
    private static final ThreadLocal<PatternMatcherInput> localInput = new ThreadLocal<PatternMatcherInput>(){

        @Override
        protected PatternMatcherInput initialValue() {
            return new PatternMatcherInput(new char[0]);
        }
    };

    @Override
    protected boolean isReusable() {
        return true;
    }

    protected RegexpHTMLParser() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterator<URL> getEmbeddedResourceURLs(byte[] html, URL baseUrl, URLCollection urls, String encoding) throws HTMLParseException {
        Iterator<URL> iterator;
        Pattern pattern = null;
        Perl5Matcher matcher = null;
        try {
            matcher = JMeterUtils.getMatcher();
            PatternMatcherInput input = localInput.get();
            input.setInput(new String(html, encoding));
            pattern = JMeterUtils.getPatternCache().getPattern(REGEXP, 32785);
            while (matcher.contains(input, pattern)) {
                String s;
                int g;
                MatchResult match = matcher.getMatch();
                if (log.isDebugEnabled()) {
                    log.debug("match groups " + match.groups() + " " + match.toString());
                }
                for (g = 1; g <= 3 && g <= match.groups(); ++g) {
                    s = match.group(g);
                    if (s == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("new baseUrl: " + s + " - " + baseUrl.toString());
                    }
                    try {
                        baseUrl = ConversionUtils.makeRelativeURL(baseUrl, s);
                        continue;
                    }
                    catch (MalformedURLException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Can't build base URL from RL " + s + " in page " + baseUrl, (Throwable)e);
                    }
                }
                for (g = 4; g <= match.groups(); ++g) {
                    s = match.group(g);
                    if (s == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("group " + g + " - " + match.group(g));
                    }
                    urls.addURL(s, baseUrl);
                }
            }
            iterator = urls.iterator();
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new HTMLParseException(e.getMessage(), e);
                catch (MalformedCachePatternException e2) {
                    throw new HTMLParseException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                JMeterUtils.clearMatcherMemory((Perl5Matcher)matcher, pattern);
                throw throwable;
            }
        }
        JMeterUtils.clearMatcherMemory((Perl5Matcher)matcher, (Pattern)pattern);
        return iterator;
    }
}

