/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.BestMatchSpecFactory;
import org.apache.http.impl.cookie.BrowserCompatSpecFactory;
import org.apache.http.impl.cookie.IgnoreSpecFactory;
import org.apache.http.impl.cookie.NetscapeDraftSpecFactory;
import org.apache.http.impl.cookie.RFC2109SpecFactory;
import org.apache.http.impl.cookie.RFC2965SpecFactory;
import org.apache.http.message.BasicHeader;
import org.apache.jmeter.protocol.http.control.Cookie;
import org.apache.jmeter.protocol.http.control.CookieHandler;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HC4CookieHandler
implements CookieHandler {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final transient CookieSpec cookieSpec;
    private static CookieSpecRegistry registry = new CookieSpecRegistry();

    public HC4CookieHandler(String policy) {
        if (policy.equals("default")) {
            policy = "best-match";
        }
        this.cookieSpec = registry.getCookieSpec(policy);
    }

    @Override
    public void addCookieFromHeader(CookieManager cookieManager, boolean checkCookies, String cookieHeader, URL url) {
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            log.debug("Received Cookie: " + cookieHeader + " From: " + url.toExternalForm());
        }
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = HTTPSamplerBase.getDefaultPort(protocol, url.getPort());
        String path = url.getPath();
        boolean isSecure = HTTPSamplerBase.isSecure(protocol);
        List cookies = null;
        CookieOrigin cookieOrigin = new CookieOrigin(host, port, path, isSecure);
        BasicHeader basicHeader = new BasicHeader("set-cookie", cookieHeader);
        try {
            cookies = this.cookieSpec.parse((Header)basicHeader, cookieOrigin);
        }
        catch (MalformedCookieException e) {
            log.error("Unable to add the cookie", (Throwable)e);
        }
        if (cookies == null) {
            return;
        }
        for (org.apache.http.cookie.Cookie cookie : cookies) {
            try {
                if (checkCookies) {
                    this.cookieSpec.validate(cookie, cookieOrigin);
                }
                Date expiryDate = cookie.getExpiryDate();
                long exp = 0L;
                if (expiryDate != null) {
                    exp = expiryDate.getTime();
                }
                Cookie newCookie = new Cookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.isSecure(), exp / 1000L);
                if (exp == 0L || exp >= System.currentTimeMillis()) {
                    newCookie.setVersion(cookie.getVersion());
                    cookieManager.add(newCookie);
                    continue;
                }
                cookieManager.removeMatchingCookies(newCookie);
                if (!debugEnabled) continue;
                log.info("Dropping expired Cookie: " + newCookie.toString());
            }
            catch (MalformedCookieException e) {
                log.warn("Not storing invalid cookie: <" + cookieHeader + "> for URL " + url + " (" + e.getLocalizedMessage() + ")");
            }
            catch (IllegalArgumentException e) {
                log.warn(cookieHeader + e.getLocalizedMessage());
            }
        }
    }

    @Override
    public String getCookieHeaderForURL(CollectionProperty cookiesCP, URL url, boolean allowVariableCookie) {
        List<org.apache.http.cookie.Cookie> c = this.getCookiesForUrl(cookiesCP, url, allowVariableCookie);
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            log.debug("Found " + c.size() + " cookies for " + url.toExternalForm());
        }
        if (c.size() <= 0) {
            return null;
        }
        List lstHdr = this.cookieSpec.formatCookies(c);
        StringBuilder sbHdr = new StringBuilder();
        for (Header header : lstHdr) {
            sbHdr.append(header.getValue());
        }
        return sbHdr.toString();
    }

    List<org.apache.http.cookie.Cookie> getCookiesForUrl(CollectionProperty cookiesCP, URL url, boolean allowVariableCookie) {
        ArrayList<org.apache.http.cookie.Cookie> cookies = new ArrayList<org.apache.http.cookie.Cookie>();
        PropertyIterator iter = cookiesCP.iterator();
        while (iter.hasNext()) {
            Cookie jmcookie = (Cookie)iter.next().getObjectValue();
            if (allowVariableCookie) {
                jmcookie.setRunningVersion(true);
            }
            cookies.add(this.makeCookie(jmcookie));
            if (!allowVariableCookie) continue;
            jmcookie.setRunningVersion(false);
        }
        String host = url.getHost();
        String protocol = url.getProtocol();
        int port = HTTPSamplerBase.getDefaultPort(protocol, url.getPort());
        String path = url.getPath();
        boolean secure = HTTPSamplerBase.isSecure(protocol);
        CookieOrigin cookieOrigin = new CookieOrigin(host, port, path, secure);
        ArrayList<org.apache.http.cookie.Cookie> cookiesValid = new ArrayList<org.apache.http.cookie.Cookie>();
        for (org.apache.http.cookie.Cookie cookie : cookies) {
            if (!this.cookieSpec.match(cookie, cookieOrigin)) continue;
            cookiesValid.add(cookie);
        }
        return cookiesValid;
    }

    private org.apache.http.cookie.Cookie makeCookie(Cookie jmc) {
        long exp = jmc.getExpiresMillis();
        BasicClientCookie ret = new BasicClientCookie(jmc.getName(), jmc.getValue());
        ret.setDomain(jmc.getDomain());
        ret.setPath(jmc.getPath());
        ret.setExpiryDate(exp > 0L ? new Date(exp) : null);
        ret.setSecure(jmc.getSecure());
        ret.setVersion(jmc.getVersion());
        return ret;
    }

    static {
        registry.register("best-match", (CookieSpecFactory)new BestMatchSpecFactory());
        registry.register("compatibility", (CookieSpecFactory)new BrowserCompatSpecFactory());
        registry.register("rfc2109", (CookieSpecFactory)new RFC2109SpecFactory());
        registry.register("rfc2965", (CookieSpecFactory)new RFC2965SpecFactory());
        registry.register("ignoreCookies", (CookieSpecFactory)new IgnoreSpecFactory());
        registry.register("netscape", (CookieSpecFactory)new NetscapeDraftSpecFactory());
    }
}

