/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.Serializable;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jorphan.util.JOrphanUtils;

public class Cookie
extends AbstractTestElement
implements Serializable {
    private static final long serialVersionUID = 240L;
    private static final char TAB = '\t';
    private static final String VALUE = "Cookie.value";
    private static final String DOMAIN = "Cookie.domain";
    private static final String EXPIRES = "Cookie.expires";
    private static final String SECURE = "Cookie.secure";
    private static final String PATH = "Cookie.path";
    private static final String PATH_SPECIFIED = "Cookie.path_specified";
    private static final String DOMAIN_SPECIFIED = "Cookie.domain_specified";
    private static final String VERSION = "Cookie.version";
    private static final int DEFAULT_VERSION = 1;

    public Cookie() {
        this("", "", "", "", false, 0L, false, false);
    }

    public Cookie(String name, String value, String domain, String path, boolean secure, long expires) {
        this(name, value, domain, path, secure, expires, true, true);
    }

    public Cookie(String name, String value, String domain, String path, boolean secure, long expires, boolean hasPath, boolean hasDomain) {
        this(name, value, domain, path, secure, expires, hasPath, hasDomain, 1);
    }

    public Cookie(String name, String value, String domain, String path, boolean secure, long expires, boolean hasPath, boolean hasDomain, int version) {
        this.setName(name);
        this.setValue(value);
        this.setDomain(domain);
        this.setPath(path);
        this.setSecure(secure);
        this.setExpires(expires);
        this.setPathSpecified(hasPath);
        this.setDomainSpecified(hasDomain);
        this.setVersion(version);
    }

    public void addConfigElement(ConfigElement config) {
    }

    public String getValue() {
        return this.getPropertyAsString(VALUE);
    }

    public void setValue(String value) {
        this.setProperty(VALUE, value);
    }

    public String getDomain() {
        return this.getPropertyAsString(DOMAIN);
    }

    public void setDomain(String domain) {
        this.setProperty(DOMAIN, domain);
    }

    public long getExpires() {
        return this.getPropertyAsLong(EXPIRES);
    }

    public long getExpiresMillis() {
        return this.getPropertyAsLong(EXPIRES) * 1000L;
    }

    public void setExpires(long expires) {
        this.setProperty((JMeterProperty)new LongProperty(EXPIRES, expires));
    }

    public boolean getSecure() {
        return this.getPropertyAsBoolean(SECURE);
    }

    public void setSecure(boolean secure) {
        this.setProperty((JMeterProperty)new BooleanProperty(SECURE, secure));
    }

    public String getPath() {
        return this.getPropertyAsString(PATH);
    }

    public void setPath(String path) {
        this.setProperty(PATH, path);
    }

    public void setPathSpecified(boolean b) {
        this.setProperty(PATH_SPECIFIED, b);
    }

    public boolean isPathSpecified() {
        return this.getPropertyAsBoolean(PATH_SPECIFIED);
    }

    public void setDomainSpecified(boolean b) {
        this.setProperty(DOMAIN_SPECIFIED, b);
    }

    public boolean isDomainSpecified() {
        return this.getPropertyAsBoolean(DOMAIN_SPECIFIED);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append(this.getDomain());
        sb.append('\t').append("TRUE");
        sb.append('\t').append(this.getPath());
        sb.append('\t').append(JOrphanUtils.booleanToSTRING((boolean)this.getSecure()));
        sb.append('\t').append(this.getExpires());
        sb.append('\t').append(this.getName());
        sb.append('\t').append(this.getValue());
        return sb.toString();
    }

    public int getVersion() {
        return this.getPropertyAsInt(VERSION, 1);
    }

    public void setVersion(int version) {
        this.setProperty(VERSION, version, 1);
    }
}

