/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util.accesslog;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.protocol.http.util.accesslog.Filter;
import org.apache.jmeter.testelement.TestCloneable;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFilter
implements Filter,
Serializable,
TestCloneable,
ThreadListener {
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    private static final long serialVersionUID = 233L;
    private static final Logger log = LoggerFactory.getLogger(SessionFilter.class);
    private static final boolean USE_JAVA_REGEX = !JMeterUtils.getPropDefault((String)"jmeter.regex.engine", (String)"oro").equalsIgnoreCase("oro");
    private static final Object LOCK = new Object();
    private final Map<String, CookieManager> cookieManagers;
    private final Set<CookieManager> managersInUse;
    private CookieManager lastUsed;

    public SessionFilter() {
        this(new ConcurrentHashMap<String, CookieManager>(), Collections.synchronizedSet(new HashSet()));
    }

    public SessionFilter(Map<String, CookieManager> cookieManagers, Set<CookieManager> managersInUse) {
        this.cookieManagers = cookieManagers;
        this.managersInUse = managersInUse;
    }

    protected boolean hasExcPattern(String text) {
        return false;
    }

    protected String getIpAddress(String logLine) {
        if (USE_JAVA_REGEX) {
            return this.getIpAddressWithJavaRegex(logLine);
        }
        return this.getIpAddressWithOroRegex(logLine);
    }

    private String getIpAddressWithJavaRegex(String logLine) {
        Matcher matcher = IP_PATTERN.matcher(logLine);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return "";
    }

    private String getIpAddressWithOroRegex(String logLine) {
        org.apache.oro.text.regex.Pattern incIp = JMeterUtils.getPatternCache().getPattern("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}", 32784);
        Perl5Matcher matcher = JMeterUtils.getMatcher();
        matcher.contains(logLine, incIp);
        return matcher.getMatch().group(0);
    }

    @Override
    public void reset() {
        this.cookieManagers.clear();
    }

    public Object clone() {
        return new SessionFilter(this.cookieManagers, this.managersInUse);
    }

    @Override
    public void excludeFiles(String[] filenames) {
    }

    @Override
    public void excludePattern(String[] regexp) {
    }

    @Override
    public String filter(String text) {
        return text;
    }

    @Override
    public void includeFiles(String[] filenames) {
    }

    @Override
    public void includePattern(String[] regexp) {
    }

    @Override
    public boolean isFiltered(String path, TestElement sampler) {
        String ipAddr = this.getIpAddress(path);
        CookieManager cm = this.getCookieManager(ipAddr);
        ((HTTPSampler)sampler).setCookieManager(cm);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CookieManager getCookieManager(String ipAddr) {
        CookieManager cm;
        Object object = LOCK;
        synchronized (object) {
            if (this.lastUsed != null) {
                this.managersInUse.remove(this.lastUsed);
                LOCK.notifyAll();
            }
        }
        if (this.lastUsed != null) {
            Thread.yield();
        }
        object = LOCK;
        synchronized (object) {
            cm = this.cookieManagers.get(ipAddr);
            if (cm == null) {
                cm = new CookieManager();
                cm.testStarted();
                this.cookieManagers.put(ipAddr, cm);
            }
            while (this.managersInUse.contains(cm)) {
                try {
                    LOCK.wait();
                }
                catch (InterruptedException e) {
                    log.info("SessionFilter wait interrupted");
                    Thread.currentThread().interrupt();
                }
            }
            this.managersInUse.add(cm);
            this.lastUsed = cm;
        }
        return cm;
    }

    @Override
    public void setReplaceExtension(String oldextension, String newextension) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadFinished() {
        Object object = LOCK;
        synchronized (object) {
            this.managersInUse.remove(this.lastUsed);
            LOCK.notifyAll();
        }
    }

    public void threadStarted() {
    }
}

