/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc.processor;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.jmeter.protocol.jdbc.AbstractJDBCTestElement;
import org.apache.jmeter.protocol.jdbc.config.DataSourceElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public abstract class AbstractJDBCProcessor
extends AbstractJDBCTestElement {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 232L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        Connection conn = null;
        if (JOrphanUtils.isBlank((String)this.getDataSource())) {
            throw new IllegalArgumentException("Variable Name must not be null in " + this.getName());
        }
        try {
            conn = DataSourceElement.getConnection(this.getDataSource());
            this.execute(conn);
        }
        catch (SQLException ex) {
            log.warn("SQL Problem in  " + this.getName() + ": " + ex.toString());
        }
        catch (IOException ex) {
            log.warn("IO Problem in  " + this.getName() + ": " + ex.toString());
        }
        catch (UnsupportedOperationException ex) {
            log.warn("Execution Problem in " + this.getName() + ": " + ex.toString());
        }
        finally {
            AbstractJDBCProcessor.close(conn);
        }
    }
}

