/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.jms.Utils;
import org.apache.jmeter.protocol.jms.sampler.MessageAdmin;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public final class Receiver
implements Runnable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private volatile boolean active;
    private final Session session;
    private final MessageConsumer consumer;
    private final Connection conn;
    private final boolean useResMsgIdAsCorrelId;

    private Receiver(ConnectionFactory factory, Destination receiveQueue, String principal, String credentials, boolean useResMsgIdAsCorrelId, String jmsSelector) throws JMSException {
        if (null != principal && null != credentials) {
            log.info("creating receiver WITH authorisation credentials. UseResMsgId=" + useResMsgIdAsCorrelId);
            this.conn = factory.createConnection(principal, credentials);
        } else {
            log.info("creating receiver without authorisation credentials. UseResMsgId=" + useResMsgIdAsCorrelId);
            this.conn = factory.createConnection();
        }
        this.session = this.conn.createSession(false, 1);
        if (log.isDebugEnabled()) {
            log.debug("Receiver - ctor. Creating consumer with JMS Selector:" + jmsSelector);
        }
        this.consumer = StringUtils.isEmpty((CharSequence)jmsSelector) ? this.session.createConsumer(receiveQueue) : this.session.createConsumer(receiveQueue, jmsSelector);
        this.useResMsgIdAsCorrelId = useResMsgIdAsCorrelId;
        log.debug("Receiver - ctor. Starting connection now");
        this.conn.start();
        log.info("Receiver - ctor. Connection to messaging system established");
    }

    public static Receiver createReceiver(ConnectionFactory factory, Destination receiveQueue, String principal, String credentials, boolean useResMsgIdAsCorrelId, String jmsSelector) throws JMSException {
        Receiver receiver = new Receiver(factory, receiveQueue, principal, credentials, useResMsgIdAsCorrelId, jmsSelector);
        Thread thread = new Thread((Runnable)receiver, Thread.currentThread().getName() + "-JMS-Receiver");
        thread.start();
        return receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.active = true;
        while (this.active) {
            Message reply = null;
            try {
                String messageKey;
                reply = this.consumer.receive(5000L);
                if (reply == null) continue;
                MessageAdmin admin = MessageAdmin.getAdmin();
                if (this.useResMsgIdAsCorrelId) {
                    messageKey = reply.getJMSMessageID();
                    MessageAdmin messageAdmin = admin;
                    synchronized (messageAdmin) {
                        admin.putReply(messageKey, reply);
                        continue;
                    }
                }
                messageKey = reply.getJMSCorrelationID();
                if (messageKey == null) {
                    log.warn("Received message with correlation id null. Discarding message ...");
                    continue;
                }
                admin.putReply(messageKey, reply);
            }
            catch (JMSException e1) {
                log.error("Error handling receive", (Throwable)e1);
            }
        }
        Utils.close(this.consumer, log);
        Utils.close(this.session, log);
        Utils.close(this.conn, log);
    }

    public void deactivate() {
        this.active = false;
    }
}

