/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.protocol.jms.control.gui.JMSPropertiesPanel;
import org.apache.jmeter.protocol.jms.sampler.JMSProperties;
import org.apache.jmeter.protocol.jms.sampler.JMSSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledChoice;
import org.apache.jorphan.gui.JLabeledTextField;

public class JMSSamplerGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = 240L;
    private JLabeledTextField queueConnectionFactory = new JLabeledTextField(JMeterUtils.getResString((String)"jms_queue_connection_factory"));
    private JLabeledTextField sendQueue = new JLabeledTextField(JMeterUtils.getResString((String)"jms_send_queue"));
    private JLabeledTextField receiveQueue = new JLabeledTextField(JMeterUtils.getResString((String)"jms_receive_queue"));
    private JLabeledTextField timeout = new JLabeledTextField(JMeterUtils.getResString((String)"jms_timeout"));
    private JLabeledTextField jmsSelector = new JLabeledTextField(JMeterUtils.getResString((String)"jms_selector"));
    private JSyntaxTextArea messageContent = new JSyntaxTextArea(10, 50);
    private JLabeledTextField initialContextFactory = new JLabeledTextField(JMeterUtils.getResString((String)"jms_initial_context_factory"));
    private JLabeledTextField providerUrl = new JLabeledTextField(JMeterUtils.getResString((String)"jms_provider_url"));
    private String[] labels = new String[]{JMeterUtils.getResString((String)"jms_request"), JMeterUtils.getResString((String)"jms_requestreply")};
    private JLabeledChoice oneWay = new JLabeledChoice(JMeterUtils.getResString((String)"jms_communication_style"), this.labels);
    private JMSPropertiesPanel jmsPropertiesPanel;
    private ArgumentsPanel jndiPropertiesPanel;
    private JCheckBox useNonPersistentDelivery;
    private JCheckBox useReqMsgIdAsCorrelId;
    private JCheckBox useResMsgIdAsCorrelId;

    public JMSSamplerGui() {
        this.init();
    }

    public void clearGui() {
        super.clearGui();
        this.queueConnectionFactory.setText("");
        this.sendQueue.setText("");
        this.receiveQueue.setText("");
        ((JComboBox)this.oneWay.getComponentList().get(1)).setSelectedItem(JMeterUtils.getResString((String)"jms_request"));
        this.timeout.setText("");
        this.jmsSelector.setText("");
        this.messageContent.setInitialText("");
        this.initialContextFactory.setText("");
        this.providerUrl.setText("");
        this.jmsPropertiesPanel.clearGui();
        this.jndiPropertiesPanel.clear();
    }

    public TestElement createTestElement() {
        JMSSampler sampler = new JMSSampler();
        this.configureTestElement((TestElement)sampler);
        this.transfer(sampler);
        return sampler;
    }

    private void transfer(JMSSampler element) {
        element.setQueueConnectionFactory(this.queueConnectionFactory.getText());
        element.setSendQueue(this.sendQueue.getText());
        element.setReceiveQueue(this.receiveQueue.getText());
        boolean isOneway = this.oneWay.getText().equals(JMeterUtils.getResString((String)"jms_request"));
        element.setIsOneway(isOneway);
        element.setNonPersistent(this.useNonPersistentDelivery.isSelected());
        element.setUseReqMsgIdAsCorrelId(this.useReqMsgIdAsCorrelId.isSelected());
        element.setUseResMsgIdAsCorrelId(this.useResMsgIdAsCorrelId.isSelected());
        element.setTimeout(this.timeout.getText());
        element.setJMSSelector(this.jmsSelector.getText());
        element.setContent(this.messageContent.getText());
        element.setInitialContextFactory(this.initialContextFactory.getText());
        element.setContextProvider(this.providerUrl.getText());
        Arguments jndiArgs = (Arguments)this.jndiPropertiesPanel.createTestElement();
        element.setJNDIProperties(jndiArgs);
        JMSProperties args = (JMSProperties)this.jmsPropertiesPanel.createTestElement();
        element.setJMSProperties(args);
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        if (!(element instanceof JMSSampler)) {
            return;
        }
        JMSSampler sampler = (JMSSampler)element;
        this.transfer(sampler);
    }

    public void configure(TestElement el) {
        super.configure(el);
        if (!(el instanceof JMSSampler)) {
            return;
        }
        JMSSampler sampler = (JMSSampler)el;
        this.queueConnectionFactory.setText(sampler.getQueueConnectionFactory());
        this.sendQueue.setText(sampler.getSendQueue());
        this.receiveQueue.setText(sampler.getReceiveQueue());
        JComboBox box = (JComboBox)this.oneWay.getComponentList().get(1);
        String selected = null;
        selected = sampler.isOneway() ? JMeterUtils.getResString((String)"jms_request") : JMeterUtils.getResString((String)"jms_requestreply");
        box.setSelectedItem(selected);
        this.useNonPersistentDelivery.setSelected(sampler.isNonPersistent());
        this.useReqMsgIdAsCorrelId.setSelected(sampler.isUseReqMsgIdAsCorrelId());
        this.useResMsgIdAsCorrelId.setSelected(sampler.isUseResMsgIdAsCorrelId());
        this.timeout.setText(sampler.getTimeout());
        this.jmsSelector.setText(sampler.getJMSSelector());
        this.messageContent.setInitialText(sampler.getContent());
        this.initialContextFactory.setText(sampler.getInitialContextFactory());
        this.providerUrl.setText(sampler.getContextProvider());
        this.jmsPropertiesPanel.configure((TestElement)sampler.getJMSProperties());
        this.jndiPropertiesPanel.configure((TestElement)sampler.getJNDIProperties());
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel jmsQueueingPanel = new JPanel(new BorderLayout());
        jmsQueueingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"jms_queueing")));
        JPanel qcfPanel = new JPanel(new BorderLayout(5, 0));
        qcfPanel.add((Component)this.queueConnectionFactory, "Center");
        jmsQueueingPanel.add((Component)qcfPanel, "North");
        JPanel sendQueuePanel = new JPanel(new BorderLayout(5, 0));
        sendQueuePanel.add((Component)this.sendQueue);
        jmsQueueingPanel.add((Component)sendQueuePanel, "Center");
        JPanel receiveQueuePanel = new JPanel(new BorderLayout(5, 0));
        receiveQueuePanel.add((Component)this.jmsSelector, "South");
        receiveQueuePanel.add((Component)this.receiveQueue, "North");
        jmsQueueingPanel.add((Component)receiveQueuePanel, "South");
        JPanel messagePanel = new JPanel(new BorderLayout());
        messagePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"jms_message_title")));
        HorizontalPanel correlationPanel = new HorizontalPanel();
        correlationPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"jms_correlation_title")));
        this.useReqMsgIdAsCorrelId = new JCheckBox(JMeterUtils.getResString((String)"jms_use_req_msgid_as_correlid"), false);
        this.useResMsgIdAsCorrelId = new JCheckBox(JMeterUtils.getResString((String)"jms_use_res_msgid_as_correlid"), false);
        correlationPanel.add(this.useReqMsgIdAsCorrelId);
        correlationPanel.add(this.useResMsgIdAsCorrelId);
        JPanel messageNorthPanel = new JPanel(new BorderLayout());
        HorizontalPanel onewayPanel = new HorizontalPanel();
        onewayPanel.add((Component)this.oneWay);
        onewayPanel.add((Component)correlationPanel);
        messageNorthPanel.add((Component)onewayPanel, "North");
        this.useNonPersistentDelivery = new JCheckBox(JMeterUtils.getResString((String)"jms_use_non_persistent_delivery"), false);
        HorizontalPanel timeoutPanel = new HorizontalPanel();
        timeoutPanel.add((Component)this.timeout);
        timeoutPanel.add(this.useNonPersistentDelivery);
        messageNorthPanel.add((Component)timeoutPanel, "South");
        messagePanel.add((Component)messageNorthPanel, "North");
        JPanel messageContentPanel = new JPanel(new BorderLayout());
        messageContentPanel.add((Component)new JLabel(JMeterUtils.getResString((String)"jms_msg_content")), "North");
        messageContentPanel.add((Component)new JTextScrollPane(this.messageContent), "Center");
        Dimension pref = new Dimension(400, 150);
        this.messageContent.setPreferredSize(pref);
        messagePanel.add((Component)messageContentPanel, "Center");
        this.jmsPropertiesPanel = new JMSPropertiesPanel();
        messagePanel.add((Component)this.jmsPropertiesPanel, "South");
        Box mainPanel = Box.createVerticalBox();
        this.add(mainPanel, "Center");
        mainPanel.add((Component)jmsQueueingPanel, "North");
        mainPanel.add((Component)messagePanel, "Center");
        JPanel jndiPanel = this.createJNDIPanel();
        mainPanel.add((Component)jndiPanel, "South");
    }

    private JPanel createJNDIPanel() {
        JPanel jndiPanel = new JPanel(new BorderLayout());
        jndiPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"jms_jndi_props")));
        JPanel contextPanel = new JPanel(new BorderLayout(10, 0));
        contextPanel.add((Component)this.initialContextFactory);
        jndiPanel.add((Component)contextPanel, "North");
        JPanel providerPanel = new JPanel(new BorderLayout(10, 0));
        providerPanel.add((Component)this.providerUrl);
        jndiPanel.add((Component)providerPanel, "South");
        this.jndiPropertiesPanel = new ArgumentsPanel(JMeterUtils.getResString((String)"jms_jndi_props"));
        jndiPanel.add((Component)this.jndiPropertiesPanel);
        return jndiPanel;
    }

    public String getLabelResource() {
        return "jms_point_to_point";
    }
}

