/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.jms.Utils;
import org.apache.jmeter.protocol.jms.sampler.FixedQueueExecutor;
import org.apache.jmeter.protocol.jms.sampler.JMSProperties;
import org.apache.jmeter.protocol.jms.sampler.QueueExecutor;
import org.apache.jmeter.protocol.jms.sampler.Receiver;
import org.apache.jmeter.protocol.jms.sampler.TemporaryQueueExecutor;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JMSSampler
extends AbstractSampler
implements ThreadListener {
    private static final Logger LOGGER = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 233L;
    private static final int DEFAULT_TIMEOUT = 2000;
    private static final String DEFAULT_TIMEOUT_STRING = Integer.toString(2000);
    private static final String JNDI_INITIAL_CONTEXT_FACTORY = "JMSSampler.initialContextFactory";
    private static final String JNDI_CONTEXT_PROVIDER_URL = "JMSSampler.contextProviderUrl";
    private static final String JNDI_PROPERTIES = "JMSSampler.jndiProperties";
    private static final String TIMEOUT = "JMSSampler.timeout";
    private static final String JMS_SELECTOR = "JMSSampler.jmsSelector";
    private static final String JMS_SELECTOR_DEFAULT = "";
    private static final String IS_ONE_WAY = "JMSSampler.isFireAndForget";
    private static final String JMS_PROPERTIES = "arguments";
    private static final String RECEIVE_QUEUE = "JMSSampler.ReceiveQueue";
    private static final String XML_DATA = "HTTPSamper.xml_data";
    private static final String SEND_QUEUE = "JMSSampler.SendQueue";
    private static final String QUEUE_CONNECTION_FACTORY_JNDI = "JMSSampler.queueconnectionfactory";
    private static final String IS_NON_PERSISTENT = "JMSSampler.isNonPersistent";
    private static final String USE_REQ_MSGID_AS_CORRELID = "JMSSampler.useReqMsgIdAsCorrelId";
    private static final String USE_RES_MSGID_AS_CORRELID = "JMSSampler.useResMsgIdAsCorrelId";
    private static final boolean USE_RES_MSGID_AS_CORRELID_DEFAULT = false;
    private static final boolean USE_SECURITY_PROPERTIES = JMeterUtils.getPropDefault((String)"JMSSampler.useSecurity.properties", (boolean)true);
    private transient Queue receiveQueue;
    private transient QueueSession session;
    private transient QueueConnection connection;
    private transient QueueExecutor executor;
    private transient QueueSender producer;
    private transient Receiver receiverThread = null;
    private transient Throwable thrown = null;

    public SampleResult sample(Entry entry) {
        SampleResult res = new SampleResult();
        res.setSampleLabel(this.getName());
        res.setSamplerData(this.getContent());
        res.setSuccessful(false);
        res.setDataType("text");
        res.sampleStart();
        try {
            TextMessage msg = this.createMessage();
            if (this.isOneway()) {
                this.producer.send((Message)msg);
                res.setRequestHeaders(Utils.messageProperties((Message)msg));
                res.setResponseOK();
                res.setResponseData("Oneway request has no response data", null);
            } else {
                if (!this.useTemporyQueue()) {
                    msg.setJMSReplyTo((Destination)this.receiveQueue);
                }
                Message replyMsg = this.executor.sendAndReceive((Message)msg);
                res.setRequestHeaders(Utils.messageProperties((Message)msg));
                if (replyMsg == null) {
                    res.setResponseMessage("No reply message received");
                } else {
                    if (replyMsg instanceof TextMessage) {
                        res.setResponseData(((TextMessage)replyMsg).getText(), null);
                    } else {
                        res.setResponseData(replyMsg.toString(), null);
                    }
                    res.setResponseHeaders(Utils.messageProperties(replyMsg));
                    res.setResponseOK();
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getLocalizedMessage(), (Throwable)e);
            if (this.thrown != null) {
                res.setResponseMessage(this.thrown.toString());
            }
            res.setResponseMessage(e.getLocalizedMessage());
        }
        res.sampleEnd();
        return res;
    }

    private TextMessage createMessage() throws JMSException {
        if (this.session == null) {
            throw new IllegalStateException("Session may not be null while creating message");
        }
        TextMessage msg = this.session.createTextMessage();
        msg.setText(this.getContent());
        this.addJMSProperties(msg);
        return msg;
    }

    private void addJMSProperties(TextMessage msg) throws JMSException {
        Utils.addJMSProperties((Message)msg, this.getJMSProperties().getJmsPropertysAsMap());
    }

    public JMSProperties getJMSProperties() {
        Object o = this.getProperty(JMS_PROPERTIES).getObjectValue();
        JMSProperties jmsProperties = null;
        jmsProperties = o instanceof Arguments ? Utils.convertArgumentsToJmsProperties((Arguments)o) : (JMSProperties)o;
        if (jmsProperties == null) {
            jmsProperties = new JMSProperties();
            this.setJMSProperties(jmsProperties);
        }
        return jmsProperties;
    }

    public void setJMSProperties(JMSProperties jmsProperties) {
        this.setProperty((JMeterProperty)new TestElementProperty(JMS_PROPERTIES, (TestElement)jmsProperties));
    }

    public Arguments getJNDIProperties() {
        return this.getArguments(JNDI_PROPERTIES);
    }

    public void setJNDIProperties(Arguments args) {
        this.setProperty((JMeterProperty)new TestElementProperty(JNDI_PROPERTIES, (TestElement)args));
    }

    public String getQueueConnectionFactory() {
        return this.getPropertyAsString(QUEUE_CONNECTION_FACTORY_JNDI);
    }

    public void setQueueConnectionFactory(String qcf) {
        this.setProperty(QUEUE_CONNECTION_FACTORY_JNDI, qcf);
    }

    public String getSendQueue() {
        return this.getPropertyAsString(SEND_QUEUE);
    }

    public void setSendQueue(String name) {
        this.setProperty(SEND_QUEUE, name);
    }

    public String getReceiveQueue() {
        return this.getPropertyAsString(RECEIVE_QUEUE);
    }

    public void setReceiveQueue(String name) {
        this.setProperty(RECEIVE_QUEUE, name);
    }

    public String getContent() {
        return this.getPropertyAsString(XML_DATA);
    }

    public void setContent(String content) {
        this.setProperty(XML_DATA, content);
    }

    public boolean isOneway() {
        return this.getPropertyAsBoolean(IS_ONE_WAY);
    }

    public boolean isNonPersistent() {
        return this.getPropertyAsBoolean(IS_NON_PERSISTENT);
    }

    public boolean isUseReqMsgIdAsCorrelId() {
        return this.getPropertyAsBoolean(USE_REQ_MSGID_AS_CORRELID);
    }

    public boolean isUseResMsgIdAsCorrelId() {
        return this.getPropertyAsBoolean(USE_RES_MSGID_AS_CORRELID, false);
    }

    public String getInitialContextFactory() {
        return this.getPropertyAsString(JNDI_INITIAL_CONTEXT_FACTORY);
    }

    public String getContextProvider() {
        return this.getPropertyAsString(JNDI_CONTEXT_PROVIDER_URL);
    }

    public void setIsOneway(boolean isOneway) {
        this.setProperty((JMeterProperty)new BooleanProperty(IS_ONE_WAY, isOneway));
    }

    public void setNonPersistent(boolean value) {
        this.setProperty((JMeterProperty)new BooleanProperty(IS_NON_PERSISTENT, value));
    }

    public void setUseReqMsgIdAsCorrelId(boolean value) {
        this.setProperty((JMeterProperty)new BooleanProperty(USE_REQ_MSGID_AS_CORRELID, value));
    }

    public void setUseResMsgIdAsCorrelId(boolean value) {
        this.setProperty(USE_RES_MSGID_AS_CORRELID, value, false);
    }

    public String toString() {
        return this.getQueueConnectionFactory() + ", queue: " + this.getSendQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadStarted() {
        this.logThreadStart();
        Context context = null;
        this.thrown = null;
        try {
            context = this.getInitialContext();
            Object obj = context.lookup(this.getQueueConnectionFactory());
            if (!(obj instanceof QueueConnectionFactory)) {
                String msg = "QueueConnectionFactory expected, but got " + (obj != null ? obj.getClass().getName() : "null");
                LOGGER.fatalError(msg);
                throw new IllegalStateException(msg);
            }
            QueueConnectionFactory factory = (QueueConnectionFactory)obj;
            Queue sendQueue = (Queue)context.lookup(this.getSendQueue());
            if (!this.useTemporyQueue()) {
                this.receiveQueue = (Queue)context.lookup(this.getReceiveQueue());
                this.receiverThread = Receiver.createReceiver((ConnectionFactory)factory, (Destination)this.receiveQueue, this.getPrincipal(context), this.getCredentials(context), this.isUseResMsgIdAsCorrelId(), this.getJMSSelector());
            }
            String principal = null;
            String credentials = null;
            if (USE_SECURITY_PROPERTIES) {
                principal = this.getPrincipal(context);
                credentials = this.getCredentials(context);
            }
            this.connection = principal != null && credentials != null ? factory.createQueueConnection(principal, credentials) : factory.createQueueConnection();
            this.session = this.connection.createQueueSession(false, 1);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Session created");
            }
            if (this.getPropertyAsBoolean(IS_ONE_WAY)) {
                this.producer = this.session.createSender(sendQueue);
                if (this.isNonPersistent()) {
                    this.producer.setDeliveryMode(1);
                }
            } else if (this.useTemporyQueue()) {
                this.executor = new TemporaryQueueExecutor(this.session, sendQueue);
            } else {
                this.producer = this.session.createSender(sendQueue);
                if (this.isNonPersistent()) {
                    this.producer.setDeliveryMode(1);
                }
                this.executor = new FixedQueueExecutor((MessageProducer)this.producer, this.getTimeoutAsInt(), this.isUseReqMsgIdAsCorrelId());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Starting connection");
            }
            this.connection.start();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Connection started");
            }
        }
        catch (Exception e) {
            this.thrown = e;
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            this.thrown = e;
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException ignored) {}
            }
        }
    }

    private Context getInitialContext() throws NamingException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (this.getInitialContextFactory() != null && this.getInitialContextFactory().trim().length() > 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using InitialContext [" + this.getInitialContextFactory() + "]");
            }
            table.put("java.naming.factory.initial", this.getInitialContextFactory());
        }
        if (this.getContextProvider() != null && this.getContextProvider().trim().length() > 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using Provider [" + this.getContextProvider() + "]");
            }
            table.put("java.naming.provider.url", this.getContextProvider());
        }
        Map map = this.getArguments(JNDI_PROPERTIES).getArgumentsAsMap();
        if (LOGGER.isDebugEnabled()) {
            if (map.isEmpty()) {
                LOGGER.debug("Empty JNDI properties");
            } else {
                LOGGER.debug("Number of JNDI properties: " + map.size());
            }
        }
        for (Map.Entry me : map.entrySet()) {
            table.put((String)me.getKey(), (String)me.getValue());
        }
        InitialContext context = new InitialContext(table);
        if (LOGGER.isDebugEnabled()) {
            this.printEnvironment(context);
        }
        return context;
    }

    private void printEnvironment(Context context) throws NamingException {
        Hashtable<?, ?> env = context.getEnvironment();
        LOGGER.debug("Initial Context Properties");
        Enumeration<?> keys = env.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            LOGGER.debug(key + "=" + env.get(key));
        }
    }

    private void logThreadStart() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Thread started " + new Date());
            LOGGER.debug("JMSSampler: [" + Thread.currentThread().getName() + "], hashCode=[" + this.hashCode() + "]");
            LOGGER.debug("QCF: [" + this.getQueueConnectionFactory() + "], sendQueue=[" + this.getSendQueue() + "]");
            LOGGER.debug("Timeout             = " + this.getTimeout() + "]");
            LOGGER.debug("Use temporary queue =" + this.useTemporyQueue() + "]");
            LOGGER.debug("Reply queue         =" + this.getReceiveQueue() + "]");
        }
    }

    private int getTimeoutAsInt() {
        if (this.getPropertyAsInt(TIMEOUT) < 1) {
            return 2000;
        }
        return this.getPropertyAsInt(TIMEOUT);
    }

    public String getTimeout() {
        return this.getPropertyAsString(TIMEOUT, DEFAULT_TIMEOUT_STRING);
    }

    public void threadFinished() {
        LOGGER.debug("Thread ended " + new Date());
        Utils.close((Session)this.session, LOGGER);
        Utils.close((Connection)this.connection, LOGGER);
        if (this.receiverThread != null) {
            this.receiverThread.deactivate();
        }
    }

    private boolean useTemporyQueue() {
        String recvQueue = this.getReceiveQueue();
        return recvQueue == null || recvQueue.trim().length() == 0;
    }

    public void setArguments(Arguments args) {
        this.setProperty((JMeterProperty)new TestElementProperty(JMS_PROPERTIES, (TestElement)args));
    }

    public Arguments getArguments(String name) {
        return (Arguments)this.getProperty(name).getObjectValue();
    }

    public void setTimeout(String s) {
        this.setProperty(TIMEOUT, s);
    }

    public String getJMSSelector() {
        return this.getPropertyAsString(JMS_SELECTOR, JMS_SELECTOR_DEFAULT);
    }

    public void setJMSSelector(String selector) {
        this.setProperty(JMS_SELECTOR, selector, JMS_SELECTOR_DEFAULT);
    }

    public void setInitialContextFactory(String string) {
        this.setProperty(JNDI_INITIAL_CONTEXT_FACTORY, string);
    }

    public void setContextProvider(String string) {
        this.setProperty(JNDI_CONTEXT_PROVIDER_URL, string);
    }

    private String getPrincipal(Context context) throws NamingException {
        Hashtable<?, ?> env = context.getEnvironment();
        return (String)env.get("java.naming.security.principal");
    }

    private String getCredentials(Context context) throws NamingException {
        Hashtable<?, ?> env = context.getEnvironment();
        return (String)env.get("java.naming.security.credentials");
    }
}

