/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.naming.NamingException;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.jms.Utils;
import org.apache.jmeter.protocol.jms.client.ClientPool;
import org.apache.jmeter.protocol.jms.client.InitialContextFactory;
import org.apache.jmeter.protocol.jms.client.Publisher;
import org.apache.jmeter.protocol.jms.sampler.BaseJMSSampler;
import org.apache.jmeter.protocol.jms.sampler.JMSProperties;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.io.TextFile;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class PublisherSampler
extends BaseJMSSampler
implements TestStateListener {
    private static final long serialVersionUID = 233L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String INPUT_FILE = "jms.input_file";
    private static final String RANDOM_PATH = "jms.random_path";
    private static final String TEXT_MSG = "jms.text_message";
    private static final String CONFIG_CHOICE = "jms.config_choice";
    private static final String MESSAGE_CHOICE = "jms.config_msg_type";
    private static final String NON_PERSISTENT_DELIVERY = "jms.non_persistent";
    private static final String JMS_PROPERTIES = "jms.jmsProperties";
    private transient Publisher publisher = null;
    private static final FileServer FSERVER = FileServer.getFileServer();
    private String file_contents = null;
    private Serializable object_msg_file_contents = null;
    private byte[] bytes_msg_file_contents = null;
    private static final String USE_FILE_LOCALNAME = JMeterUtils.getResString((String)"jms_use_file");
    private static final String USE_RANDOM_LOCALNAME = JMeterUtils.getResString((String)"jms_use_random_file");

    public void testStarted(String test) {
        this.testStarted();
    }

    public void testEnded(String host) {
        this.testEnded();
    }

    public void testEnded() {
        log.debug("PublisherSampler.testEnded called");
        ClientPool.clearClient();
        InitialContextFactory.close();
    }

    public void testStarted() {
    }

    private void initClient() throws JMSException, NamingException {
        this.publisher = new Publisher(this.getUseJNDIPropertiesAsBoolean(), this.getJNDIInitialContextFactory(), this.getProviderUrl(), this.getConnectionFactory(), this.getDestination(), this.isUseAuth(), this.getUsername(), this.getPassword(), this.isDestinationStatic(), this.getUseNonPersistentDelivery());
        ClientPool.addClient(this.publisher);
        log.debug("PublisherSampler.initClient called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SampleResult sample() {
        SampleResult result = new SampleResult();
        result.setSampleLabel(this.getName());
        result.setSuccessful(false);
        result.setResponseCode("000");
        if (this.publisher == null) {
            try {
                this.initClient();
            }
            catch (JMSException e) {
                result.setResponseMessage(e.toString());
                return result;
            }
            catch (NamingException e) {
                result.setResponseMessage(e.toString());
                return result;
            }
        }
        StringBuilder buffer = new StringBuilder();
        StringBuilder propBuffer = new StringBuilder();
        int loop = this.getIterationCount();
        result.sampleStart();
        String type = this.getMessageChoice();
        try {
            Map<String, Object> msgProperties = this.getJMSProperties().getJmsPropertysAsMap();
            for (int idx = 0; idx < loop; ++idx) {
                Message msg;
                if ("jms_text_message".equals(type)) {
                    String tmsg = this.getMessageContent();
                    msg = this.publisher.publish(tmsg, this.getDestination(), msgProperties);
                    buffer.append(tmsg);
                    Utils.messageProperties(propBuffer, msg);
                    continue;
                }
                if ("jms_map_message".equals(type)) {
                    Map<String, Object> m = this.getMapContent();
                    msg = this.publisher.publish(m, this.getDestination(), msgProperties);
                    Utils.messageProperties(propBuffer, msg);
                    continue;
                }
                if ("jms_object_message".equals(type)) {
                    Serializable omsg = this.getObjectContent();
                    msg = this.publisher.publish(omsg, this.getDestination(), msgProperties);
                    Utils.messageProperties(propBuffer, msg);
                    continue;
                }
                if ("jms_bytes_message".equals(type)) {
                    byte[] bmsg = this.getBytesContent();
                    msg = this.publisher.publish(bmsg, this.getDestination(), msgProperties);
                    Utils.messageProperties(propBuffer, msg);
                    continue;
                }
                throw new JMSException(type + " is not recognised");
            }
            result.setResponseCodeOK();
            result.setResponseMessage(loop + " messages published");
            result.setSuccessful(true);
            result.setSamplerData(buffer.toString());
            result.setSampleCount(loop);
            result.setRequestHeaders(propBuffer.toString());
        }
        catch (Exception e) {
            result.setResponseMessage(e.toString());
        }
        finally {
            result.sampleEnd();
        }
        return result;
    }

    private Map<String, Object> getMapContent() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String[] lines;
        HashMap<String, Object> m = new HashMap<String, Object>();
        String text = this.getMessageContent();
        for (String line : lines = text.split("\n")) {
            Object obj;
            String[] parts = line.split(",", 3);
            if (parts.length != 3) {
                throw new IllegalArgumentException("line must have 3 parts: " + line);
            }
            String name = parts[0];
            String type = parts[1];
            if (!type.contains(".")) {
                type = "java.lang." + type;
            }
            String value = parts[2];
            if (type.equals("java.lang.String")) {
                obj = value;
            } else {
                Class<?> clazz = Class.forName(type);
                Method method = clazz.getMethod("valueOf", String.class);
                obj = method.invoke(clazz, value);
            }
            m.put(name, obj);
        }
        return m;
    }

    private String getMessageContent() {
        if (this.getConfigChoice().equals("jms_use_file")) {
            if (this.file_contents == null) {
                this.file_contents = this.getFileContent(this.getInputFile());
            }
            return this.file_contents;
        }
        if (this.getConfigChoice().equals("jms_use_random_file")) {
            String fname = FSERVER.getRandomFile(this.getRandomPath(), new String[]{".txt", ".obj"}).getAbsolutePath();
            return this.getFileContent(fname);
        }
        return this.getTextMessage();
    }

    public String getFileContent(String path) {
        TextFile tf = new TextFile(path);
        return tf.getText();
    }

    private Serializable getObjectContent() {
        if (this.getConfigChoice().equals("jms_use_file")) {
            if (this.object_msg_file_contents == null) {
                this.object_msg_file_contents = PublisherSampler.getFileObjectContent(this.getInputFile());
            }
            return this.object_msg_file_contents;
        }
        if (this.getConfigChoice().equals("jms_use_random_file")) {
            String fname = FSERVER.getRandomFile(this.getRandomPath(), new String[]{".txt", ".obj"}).getAbsolutePath();
            return PublisherSampler.getFileObjectContent(fname);
        }
        String xmlMessage = this.getTextMessage();
        return PublisherSampler.transformXmlToObjectMessage(xmlMessage);
    }

    private byte[] getBytesContent() {
        if (this.getConfigChoice().equals("jms_use_file")) {
            if (this.bytes_msg_file_contents == null) {
                this.bytes_msg_file_contents = PublisherSampler.getFileBytesContent(this.getInputFile());
            }
            return this.bytes_msg_file_contents;
        }
        if (this.getConfigChoice().equals("jms_use_random_file")) {
            String fname = FSERVER.getRandomFile(this.getRandomPath(), new String[]{".dat"}).getAbsolutePath();
            return PublisherSampler.getFileBytesContent(fname);
        }
        throw new IllegalArgumentException("Type of input not handled:" + this.getConfigChoice());
    }

    private static byte[] getFileBytesContent(String path) {
        byte[] byArray;
        BufferedInputStream inputStream = null;
        try {
            File file = new File(path);
            inputStream = new BufferedInputStream(new FileInputStream(file));
            byArray = IOUtils.toByteArray((InputStream)inputStream, (int)((int)file.length()));
        }
        catch (Exception e) {
            try {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new IllegalStateException("Unable to load file", e);
            }
            catch (Throwable throwable) {
                JOrphanUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        JOrphanUtils.closeQuietly((Closeable)inputStream);
        return byArray;
    }

    private static Serializable getFileObjectContent(String path) {
        Serializable readObject = null;
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(path));
            XStream xstream = new XStream();
            readObject = (Serializable)xstream.fromXML((InputStream)inputStream, readObject);
        }
        catch (Exception e) {
            try {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new IllegalStateException("Unable to load object instance from file", e);
            }
            catch (Throwable throwable) {
                JOrphanUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        JOrphanUtils.closeQuietly((Closeable)inputStream);
        return readObject;
    }

    private static Serializable transformXmlToObjectMessage(String xmlMessage) {
        Serializable readObject = null;
        try {
            XStream xstream = new XStream();
            readObject = (Serializable)xstream.fromXML(xmlMessage, readObject);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new IllegalStateException("Unable to load object instance from text", e);
        }
        return readObject;
    }

    public void setConfigChoice(String choice) {
        this.setProperty(CONFIG_CHOICE, choice);
    }

    public String getConfigChoice() {
        String config = this.getPropertyAsString(CONFIG_CHOICE);
        if (config.equals(USE_FILE_LOCALNAME) || config.equals("jms_use_file")) {
            return "jms_use_file";
        }
        if (config.equals(USE_RANDOM_LOCALNAME) || config.equals("jms_use_random_file")) {
            return "jms_use_random_file";
        }
        return config;
    }

    public void setMessageChoice(String choice) {
        this.setProperty(MESSAGE_CHOICE, choice);
    }

    public String getMessageChoice() {
        return this.getPropertyAsString(MESSAGE_CHOICE);
    }

    public void setInputFile(String file) {
        this.setProperty(INPUT_FILE, file);
    }

    public String getInputFile() {
        return this.getPropertyAsString(INPUT_FILE);
    }

    public void setRandomPath(String path) {
        this.setProperty(RANDOM_PATH, path);
    }

    public String getRandomPath() {
        return this.getPropertyAsString(RANDOM_PATH);
    }

    public void setTextMessage(String message) {
        this.setProperty(TEXT_MSG, message);
    }

    public String getTextMessage() {
        return this.getPropertyAsString(TEXT_MSG);
    }

    public void setUseNonPersistentDelivery(boolean value) {
        this.setProperty(NON_PERSISTENT_DELIVERY, value, false);
    }

    public boolean getUseNonPersistentDelivery() {
        return this.getPropertyAsBoolean(NON_PERSISTENT_DELIVERY, false);
    }

    public JMSProperties getJMSProperties() {
        Object o = this.getProperty(JMS_PROPERTIES).getObjectValue();
        JMSProperties jmsProperties = null;
        jmsProperties = o instanceof Arguments ? Utils.convertArgumentsToJmsProperties((Arguments)o) : (JMSProperties)o;
        if (jmsProperties == null) {
            jmsProperties = new JMSProperties();
            this.setJMSProperties(jmsProperties);
        }
        return jmsProperties;
    }

    public void setJMSProperties(JMSProperties jmsProperties) {
        this.setProperty((JMeterProperty)new TestElementProperty(JMS_PROPERTIES, (TestElement)jmsProperties));
    }
}

